/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCPotionData;
import com.laytonsmith.abstraction.MCPotionMeta;
import com.laytonsmith.abstraction.bukkit.BukkitMCColor;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemMeta;
import com.laytonsmith.abstraction.bukkit.BukkitMCPotionData;
import com.laytonsmith.abstraction.enums.MCPotionEffectType;
import com.laytonsmith.abstraction.enums.MCPotionType;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCPotionEffectType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCPotionType;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.potion.PotionType;

public class BukkitMCPotionMeta
extends BukkitMCItemMeta
implements MCPotionMeta {
    PotionMeta pm;

    public BukkitMCPotionMeta(PotionMeta pomet) {
        super((ItemMeta)pomet);
        this.pm = pomet;
    }

    @Override
    public MCPotionData getBasePotionData() {
        return new BukkitMCPotionData(ReflectionUtils.invokeMethod(PotionMeta.class, this.pm, "getBasePotionData"));
    }

    @Override
    public void setBasePotionData(MCPotionData bpd) {
        ReflectionUtils.invokeMethod(this.pm, "setBasePotionData", bpd.getHandle());
    }

    @Override
    public MCPotionType getBasePotionType() {
        PotionType type = this.pm.getBasePotionType();
        if (type == null) {
            return null;
        }
        return BukkitMCPotionType.valueOfConcrete(this.pm.getBasePotionType());
    }

    @Override
    public void setBasePotionType(MCPotionType pt) {
        if (pt == null) {
            this.pm.setBasePotionType(null);
        } else {
            this.pm.setBasePotionType((PotionType)pt.getConcrete());
        }
    }

    @Override
    public boolean addCustomEffect(MCPotionEffectType type, int strength, int ticks, boolean ambient, boolean particles, boolean icon, boolean force, Target t) {
        if (ticks < 0) {
            ticks = Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_19_4) ? -1 : Integer.MAX_VALUE;
        }
        PotionEffect pe = new PotionEffect((PotionEffectType)type.getConcrete(), ticks, strength, ambient, particles, icon);
        return this.pm.addCustomEffect(pe, force);
    }

    @Override
    public boolean clearCustomEffects() {
        return this.pm.clearCustomEffects();
    }

    @Override
    public List<MCLivingEntity.MCEffect> getCustomEffects() {
        ArrayList<MCLivingEntity.MCEffect> list = new ArrayList<MCLivingEntity.MCEffect>();
        for (PotionEffect pe : this.pm.getCustomEffects()) {
            list.add(new MCLivingEntity.MCEffect(BukkitMCPotionEffectType.valueOfConcrete(pe.getType()), pe.getAmplifier(), pe.getDuration(), pe.isAmbient(), pe.hasParticles(), pe.hasIcon()));
        }
        return list;
    }

    @Override
    public boolean hasCustomEffect(MCPotionEffectType type) {
        return this.pm.hasCustomEffect((PotionEffectType)type.getConcrete());
    }

    @Override
    public boolean hasCustomEffects() {
        return this.pm.hasCustomEffects();
    }

    @Override
    public boolean removeCustomEffect(MCPotionEffectType type) {
        return this.pm.removeCustomEffect((PotionEffectType)type.getConcrete());
    }

    @Override
    public boolean hasColor() {
        return this.pm.hasColor();
    }

    @Override
    public MCColor getColor() {
        return BukkitMCColor.GetMCColor(this.pm.getColor());
    }

    @Override
    public void setColor(MCColor color2) {
        this.pm.setColor(BukkitMCColor.GetColor(color2));
    }
}

