/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.ObjectHelpers;
import java.io.File;
import java.lang.management.ManagementFactory;

public class Target
implements Comparable<Target> {
    public static final Target UNKNOWN = new Target(0, null, 0, null);
    @ObjectHelpers.StandardField
    private final int line;
    @ObjectHelpers.StandardField
    private final File file;
    @ObjectHelpers.StandardField
    private final int col;
    @ObjectHelpers.StandardField
    private int length = 1;
    private boolean lengthSet = false;
    private String originalSet = null;
    private static final boolean IS_DEBUG = ManagementFactory.getRuntimeMXBean().getInputArguments().toString().contains("jdwp");

    private Target(int line, File file, int col, String ignored) {
        this.line = line;
        this.file = file;
        this.col = col;
    }

    public Target(int line, File file, int col) {
        if (line == 0 && col == 0 && file == null) {
            throw new RuntimeException("For efficiency sake, use Target.UNKNOWN instead of constructing a new Target.");
        }
        this.line = line;
        this.file = file;
        this.col = col;
    }

    public int line() {
        return this.line;
    }

    public File file() {
        return this.file;
    }

    public int col() {
        return this.col;
    }

    public int length() {
        return this.length;
    }

    public Target setLength(int length2) {
        if (this == UNKNOWN) {
            return this;
        }
        if (IS_DEBUG && this.lengthSet) {
            throw new RuntimeException("Length should not be set twice. Originally set at " + this.originalSet);
        }
        if (IS_DEBUG) {
            this.originalSet = StackTraceUtils.GetStacktrace(new Throwable());
        }
        this.length = length2;
        this.lengthSet = true;
        return this;
    }

    public Target copy() {
        if (this == UNKNOWN) {
            return this;
        }
        Target t = new Target(this.line(), this.file(), this.col());
        t.length = this.length;
        return t;
    }

    public String toString() {
        return (this.file != null ? this.file.getAbsolutePath() : "Unknown File") + ":" + this.line + "." + this.col;
    }

    @Override
    public int compareTo(Target t) {
        int ret;
        int n = this.file == null ? (t.file == null ? 0 : -1) : (ret = t.file == null ? 1 : this.file.getAbsolutePath().compareTo(t.file.getAbsolutePath()));
        if (ret != 0) {
            return ret;
        }
        ret = Integer.compare(this.line, t.line);
        if (ret != 0) {
            return ret;
        }
        return Integer.compare(this.col, t.col);
    }

    public boolean equals(Object obj) {
        return ObjectHelpers.DoEquals(this, obj);
    }

    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }
}

