/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client;

import com.laytonsmith.libs.com.squareup.okhttp.Interceptor;
import com.laytonsmith.libs.com.squareup.okhttp.MediaType;
import com.laytonsmith.libs.com.squareup.okhttp.Request;
import com.laytonsmith.libs.com.squareup.okhttp.RequestBody;
import com.laytonsmith.libs.com.squareup.okhttp.Response;
import com.laytonsmith.libs.okio.Buffer;
import com.laytonsmith.libs.okio.BufferedSink;
import com.laytonsmith.libs.okio.GzipSink;
import com.laytonsmith.libs.okio.Okio;
import java.io.IOException;

class GzipRequestInterceptor
implements Interceptor {
    GzipRequestInterceptor() {
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        Request originalRequest = chain.request();
        if (originalRequest.body() == null || originalRequest.header("Content-Encoding") != null) {
            return chain.proceed(originalRequest);
        }
        Request compressedRequest = originalRequest.newBuilder().header("Content-Encoding", "gzip").method(originalRequest.method(), this.forceContentLength(this.gzip(originalRequest.body()))).build();
        return chain.proceed(compressedRequest);
    }

    private RequestBody forceContentLength(final RequestBody requestBody) throws IOException {
        final Buffer buffer = new Buffer();
        requestBody.writeTo(buffer);
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return requestBody.contentType();
            }

            @Override
            public long contentLength() {
                return buffer.size();
            }

            @Override
            public void writeTo(BufferedSink sink2) throws IOException {
                sink2.write(buffer.snapshot());
            }
        };
    }

    private RequestBody gzip(final RequestBody body) {
        return new RequestBody(){

            @Override
            public MediaType contentType() {
                return body.contentType();
            }

            @Override
            public long contentLength() {
                return -1L;
            }

            @Override
            public void writeTo(BufferedSink sink2) throws IOException {
                BufferedSink gzipSink = Okio.buffer(new GzipSink(sink2));
                body.writeTo(gzipSink);
                gzipSink.close();
            }
        };
    }
}

