/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCCookingRecipe;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCRecipeChoice;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCRecipe;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCMaterial;
import com.laytonsmith.abstraction.enums.MCRecipeType;
import java.util.ArrayList;
import org.bukkit.Material;
import org.bukkit.inventory.CookingRecipe;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.Recipe;
import org.bukkit.inventory.RecipeChoice;

public class BukkitMCCookingRecipe
extends BukkitMCRecipe
implements MCCookingRecipe {
    private final MCRecipeType type;

    public BukkitMCCookingRecipe(Recipe recipe, MCRecipeType type) {
        super(recipe);
        this.type = type;
    }

    @Override
    public String getKey() {
        return this.getHandle().getKey().getKey();
    }

    @Override
    public MCRecipeType getRecipeType() {
        return this.type;
    }

    @Override
    public String getGroup() {
        return this.getHandle().getGroup();
    }

    @Override
    public void setGroup(String group) {
        this.getHandle().setGroup(group);
    }

    @Override
    public MCItemStack getResult() {
        return new BukkitMCItemStack(this.getHandle().getResult());
    }

    public CookingRecipe getHandle() {
        return (CookingRecipe)super.getHandle();
    }

    @Override
    public MCRecipeChoice getInput() {
        RecipeChoice recipeChoice = this.getHandle().getInputChoice();
        if (recipeChoice instanceof RecipeChoice.MaterialChoice) {
            RecipeChoice.MaterialChoice materialChoice = (RecipeChoice.MaterialChoice)recipeChoice;
            MCRecipeChoice.MaterialChoice choice = new MCRecipeChoice.MaterialChoice();
            for (Material material : materialChoice.getChoices()) {
                choice.addMaterial(BukkitMCMaterial.valueOfConcrete(material));
            }
            return choice;
        }
        if (recipeChoice instanceof RecipeChoice.ExactChoice) {
            RecipeChoice.ExactChoice exactChoice = (RecipeChoice.ExactChoice)recipeChoice;
            MCRecipeChoice.ExactChoice choice = new MCRecipeChoice.ExactChoice();
            for (ItemStack itemStack : exactChoice.getChoices()) {
                choice.addItem(new BukkitMCItemStack(itemStack));
            }
            return choice;
        }
        throw new UnsupportedOperationException("Unsupported recipe choice");
    }

    @Override
    public void setInput(MCItemStack input) {
        this.getHandle().setInputChoice((RecipeChoice)new RecipeChoice.ExactChoice((ItemStack)input.getHandle()));
    }

    @Override
    public void setInput(MCMaterial mat) {
        this.getHandle().setInput((Material)mat.getHandle());
    }

    @Override
    public void setInput(MCRecipeChoice choice) {
        if (choice instanceof MCRecipeChoice.ExactChoice) {
            ArrayList<ItemStack> itemChoice = new ArrayList<ItemStack>();
            for (MCItemStack itemStack : ((MCRecipeChoice.ExactChoice)choice).getItems()) {
                itemChoice.add((ItemStack)itemStack.getHandle());
            }
            this.getHandle().setInputChoice((RecipeChoice)new RecipeChoice.ExactChoice(itemChoice));
        } else if (choice instanceof MCRecipeChoice.MaterialChoice) {
            ArrayList<Material> materialChoice = new ArrayList<Material>();
            for (MCMaterial material : ((MCRecipeChoice.MaterialChoice)choice).getMaterials()) {
                materialChoice.add((Material)material.getHandle());
            }
            this.getHandle().setInputChoice((RecipeChoice)new RecipeChoice.MaterialChoice(materialChoice));
        }
    }

    @Override
    public int getCookingTime() {
        return this.getHandle().getCookingTime();
    }

    @Override
    public void setCookingTime(int ticks) {
        this.getHandle().setCookingTime(ticks);
    }

    @Override
    public float getExperience() {
        return this.getHandle().getExperience();
    }

    @Override
    public void setExperience(float exp) {
        this.getHandle().setExperience(exp);
    }
}

