/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.enums.EnumConvertor;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.annotations.abstractionenum;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.Target;
import java.lang.reflect.Method;

public final class Implementation {
    private static Type serverType = null;
    private static boolean useAbstractEnumThread = true;

    private Implementation() {
    }

    public static void useAbstractEnumThread(boolean on) {
        useAbstractEnumThread = on;
    }

    public static void forceServerType(Type type) {
        serverType = type;
    }

    public static void setServerType(Type type) {
        if (serverType == null) {
            serverType = type;
        } else if (type != Type.TEST) {
            throw new RuntimeException("Server type is already set! Cannot re-set!");
        }
        if (type == Type.TEST || type == Type.SHELL || !useAbstractEnumThread) {
            return;
        }
        Thread abstractionenumsThread = new Thread(() -> {
            try {
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                for (Class<?> c : ClassDiscovery.getDefaultInstance().loadClassesWithAnnotation(abstractionenum.class)) {
                    EnumConvertor convertor;
                    abstractionenum annotation = c.getAnnotation(abstractionenum.class);
                    if (!EnumConvertor.class.isAssignableFrom(c)) {
                        throw new Error("Only classes that extend EnumConvertor may use @abstractionenum. " + c.getName() + " does not, yet it uses the annotation.");
                    }
                    if (annotation.implementation() != serverType) continue;
                    try {
                        Method m = c.getDeclaredMethod("getConvertor", new Class[0]);
                        convertor = (EnumConvertor)m.invoke(null, new Object[0]);
                    }
                    catch (NoSuchMethodException ex) {
                        throw new Error("The method with signature public static " + c.getName() + " getConvertor() was not found in " + c.getName() + ". Please add the following code: \nprivate static " + c.getName() + " instance;\npublic static " + c.getName() + " getConvertor(){\n\tif(instance == null){\n\t\tinstance = new " + c.getName() + "();\n\t}\n\treturn instance;\n}\nIf you do not know what error is, please report this to the developers.");
                    }
                    if (!MSLog.GetLogger().WillLog(MSLog.Tags.GENERAL, LogLevel.WARNING)) continue;
                    Class<? extends Enum> abstractEnum = annotation.forAbstractEnum();
                    Class<? extends Enum> concreteEnum = annotation.forConcreteEnum();
                    Implementation.checkAbstractEnumConversion(convertor, abstractEnum, concreteEnum);
                    Implementation.checkConcreteEnumConversion(convertor, concreteEnum, abstractEnum);
                }
            }
            catch (Exception e) {
                MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, e, Target.UNKNOWN);
            }
        }, "Abstraction Enum Verification Thread");
        abstractionenumsThread.setPriority(1);
        abstractionenumsThread.setDaemon(true);
        abstractionenumsThread.start();
    }

    private static void checkAbstractEnumConversion(EnumConvertor convertor, Class<? extends Enum> abstracted, Class<? extends Enum> concrete) {
        for (Enum abstractValue : abstracted.getEnumConstants()) {
            Deprecated deprecated;
            Enum enumConcrete;
            try {
                enumConcrete = (Enum)ReflectionUtils.invokeMethod(convertor, "getConcreteEnumCustom", abstractValue);
                deprecated = concrete.getField(enumConcrete.name()).getAnnotation(Deprecated.class);
            }
            catch (ReflectionUtils.ReflectionException | NoSuchFieldException ex) {
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, abstracted.getSimpleName() + "." + abstractValue.name() + " cannot be converted to " + concrete.getSimpleName(), Target.UNKNOWN);
                continue;
            }
            if (deprecated == null) continue;
            if (deprecated.since().isEmpty()) {
                MSLog.GetLogger().i(MSLog.Tags.GENERAL, concrete.getSimpleName() + "." + enumConcrete.name() + " is deprecated", Target.UNKNOWN);
                continue;
            }
            if (MCVersion.match(deprecated.since().split("\\.")).lte(MCVersion.EARLIEST_SUPPORTED)) {
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, concrete.getSimpleName() + "." + enumConcrete.name() + " is deprecated since " + deprecated.since(), Target.UNKNOWN);
                continue;
            }
            MSLog.GetLogger().i(MSLog.Tags.GENERAL, concrete.getSimpleName() + "." + enumConcrete.name() + " is deprecated since " + deprecated.since(), Target.UNKNOWN);
        }
    }

    private static void checkConcreteEnumConversion(EnumConvertor convertor, Class<? extends Enum> concrete, Class<? extends Enum> abstracted) {
        for (Enum concreteValue : concrete.getEnumConstants()) {
            try {
                ReflectionUtils.invokeMethod(convertor, "getAbstractedEnumCustom", concreteValue);
            }
            catch (ReflectionUtils.ReflectionException ex) {
                try {
                    if (concrete.getField(concreteValue.name()).getAnnotation(Deprecated.class) != null) continue;
                    MSLog.GetLogger().w(MSLog.Tags.GENERAL, concrete.getSimpleName() + "." + concreteValue.name() + " cannot be converted to " + abstracted.getSimpleName(), Target.UNKNOWN);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
        }
    }

    public static Type GetServerType() {
        if (serverType == null) {
            throw new RuntimeException("Server type has not been set yet! Please call Implementation.setServerType with the appropriate implementation.");
        }
        return serverType;
    }

    public static enum Type {
        TEST("test-backend"),
        BUKKIT("CommandHelper"),
        SHELL("MethodScript"),
        SPONGE("CommandHelper");

        private final String branding;

        private Type(String branding) {
            this.branding = branding;
        }

        public String getBranding() {
            return this.branding;
        }
    }
}

