/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.geometric;

import com.laytonsmith.libs.org.postgresql.geometric.PGpoint;
import com.laytonsmith.libs.org.postgresql.util.GT;
import com.laytonsmith.libs.org.postgresql.util.PGobject;
import com.laytonsmith.libs.org.postgresql.util.PGtokenizer;
import com.laytonsmith.libs.org.postgresql.util.PSQLException;
import com.laytonsmith.libs.org.postgresql.util.PSQLState;
import java.io.Serializable;
import java.sql.SQLException;

public class PGline
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] point = new PGpoint[2];

    public PGline(double x1, double y1, double x2, double y2) {
        this(new PGpoint(x1, y1), new PGpoint(x2, y2));
    }

    public PGline(PGpoint p1, PGpoint p2) {
        this();
        this.point[0] = p1;
        this.point[1] = p2;
    }

    public PGline(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGline() {
        this.setType("line");
    }

    @Override
    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removeBox(s), ',');
        if (t.getSize() != 2) {
            throw new PSQLException(GT.tr("Conversion to type {0} failed: {1}.", new Object[]{this.type, s}), PSQLState.DATA_TYPE_MISMATCH);
        }
        this.point[0] = new PGpoint(t.getToken(0));
        this.point[1] = new PGpoint(t.getToken(1));
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGline) {
            PGline p2 = (PGline)obj;
            return p2.point[0].equals(this.point[0]) && p2.point[1].equals(this.point[1]) || p2.point[0].equals(this.point[1]) && p2.point[1].equals(this.point[0]);
        }
        return false;
    }

    public int hashCode() {
        return this.point[0].hashCode() ^ this.point[1].hashCode();
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGline newPGline = (PGline)super.clone();
        if (newPGline.point != null) {
            newPGline.point = (PGpoint[])newPGline.point.clone();
            for (int i = 0; i < newPGline.point.length; ++i) {
                if (newPGline.point[i] == null) continue;
                newPGline.point[i] = (PGpoint)newPGline.point[i].clone();
            }
        }
        return newPGline;
    }

    @Override
    public String getValue() {
        return "[" + this.point[0] + "," + this.point[1] + "]";
    }
}

