/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.enums.MCTrimMaterial;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.inventory.meta.trim.TrimMaterial;

public class BukkitMCTrimMaterial
extends MCTrimMaterial<TrimMaterial> {
    private static final Map<TrimMaterial, MCTrimMaterial> BUKKIT_MAP = new HashMap<TrimMaterial, MCTrimMaterial>();

    public BukkitMCTrimMaterial(MCTrimMaterial.MCVanillaTrimMaterial vanillaTrimMaterial, TrimMaterial trimMaterial) {
        super(vanillaTrimMaterial, trimMaterial);
    }

    @Override
    public String name() {
        if (this.getAbstracted() == MCTrimMaterial.MCVanillaTrimMaterial.UNKNOWN) {
            return ((TrimMaterial)this.getConcrete()).getKey().getKey().toUpperCase();
        }
        return ((MCTrimMaterial.MCVanillaTrimMaterial)((Object)this.getAbstracted())).name();
    }

    public static MCTrimMaterial valueOfConcrete(TrimMaterial test) {
        MCTrimMaterial trimMaterial = BUKKIT_MAP.get(test);
        if (trimMaterial == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Trim Material missing in BUKKIT_MAP: " + String.valueOf(test), Target.UNKNOWN);
            return new BukkitMCTrimMaterial(MCTrimMaterial.MCVanillaTrimMaterial.UNKNOWN, test);
        }
        return trimMaterial;
    }

    public static void build() {
        BukkitMCTrimMaterial wrapper;
        TrimMaterial trimMaterial;
        for (MCTrimMaterial.MCVanillaTrimMaterial mCVanillaTrimMaterial : MCTrimMaterial.MCVanillaTrimMaterial.values()) {
            if (mCVanillaTrimMaterial == MCTrimMaterial.MCVanillaTrimMaterial.UNKNOWN) continue;
            try {
                trimMaterial = (TrimMaterial)TrimMaterial.class.getField(mCVanillaTrimMaterial.name()).get(null);
            }
            catch (IllegalAccessException | NoSuchFieldException ex) {
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find a Bukkit trim material type for " + mCVanillaTrimMaterial.name(), Target.UNKNOWN);
                continue;
            }
            wrapper = new BukkitMCTrimMaterial(mCVanillaTrimMaterial, trimMaterial);
            MAP.put(mCVanillaTrimMaterial.name(), wrapper);
            BUKKIT_MAP.put(trimMaterial, wrapper);
        }
        for (Field field : TrimMaterial.class.getFields()) {
            try {
                trimMaterial = (TrimMaterial)field.get(null);
                if (BUKKIT_MAP.containsKey(trimMaterial)) continue;
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find MCTrimMaterial for " + field.getName(), Target.UNKNOWN);
                wrapper = new BukkitMCTrimMaterial(MCTrimMaterial.MCVanillaTrimMaterial.UNKNOWN, trimMaterial);
                MAP.put(field.getName(), wrapper);
                BUKKIT_MAP.put(trimMaterial, wrapper);
            }
            catch (ClassCastException | IllegalAccessException exception) {
                // empty catch block
            }
        }
    }
}

