/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.io.gsonfire.util;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.ParseException;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class RFC3339DateFormat
extends DateFormat {
    private static final Pattern TIMEZONE_PATTERN = Pattern.compile("(.*)([+-][0-9][0-9])\\:?([0-9][0-9])$");
    private static final Pattern MILLISECONDS_PATTERN = Pattern.compile("(.*)\\.([0-9]+)(.*)");
    private static final Pattern DATE_ONLY_PATTERN = Pattern.compile("^[0-9]{1,4}-[0-1][0-9]-[0-3][0-9]$");
    private final SimpleDateFormat rfc3339Parser = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final SimpleDateFormat rfc3339Formatter;
    private final boolean serializeTime;
    private final boolean threeDigitMillis;

    public RFC3339DateFormat(TimeZone serializationTimezone, boolean serializeTime, boolean threeDigitMillis) {
        this.rfc3339Formatter = serializeTime ? new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss") : new SimpleDateFormat("yyyy-MM-dd");
        this.serializeTime = serializeTime;
        this.threeDigitMillis = threeDigitMillis;
        this.rfc3339Formatter.setTimeZone(serializationTimezone);
    }

    public RFC3339DateFormat(TimeZone serializationTimezone, boolean serializeTime) {
        this(serializationTimezone, serializeTime, false);
    }

    public RFC3339DateFormat(TimeZone serializationTimezone) {
        this(serializationTimezone, true, false);
    }

    public RFC3339DateFormat(boolean serializeTime, boolean threeDigitMillis) {
        this(TimeZone.getTimeZone("UTC"), serializeTime, threeDigitMillis);
    }

    public RFC3339DateFormat(boolean serializeTime) {
        this(serializeTime, false);
    }

    public RFC3339DateFormat() {
        this(true);
    }

    private String generateTimezone(long time2, TimeZone serializationTimezone) {
        if (serializationTimezone.getOffset(time2) == 0) {
            return "Z";
        }
        int offset = (int)((long)serializationTimezone.getOffset(time2) / 1000L);
        int hours = offset / 3600;
        int minutes = Math.abs((offset - hours * 3600) / 60);
        String sign = hours >= 0 ? "+" : "-";
        return sign + String.format("%02d", Math.abs(hours)) + ":" + String.format("%02d", minutes);
    }

    @Override
    public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition fieldPosition) {
        StringBuffer formatted = new StringBuffer();
        formatted.append(this.rfc3339Formatter.format(date).toString());
        if (this.serializeTime) {
            long time2 = date.getTime();
            long millis = time2 % 1000L;
            String fraction = String.format("%03d", millis);
            if (!this.threeDigitMillis) {
                fraction = fraction.replaceAll("0*$", "");
            }
            if (!fraction.isEmpty()) {
                formatted.append("." + fraction);
            }
            String timezoneStr = this.generateTimezone(time2, this.rfc3339Formatter.getTimeZone());
            formatted.append(timezoneStr);
        }
        return formatted;
    }

    @Override
    public Date parse(String source2, ParsePosition pos) {
        Matcher matcher;
        if (DATE_ONLY_PATTERN.matcher(source2).matches()) {
            source2 = source2 + "T00:00:00-0000";
        } else if (source2.charAt(10) == 't') {
            source2 = source2.substring(0, 10) + "T" + source2.substring(12);
        }
        int millis = 0;
        if (source2.contains(".")) {
            matcher = MILLISECONDS_PATTERN.matcher(source2);
            String millisStr = matcher.replaceAll("$2");
            millis = (int)Math.round(Double.parseDouble("0." + millisStr) * 1000.0);
            source2 = matcher.replaceAll("$1") + matcher.replaceAll("$3");
        }
        source2 = source2.endsWith("Z") || source2.endsWith("z") ? source2.substring(0, source2.length() - 1) + "-0000" : ((matcher = TIMEZONE_PATTERN.matcher(source2)).matches() ? matcher.replaceAll("$1") + matcher.replaceAll("$2") + matcher.replaceAll("$3") : source2 + "-0000");
        try {
            Date res = this.rfc3339Parser.parse(source2);
            if (millis > 0) {
                res = new Date(res.getTime() + (long)millis);
            }
            pos.setIndex(source2.length());
            return res;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

