/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.LayoutStyle;

class LogViewer
extends JDialog {
    private String lastLog = UUID.randomUUID().toString();
    private JButton buttonHide;
    private JCheckBox checkboxAlwaysOnTop;
    private JCheckBox checkboxFollowTail;
    private JScrollPane scrollPaneLog;
    private JTextArea textAreaLog;

    public LogViewer(Frame parent) {
        super(parent, false);
        this.initComponents();
    }

    void pushLog(String status) {
        if (this.lastLog.equals(status)) {
            return;
        }
        this.textAreaLog.append("[" + new SimpleDateFormat("HH:mm:ss").format(new Date()) + "] " + status + "\n");
        this.lastLog = status;
        if (this.checkboxFollowTail.isSelected()) {
            JScrollBar vertical = this.scrollPaneLog.getVerticalScrollBar();
            vertical.setValue(vertical.getMaximum());
        }
    }

    private void initComponents() {
        this.scrollPaneLog = new JScrollPane();
        this.textAreaLog = new JTextArea();
        this.buttonHide = new JButton();
        this.checkboxAlwaysOnTop = new JCheckBox();
        this.checkboxFollowTail = new JCheckBox();
        this.setTitle("Log Viewer");
        this.textAreaLog.setEditable(false);
        this.textAreaLog.setColumns(20);
        this.textAreaLog.setLineWrap(true);
        this.textAreaLog.setRows(5);
        this.textAreaLog.setText("---- Logs ----\n");
        this.textAreaLog.setWrapStyleWord(true);
        this.scrollPaneLog.setViewportView(this.textAreaLog);
        this.buttonHide.setText("Hide");
        this.buttonHide.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.buttonHideActionPerformed(evt);
            }
        });
        this.checkboxAlwaysOnTop.setText("Always on top");
        this.checkboxAlwaysOnTop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LogViewer.this.checkboxAlwaysOnTopActionPerformed(evt);
            }
        });
        this.checkboxFollowTail.setText("Follow Tail");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 460, Short.MAX_VALUE).addComponent(this.checkboxFollowTail).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.checkboxAlwaysOnTop).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonHide)).addComponent(this.scrollPaneLog)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.scrollPaneLog, -1, 239, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buttonHide).addComponent(this.checkboxAlwaysOnTop).addComponent(this.checkboxFollowTail)).addContainerGap()));
        this.pack();
    }

    private void checkboxAlwaysOnTopActionPerformed(ActionEvent evt) {
        this.setAlwaysOnTop(this.checkboxAlwaysOnTop.isSelected());
    }

    private void buttonHideActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }
}

