/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis.params;

import com.laytonsmith.libs.redis.clients.jedis.CommandArguments;
import com.laytonsmith.libs.redis.clients.jedis.Protocol;
import com.laytonsmith.libs.redis.clients.jedis.args.Rawable;
import com.laytonsmith.libs.redis.clients.jedis.args.RawableFactory;
import com.laytonsmith.libs.redis.clients.jedis.params.IParams;

public class ZRangeParams
implements IParams {
    private final Protocol.Keyword by;
    private final Rawable min;
    private final Rawable max;
    private boolean rev = false;
    private boolean limit = false;
    private int offset;
    private int count;

    private ZRangeParams() {
        throw new InstantiationError("Empty constructor must not be called.");
    }

    public ZRangeParams(int min2, int max2) {
        this.by = null;
        this.min = RawableFactory.from(min2);
        this.max = RawableFactory.from(max2);
    }

    public static ZRangeParams zrangeParams(int min2, int max2) {
        return new ZRangeParams(min2, max2);
    }

    public ZRangeParams(double min2, double max2) {
        this.by = Protocol.Keyword.BYSCORE;
        this.min = RawableFactory.from(min2);
        this.max = RawableFactory.from(max2);
    }

    public static ZRangeParams zrangeByScoreParams(double min2, double max2) {
        return new ZRangeParams(min2, max2);
    }

    private ZRangeParams(Protocol.Keyword by, Rawable min2, Rawable max2) {
        if (by != null && by != Protocol.Keyword.BYSCORE && by != Protocol.Keyword.BYLEX) {
            throw new IllegalArgumentException(by.name() + " is not a valid ZRANGE type argument.");
        }
        this.by = by;
        this.min = min2;
        this.max = max2;
    }

    public ZRangeParams(Protocol.Keyword by, String min2, String max2) {
        this(by, RawableFactory.from(min2), RawableFactory.from(max2));
    }

    public ZRangeParams(Protocol.Keyword by, byte[] min2, byte[] max2) {
        this(by, RawableFactory.from(min2), RawableFactory.from(max2));
    }

    public static ZRangeParams zrangeByLexParams(String min2, String max2) {
        return new ZRangeParams(Protocol.Keyword.BYLEX, min2, max2);
    }

    public static ZRangeParams zrangeByLexParams(byte[] min2, byte[] max2) {
        return new ZRangeParams(Protocol.Keyword.BYLEX, min2, max2);
    }

    public ZRangeParams rev() {
        this.rev = true;
        return this;
    }

    public ZRangeParams limit(int offset, int count) {
        this.limit = true;
        this.offset = offset;
        this.count = count;
        return this;
    }

    @Override
    public void addParams(CommandArguments args) {
        args.add(this.min).add(this.max);
        if (this.by != null) {
            args.add(this.by);
        }
        if (this.rev) {
            args.add(Protocol.Keyword.REV);
        }
        if (this.limit) {
            args.add(Protocol.Keyword.LIMIT).add(this.offset).add(this.count);
        }
    }
}

