/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.apache.commons.io.output.CloseShieldOutputStream;

public class CommandExecutor {
    private String[] args;
    private Process process;
    private InputStream in;
    private OutputStream out;
    private OutputStream err;
    private File workingDir = null;
    private Thread outThread;
    private Thread errThread;
    private Thread inThread;
    private boolean inheritStandards = false;
    private Map<String, String> env = new HashMap<String, String>();

    public static void ExecuteWithRedirect(String command) throws IOException, InterruptedException {
        CommandExecutor.ExecuteWithRedirect(CommandExecutor.StringToArray(command));
    }

    public static int ExecuteWithRedirect(String ... command) throws InterruptedException, IOException {
        CommandExecutor exec = new CommandExecutor(command);
        exec.setSystemInputsAndOutputs();
        exec.start();
        return exec.waitFor();
    }

    public static String Execute(String command) throws InterruptedException, IOException {
        return CommandExecutor.Execute(new File("."), command);
    }

    public static String Execute(File workingDir, String command) throws InterruptedException, IOException {
        return CommandExecutor.Execute(CommandExecutor.StringToArray(command));
    }

    public static String Execute(String ... args) throws InterruptedException, IOException {
        return CommandExecutor.Execute(new File("."), args);
    }

    public static String Execute(File workingDir, String ... args) throws InterruptedException, IOException {
        final ArrayList output = new ArrayList();
        CommandExecutor c = new CommandExecutor(args);
        c.setWorkingDir(workingDir);
        BufferedOutputStream os = new BufferedOutputStream(new OutputStream(){

            @Override
            public void write(int next) throws IOException {
                output.add((byte)next);
            }
        });
        c.setSystemOut(os);
        c.start();
        c.waitFor();
        byte[] bytes = new byte[output.size()];
        for (int i = 0; i < output.size(); ++i) {
            bytes[i] = (Byte)output.get(i);
        }
        return new String(bytes, "UTF-8");
    }

    private static String[] StringToArray(String s) {
        List<String> argList = StringUtils.ArgParser(s);
        String[] args = new String[argList.size()];
        args = argList.toArray(args);
        return args;
    }

    public CommandExecutor(String command) {
        this(CommandExecutor.StringToArray(command));
    }

    public CommandExecutor(String ... command) {
        this.args = command;
    }

    public void setEnvironmentVariable(String name, String value) {
        this.env.put(name, value);
    }

    public void setEnvironmentVariables(Map<String, String> env) {
        this.env.putAll(env);
    }

    public CommandExecutor start() throws IOException {
        ProcessBuilder builder = new ProcessBuilder(this.args);
        if (this.inheritStandards) {
            builder.redirectError(ProcessBuilder.Redirect.INHERIT);
            builder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
            builder.redirectInput(ProcessBuilder.Redirect.INHERIT);
        }
        builder.environment().putAll(this.env);
        builder.directory(this.workingDir);
        this.process = builder.start();
        this.outThread = new Thread(() -> {
            try (BufferedInputStream bout = new BufferedInputStream(this.process.getInputStream());){
                int ret;
                while ((ret = ((InputStream)bout).read()) != -1) {
                    if (this.out == null) continue;
                    this.out.write(ret);
                }
                if (this.out != null) {
                    this.out.flush();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CommandExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (this.out != null) {
                    try {
                        this.out.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(CommandExecutor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }, Arrays.toString(this.args) + "-output");
        this.outThread.start();
        this.errThread = new Thread(() -> {
            try (BufferedInputStream berr = new BufferedInputStream(this.process.getErrorStream());){
                int ret;
                while ((ret = ((InputStream)berr).read()) != -1) {
                    if (this.err == null) continue;
                    this.err.write(ret);
                }
                if (this.err != null) {
                    this.err.flush();
                }
            }
            catch (IOException ex) {
                Logger.getLogger(CommandExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
            finally {
                if (this.err != null) {
                    try {
                        this.err.close();
                    }
                    catch (IOException ex) {
                        Logger.getLogger(CommandExecutor.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
        }, Arrays.toString(this.args) + "-error");
        this.errThread.start();
        if (this.in != null) {
            this.inThread = new Thread(() -> {
                BufferedOutputStream bin = new BufferedOutputStream(this.process.getOutputStream());
                try (BufferedReader br = new BufferedReader(new InputStreamReader(this.in));){
                    while (!this.inThread.isInterrupted()) {
                        int ret;
                        if (br.ready() && (ret = br.read()) != -1) {
                            ((OutputStream)bin).write(ret);
                        }
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException ex) {
                            this.inThread.interrupt();
                        }
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(CommandExecutor.class.getName()).log(Level.SEVERE, null, ex);
                }
            }, Arrays.toString(this.args) + "-input");
            this.inThread.start();
        }
        return this;
    }

    public CommandExecutor setSystemIn(InputStream input) {
        if (this.process != null) {
            throw new RuntimeException("Process is already started! Cannot set a new InputStream!");
        }
        this.in = input;
        return this;
    }

    public CommandExecutor setSystemOut(OutputStream output) {
        if (this.process != null) {
            throw new RuntimeException("Process is already started! Cannot set a new InputStream!");
        }
        this.out = output;
        return this;
    }

    public CommandExecutor setSystemErr(OutputStream error) {
        if (this.process != null) {
            throw new RuntimeException("Process is already started! Cannot set a new OutputStream!");
        }
        this.err = error;
        return this;
    }

    public InputStream getSystemIn() {
        return this.in;
    }

    public OutputStream getSystemOut() {
        return this.out;
    }

    public OutputStream getSystemErr() {
        return this.err;
    }

    public CommandExecutor setWorkingDir(File workingDir) {
        if (this.process != null) {
            throw new RuntimeException("Process is already started! Cannot set a new working directory!");
        }
        this.workingDir = workingDir;
        return this;
    }

    public int waitFor() throws InterruptedException {
        int ret = this.process.waitFor();
        if (this.out != null) {
            try {
                this.out.flush();
            }
            catch (IOException ex) {
                Logger.getLogger(CommandExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        if (this.err != null) {
            try {
                this.err.flush();
            }
            catch (IOException ex) {
                Logger.getLogger(CommandExecutor.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        this.outThread.join();
        this.errThread.join();
        if (this.inThread != null) {
            this.inThread.interrupt();
        }
        return ret;
    }

    public CommandExecutor setSystemInputsAndOutputs() {
        this.setSystemOut((OutputStream)new CloseShieldOutputStream((OutputStream)StreamUtils.GetSystemOut()));
        this.setSystemErr((OutputStream)new CloseShieldOutputStream((OutputStream)StreamUtils.GetSystemErr()));
        this.setSystemIn((InputStream)new CloseShieldInputStream(System.in));
        this.inheritStandards = true;
        return this;
    }
}

