/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.compiler;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.core.compiler.EarlyBindingKeyword;
import com.laytonsmith.core.compiler.Keyword;
import com.laytonsmith.core.compiler.KeywordDocumentation;
import com.laytonsmith.core.compiler.LateBindingKeyword;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KeywordList {
    private static Map<String, Keyword> keywordList;
    private static Map<String, EarlyBindingKeyword> earlyKeywordList;
    private static Map<String, LateBindingKeyword> lateKeywordList;

    public static void refreshKeywordList() {
        Set<Class<Keyword>> keywords = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(Keyword.keyword.class, Keyword.class);
        keywordList = new HashMap<String, Keyword>();
        for (Class<Keyword> k : keywords) {
            if (k == Keyword.class) continue;
            try {
                Keyword keyword2 = k.newInstance();
                keywordList.put(keyword2.getKeywordName(), keyword2);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                Logger.getLogger(KeywordList.class.getName()).log(Level.SEVERE, null, reflectiveOperationException);
            }
        }
        Set<Class<EarlyBindingKeyword>> earlyKeywords = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(Keyword.keyword.class, EarlyBindingKeyword.class);
        earlyKeywordList = new HashMap<String, EarlyBindingKeyword>();
        for (Class clazz : earlyKeywords) {
            if (clazz == EarlyBindingKeyword.class) continue;
            try {
                EarlyBindingKeyword kk = (EarlyBindingKeyword)clazz.newInstance();
                earlyKeywordList.put(kk.getKeywordName(), kk);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(KeywordList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        Set<Class<LateBindingKeyword>> lateKeywords = ClassDiscovery.getDefaultInstance().loadClassesWithAnnotationThatExtend(Keyword.keyword.class, LateBindingKeyword.class);
        lateKeywordList = new HashMap<String, LateBindingKeyword>();
        for (Class<LateBindingKeyword> k : lateKeywords) {
            if (k == LateBindingKeyword.class) continue;
            try {
                LateBindingKeyword kk = k.newInstance();
                lateKeywordList.put(kk.getKeywordName(), kk);
            }
            catch (IllegalAccessException | InstantiationException ex) {
                Logger.getLogger(KeywordList.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static Set<String> getKeywordNames() {
        HashSet<String> ret = new HashSet<String>(keywordList.keySet());
        ret.addAll(earlyKeywordList.keySet());
        ret.addAll(lateKeywordList.keySet());
        return ret;
    }

    public static Set<KeywordDocumentation> getKeywordList() {
        HashSet<KeywordDocumentation> ret = new HashSet<KeywordDocumentation>(keywordList.values());
        ret.addAll(earlyKeywordList.values());
        ret.addAll(lateKeywordList.values());
        return ret;
    }

    public static Keyword getKeywordByName(String name) {
        return keywordList.get(name);
    }

    public static Set<EarlyBindingKeyword> getEarlyBindingKeywordList() {
        return new HashSet<EarlyBindingKeyword>(earlyKeywordList.values());
    }

    public static Set<LateBindingKeyword> getLateBindingKeywordList() {
        return new HashSet<LateBindingKeyword>(lateKeywordList.values());
    }

    public static EarlyBindingKeyword getEarlyBindingKeywordByName(String name) {
        return earlyKeywordList.get(name);
    }

    public static LateBindingKeyword getLateBindingKeywordByName(String name) {
        return lateKeywordList.get(name);
    }

    static {
        KeywordList.refreshKeywordList();
    }
}

