/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.eclipse.lsp4j.jsonrpc.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;

public final class ToStringBuilder {
    private static ToStringContext toStringContext = ToStringContext.INSTANCE;
    private final Object instance;
    private final String typeName;
    private boolean multiLine = true;
    private boolean skipNulls = false;
    private boolean showFieldNames = true;
    private boolean prettyPrint = true;
    private final List<Part> parts = new ArrayList<Part>();

    public ToStringBuilder(Object instance) {
        this.instance = instance;
        this.typeName = instance.getClass().getSimpleName();
    }

    public ToStringBuilder singleLine() {
        this.multiLine = false;
        return this;
    }

    public ToStringBuilder skipNulls() {
        this.skipNulls = true;
        return this;
    }

    public ToStringBuilder hideFieldNames() {
        this.showFieldNames = false;
        return this;
    }

    public ToStringBuilder verbatimValues() {
        this.prettyPrint = false;
        return this;
    }

    public ToStringBuilder addDeclaredFields() {
        Field[] fields;
        for (Field field : fields = this.instance.getClass().getDeclaredFields()) {
            this.addField(field);
        }
        return this;
    }

    public ToStringBuilder addDeclaredFields(Predicate<Field> condition) {
        Field[] fields;
        for (Field field : fields = this.instance.getClass().getDeclaredFields()) {
            if (!condition.test(field)) continue;
            this.addField(field);
        }
        return this;
    }

    public ToStringBuilder addAllFields() {
        List<Field> fields = this.getAllDeclaredFields(this.instance.getClass());
        for (Field field : fields) {
            this.addField(field);
        }
        return this;
    }

    public ToStringBuilder addAllFields(Predicate<Field> condition) {
        List<Field> fields = this.getAllDeclaredFields(this.instance.getClass());
        for (Field field : fields) {
            if (!condition.test(field)) continue;
            this.addField(field);
        }
        return this;
    }

    public ToStringBuilder addField(String fieldName) {
        List<Field> fields = this.getAllDeclaredFields(this.instance.getClass());
        for (Field field : fields) {
            if (!fieldName.equals(field.getName())) continue;
            this.addField(field);
            break;
        }
        return this;
    }

    private ToStringBuilder addField(Field field) {
        if (!Modifier.isStatic(field.getModifiers())) {
            field.setAccessible(true);
            try {
                this.add(field.getName(), field.get(this.instance));
            }
            catch (IllegalAccessException e) {
                ToStringBuilder.sneakyThrow(e);
            }
        }
        return this;
    }

    private static <T extends Throwable> void sneakyThrow(Throwable t) throws T {
        throw t;
    }

    public ToStringBuilder add(String fieldName, Object value) {
        return this.addPart(fieldName, value);
    }

    public ToStringBuilder add(Object value) {
        return this.addPart(value);
    }

    private Part addPart() {
        Part p2 = new Part();
        this.parts.add(p2);
        return p2;
    }

    private ToStringBuilder addPart(Object value) {
        Part p2 = this.addPart();
        p2.value = value;
        return this;
    }

    private ToStringBuilder addPart(String fieldName, Object value) {
        Part p2 = this.addPart();
        p2.fieldName = fieldName;
        p2.value = value;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean startProcessing = toStringContext.startProcessing(this.instance);
        if (!startProcessing) {
            return this.toSimpleReferenceString(this.instance);
        }
        try {
            IndentationAwareStringBuilder builder = new IndentationAwareStringBuilder();
            builder.append(this.typeName).append(" ");
            builder.append("[");
            String nextSeparator = "";
            if (this.multiLine) {
                builder.increaseIndent();
            }
            for (Part part : this.parts) {
                if (this.skipNulls && part.value == null) continue;
                if (this.multiLine) {
                    builder.newLine();
                } else {
                    builder.append(nextSeparator);
                    nextSeparator = ", ";
                }
                if (part.fieldName != null && this.showFieldNames) {
                    builder.append(part.fieldName).append(" = ");
                }
                this.internalToString(part.value, builder);
            }
            if (this.multiLine) {
                builder.decreaseIndent().newLine();
            }
            builder.append("]");
            String string = builder.toString();
            return string;
        }
        finally {
            toStringContext.endProcessing(this.instance);
        }
    }

    private void internalToString(Object object, IndentationAwareStringBuilder sb) {
        if (this.prettyPrint) {
            if (object instanceof Iterable) {
                this.serializeIterable((Iterable)object, sb);
            } else if (object instanceof Object[]) {
                sb.append(Arrays.toString((Object[])object));
            } else if (object instanceof byte[]) {
                sb.append(Arrays.toString((byte[])object));
            } else if (object instanceof char[]) {
                sb.append(Arrays.toString((char[])object));
            } else if (object instanceof int[]) {
                sb.append(Arrays.toString((int[])object));
            } else if (object instanceof boolean[]) {
                sb.append(Arrays.toString((boolean[])object));
            } else if (object instanceof long[]) {
                sb.append(Arrays.toString((long[])object));
            } else if (object instanceof float[]) {
                sb.append(Arrays.toString((float[])object));
            } else if (object instanceof double[]) {
                sb.append(Arrays.toString((double[])object));
            } else if (object instanceof CharSequence) {
                sb.append("\"").append(((CharSequence)object).toString().replace("\n", "\\n").replace("\r", "\\r")).append("\"");
            } else if (object instanceof Enum) {
                sb.append(((Enum)object).name());
            } else {
                sb.append(String.valueOf(object));
            }
        } else {
            sb.append(String.valueOf(object));
        }
    }

    private void serializeIterable(Iterable<?> object, IndentationAwareStringBuilder sb) {
        Iterator<?> iterator2 = object.iterator();
        sb.append(object.getClass().getSimpleName()).append(" (");
        if (this.multiLine) {
            sb.increaseIndent();
        }
        boolean wasEmpty = true;
        while (iterator2.hasNext()) {
            wasEmpty = false;
            if (this.multiLine) {
                sb.newLine();
            }
            this.internalToString(iterator2.next(), sb);
            if (!iterator2.hasNext()) continue;
            sb.append(",");
        }
        if (this.multiLine) {
            sb.decreaseIndent();
        }
        if (!wasEmpty && this.multiLine) {
            sb.newLine();
        }
        sb.append(")");
    }

    private String toSimpleReferenceString(Object obj) {
        String simpleName = obj.getClass().getSimpleName();
        int identityHashCode = System.identityHashCode(obj);
        return simpleName + "@" + Integer.valueOf(identityHashCode);
    }

    private List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Class<?> current = clazz; current != null; current = current.getSuperclass()) {
            Field[] declaredFields = current.getDeclaredFields();
            result.addAll(Arrays.asList(declaredFields));
        }
        return result;
    }

    private static class IndentationAwareStringBuilder {
        private final StringBuilder builder = new StringBuilder();
        private final String indentationString = "  ";
        private final String newLineString = "\n";
        private int indentation = 0;

        private IndentationAwareStringBuilder() {
        }

        public IndentationAwareStringBuilder increaseIndent() {
            ++this.indentation;
            return this;
        }

        public IndentationAwareStringBuilder decreaseIndent() {
            --this.indentation;
            return this;
        }

        public IndentationAwareStringBuilder append(CharSequence string) {
            if (this.indentation > 0) {
                String indented = string.toString().replace("\n", "\n" + this.repeat("  ", this.indentation));
                this.builder.append(indented);
            } else {
                this.builder.append(string);
            }
            return this;
        }

        public IndentationAwareStringBuilder newLine() {
            this.builder.append("\n").append(this.repeat(this.indentationString, this.indentation));
            return this;
        }

        public String toString() {
            return this.builder.toString();
        }

        private String repeat(String string, int count) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                result.append(string);
            }
            return result.toString();
        }
    }

    private static final class Part {
        private String fieldName;
        private Object value;

        private Part() {
        }
    }

    public static class ToStringContext {
        public static final ToStringContext INSTANCE = new ToStringContext();
        private static final ThreadLocal<IdentityHashMap<Object, Boolean>> currentlyProcessed = new ThreadLocal<IdentityHashMap<Object, Boolean>>(){

            @Override
            public IdentityHashMap<Object, Boolean> initialValue() {
                return new IdentityHashMap<Object, Boolean>();
            }
        };

        public boolean startProcessing(Object obj) {
            return currentlyProcessed.get().put(obj, Boolean.TRUE) == null;
        }

        public void endProcessing(Object obj) {
            currentlyProcessed.get().remove(obj);
        }
    }
}

