/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public final class PublicSuffix {
    private final SubdomainNode root = new SubdomainNode(false, false);
    private static final String WILDCARD = "*";
    private static final String EXCEPTION = "!";
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final char DOT = '.';
    private static final String DATA_FILENAME = "public-suffix.dat";
    private static PublicSuffix defaultInstance;

    public static PublicSuffix get() {
        if (defaultInstance == null) {
            try {
                defaultInstance = new PublicSuffix();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }
        return defaultInstance;
    }

    private PublicSuffix() throws UnsupportedEncodingException, IOException {
        this.load();
    }

    public int getEffectiveTLDLength(String hostname) {
        int nextDotLoc;
        String normalizedHostname = this.normalizeHostname(hostname);
        int lastDot = normalizedHostname.length();
        SubdomainNode node = this.root;
        while (lastDot > 0 && (node = this.findNode(node, normalizedHostname.substring((nextDotLoc = normalizedHostname.lastIndexOf(46, lastDot - 1)) + 1, lastDot), false)) != null) {
            lastDot = nextDotLoc;
            if (!node.isException() && !node.isStopOK()) continue;
            break;
        }
        return lastDot;
    }

    private String normalizeHostname(String hostname) {
        boolean isLowercase = true;
        boolean isAscii = true;
        for (int i = 0; i < hostname.length(); ++i) {
            char c = hostname.charAt(i);
            if (c >= '\u0080') {
                isAscii = false;
                break;
            }
            if (Character.isLowerCase(c)) continue;
            isLowercase = false;
        }
        if (!isAscii) {
            throw new UnsupportedOperationException("No support yet for IDN: TODO");
        }
        return isLowercase ? hostname : hostname.toLowerCase();
    }

    private void load() throws UnsupportedEncodingException, IOException {
        URL u = this.getClass().getResource("/public-suffix.dat");
        if (u == null) {
            throw new FileNotFoundException("public-suffix.dat not on CLASSPATH");
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(u.openStream(), "UTF-8"));
        String line = null;
        while ((line = br.readLine()) != null) {
            if (line.length() <= 0 || line.startsWith("//")) continue;
            this.addEffectiveTLDEntry(this.root, line);
        }
    }

    private SubdomainNode findNode(SubdomainNode node, String subdomain, boolean create) {
        boolean exception = subdomain != null && subdomain.startsWith(EXCEPTION);
        String key = exception ? subdomain.substring(1) : subdomain;
        SubdomainNode newNode = node.getChildren().get(key);
        if (newNode != null) {
            return newNode;
        }
        if (create) {
            SubdomainNode subNode = new SubdomainNode(exception, false);
            node.getChildren().put(key, subNode);
            return subNode;
        }
        return node.getChildren().get(WILDCARD);
    }

    private void addEffectiveTLDEntry(SubdomainNode node, String line) {
        String hostname = WHITESPACE.split(line, 2)[0];
        int dotLoc = hostname.length();
        while (dotLoc >= 0) {
            int nextDocLoc = hostname.lastIndexOf(46, dotLoc - 1);
            String subdomain = hostname.substring(nextDocLoc + 1, dotLoc);
            dotLoc = nextDocLoc;
            node = this.findNode(node, subdomain, true);
        }
        node.setStopOK();
    }

    private void dump() {
        this.dump(this.root.getChildren(), 0);
    }

    private void dump(Map<String, SubdomainNode> node, int offset) {
        if (node == null || node.isEmpty()) {
            return;
        }
        for (Map.Entry<String, SubdomainNode> e : node.entrySet()) {
            for (int i = 0; i < offset; ++i) {
                System.out.print(" ");
            }
            System.out.println(e.getKey() + ": " + String.valueOf(e.getValue()));
            this.dump(e.getValue().getChildren(), offset + 1);
        }
    }

    private static class SubdomainNode {
        final boolean exception;
        boolean stopOK;
        final Map<String, SubdomainNode> children;

        public SubdomainNode(boolean ex, boolean stop) {
            this(ex, stop, new HashMap<String, SubdomainNode>());
        }

        public SubdomainNode(boolean ex, boolean stop, Map<String, SubdomainNode> c) {
            this.exception = ex;
            this.children = c;
            this.stopOK = stop;
        }

        public boolean isException() {
            return this.exception;
        }

        public boolean isStopOK() {
            return this.stopOK;
        }

        public void setStopOK() {
            this.stopOK = true;
        }

        public Map<String, SubdomainNode> getChildren() {
            return this.children;
        }

        public String toString() {
            return "exception: " + this.exception + ", stopOK: " + this.stopOK + ", children: " + (this.children == null ? 0 : this.children.size());
        }
    }
}

