/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.PureUtilities.Web;

import com.laytonsmith.PureUtilities.LinkedComparatorSet;
import com.laytonsmith.PureUtilities.Web.Cookie;
import com.laytonsmith.PureUtilities.Web.WebUtility;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class CookieJar {
    private final Set<Cookie> cookies = new LinkedComparatorSet<Cookie>(new LinkedComparatorSet.EqualsComparator<Cookie>(){

        @Override
        public boolean checkIfEquals(Cookie val1, Cookie val2) {
            return val1.compareTo(val2) == 0;
        }
    });

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Cookie cookie : this.cookies) {
            if (cookie.isExpired()) continue;
            b.append(cookie.getName()).append("=").append(cookie.getValue()).append("; used in ").append(cookie.getDomain()).append(cookie.getPath()).append("\n");
        }
        return b.toString();
    }

    public void addCookie(Cookie cookie) {
        if (this.cookies.contains(cookie)) {
            this.cookies.remove(cookie);
        }
        this.cookies.add(cookie);
    }

    public String getCookies(URL url) {
        ArrayList<Cookie> usable = new ArrayList<Cookie>();
        ArrayList<Cookie> foundCookies = new ArrayList<Cookie>(this.cookies);
        for (int i = 0; i < foundCookies.size(); ++i) {
            String path;
            Cookie cookie = (Cookie)foundCookies.get(i);
            if (cookie.isExpired()) {
                this.cookies.remove(cookie);
                foundCookies.remove(i);
                --i;
                continue;
            }
            if (cookie.isSecureOnly() && !url.getProtocol().equals("https")) continue;
            String domain = cookie.getDomain();
            if (domain.startsWith(".")) {
                domain = domain.substring(1);
            }
            if (!url.getHost().endsWith(domain) || !(path = (url.getPath().startsWith("/") ? "" : "/") + url.getPath()).startsWith(cookie.getPath())) continue;
            usable.add(cookie);
        }
        if (usable.isEmpty()) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (Cookie cookie : usable) {
            if (b.length() != 0) {
                b.append("; ");
            }
            try {
                b.append(URLEncoder.encode(cookie.getName(), "UTF-8")).append("=").append(cookie.getValue());
            }
            catch (UnsupportedEncodingException ex) {
                Logger.getLogger(WebUtility.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return b.toString();
    }

    public void clearSessionCookies() {
        Iterator<Cookie> it = this.cookies.iterator();
        while (it.hasNext()) {
            Cookie c = it.next();
            if (c.getExpiration() != 0L) continue;
            it.remove();
        }
    }

    public void clearAllCookies() {
        this.cookies.clear();
    }

    public Set<Cookie> getAllCookies() {
        return new TreeSet<Cookie>(this.cookies);
    }
}

