/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCItemMeta;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCBlockStateMeta;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemMeta;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCMaterial;
import com.laytonsmith.abstraction.enums.MCEnchantment;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEnchantment;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;

public class BukkitMCItemStack
implements MCItemStack {
    ItemStack is;

    public BukkitMCItemStack(ItemStack is) {
        this.is = is;
    }

    public BukkitMCItemStack(AbstractionObject a) {
        this((ItemStack)null);
        if (!(a instanceof MCItemStack)) {
            throw new ClassCastException();
        }
        this.is = (ItemStack)a.getHandle();
    }

    @Override
    public Object getHandle() {
        return this.is;
    }

    @Override
    public void addEnchantment(MCEnchantment e, int level) {
        if (this.is == null) {
            return;
        }
        this.is.addEnchantment((Enchantment)e.getConcrete(), level);
    }

    @Override
    public void addUnsafeEnchantment(MCEnchantment e, int level) {
        if (this.is == null) {
            return;
        }
        this.is.addUnsafeEnchantment((Enchantment)e.getConcrete(), level);
    }

    @Override
    public Map<MCEnchantment, Integer> getEnchantments() {
        HashMap<MCEnchantment, Integer> map = new HashMap<MCEnchantment, Integer>();
        try {
            for (Map.Entry entry : this.is.getEnchantments().entrySet()) {
                map.put(BukkitMCEnchantment.valueOfConcrete((Enchantment)entry.getKey()), (Integer)entry.getValue());
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return map;
    }

    @Override
    public void removeEnchantment(MCEnchantment e) {
        if (this.is == null) {
            return;
        }
        this.is.removeEnchantment((Enchantment)e.getConcrete());
    }

    @Override
    public MCMaterial getType() {
        if (this.is == null) {
            return BukkitMCMaterial.valueOfConcrete(Material.AIR);
        }
        return BukkitMCMaterial.valueOfConcrete(this.is.getType());
    }

    @Override
    public int getAmount() {
        if (this.is == null) {
            return 0;
        }
        return this.is.getAmount();
    }

    @Override
    public void setAmount(int amt) {
        if (this.is == null) {
            return;
        }
        this.is.setAmount(amt);
    }

    public ItemStack __ItemStack() {
        return this.is;
    }

    @Override
    public int maxStackSize() {
        if (this.is == null) {
            return 0;
        }
        return this.is.getMaxStackSize();
    }

    public ItemStack asItemStack() {
        return this.is;
    }

    public String toString() {
        return this.is.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof BukkitMCItemStack && this.is.equals((Object)((BukkitMCItemStack)obj).asItemStack());
    }

    public int hashCode() {
        return this.is.hashCode();
    }

    @Override
    public boolean hasItemMeta() {
        return this.is != null && this.is.hasItemMeta();
    }

    @Override
    public MCItemMeta getItemMeta() {
        ItemMeta im = this.is.getItemMeta();
        if (im instanceof BlockStateMeta) {
            return new BukkitMCBlockStateMeta((BlockStateMeta)im, this.is.getType());
        }
        return BukkitConvertor.BukkitGetCorrectMeta(im);
    }

    @Override
    public void setItemMeta(MCItemMeta im) {
        if (this.is == null) {
            return;
        }
        if (im == null) {
            this.is.setItemMeta(null);
            return;
        }
        this.is.setItemMeta(((BukkitMCItemMeta)im).asItemMeta());
    }

    @Override
    public boolean isEmpty() {
        return this.is == null || this.is.getAmount() == 0 || this.is.getType().isAir();
    }
}

