/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.DateUtils;
import com.laytonsmith.PureUtilities.Common.StackTraceUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.ExecutionQueueImpl;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.PureUtilities.XMLDocument;
import com.laytonsmith.PureUtilities.ZipReader;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.MCConsoleCommandSender;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLivingEntity;
import com.laytonsmith.abstraction.MCOfflinePlayer;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCPlugin;
import com.laytonsmith.abstraction.MCRemoteCommandSender;
import com.laytonsmith.abstraction.MCServer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.commandhelper.CommandHelperPlugin;
import com.laytonsmith.core.AliasCore;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.Installer;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Main;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.NotInitializedYetException;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Profiles;
import com.laytonsmith.core.ProfilesImpl;
import com.laytonsmith.core.compiler.CompilerEnvironment;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CBareString;
import com.laytonsmith.core.constructs.CBoolean;
import com.laytonsmith.core.constructs.CByteArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CDecimal;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CNumber;
import com.laytonsmith.core.constructs.CPrimitive;
import com.laytonsmith.core.constructs.CResource;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.NativeTypeList;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.Variable;
import com.laytonsmith.core.environments.CommandHelperEnvironment;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.RuntimeMode;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CRE.CREBadEntityException;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidPluginException;
import com.laytonsmith.core.exceptions.CRE.CREInvalidWorldException;
import com.laytonsmith.core.exceptions.CRE.CRELengthException;
import com.laytonsmith.core.exceptions.CRE.CRENullPointerException;
import com.laytonsmith.core.exceptions.CRE.CREPlayerOfflineException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.IncludeCache;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.profiler.Profiler;
import com.laytonsmith.core.taskmanager.TaskManagerImpl;
import com.laytonsmith.persistence.DataSourceException;
import com.laytonsmith.persistence.PersistenceNetworkImpl;
import com.laytonsmith.persistence.io.ConnectionMixinFactory;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.Yaml;

public final class Static {
    private static Logger logger;
    private static final Map<String, String> HOST_CACHE;
    private static final String CONSOLE_NAME = "~console";
    private static final String BLOCK_PREFIX = "#";
    public static final String GROUP_PREFIX = "group.";
    public static final String GLOBAL_PERMISSION = "*";
    private static String debugLogFileCurrent;
    private static FileWriter debugLogFileHandle;
    private static String standardLogFileCurrent;
    private static FileWriter standardLogFileHandle;
    private static String profilingLogFileCurrent;
    private static FileWriter profilingLogFileHandle;
    private static final Pattern INVALID_HEX;
    private static final Pattern VALID_HEX;
    private static final Pattern INVALID_BINARY;
    private static final Pattern VALID_BINARY;
    private static final Pattern INVALID_OCTAL;
    private static final Pattern VALID_OCTAL;
    private static final Pattern VALID_DECIMAL;
    private static final Pattern INVALID_DECIMAL;
    private static final Map<String, MCCommandSender> INJECTED_PLAYERS;
    private static MCEntity injectedEntity;
    private static final Pattern DASHLESS_PATTERN;

    private Static() {
    }

    @Deprecated
    public static CArray getArray(Mixed construct, Target t) {
        return ArgumentValidation.getArray(construct, t);
    }

    @Deprecated
    public static <T extends Mixed> T getObject(Mixed construct, Target t, Class<T> clazz) {
        return ArgumentValidation.getObject(construct, t, clazz);
    }

    public static CNumber getNumber(Number number, Target t) {
        double doubleValue;
        long longValue = number.longValue();
        return (double)longValue == (doubleValue = number.doubleValue()) ? new CInt(longValue, t) : new CDouble(doubleValue, t);
    }

    @Deprecated
    public static double getNumber(Mixed c, Target t) {
        return ArgumentValidation.getNumber(c, t);
    }

    @Deprecated
    public static double getDouble(Mixed c, Target t) {
        return ArgumentValidation.getDouble(c, t);
    }

    @Deprecated
    public static float getDouble32(Mixed c, Target t) {
        return ArgumentValidation.getDouble32(c, t);
    }

    @Deprecated
    public static long getInt(Mixed c, Target t) {
        return ArgumentValidation.getInt(c, t);
    }

    @Deprecated
    public static int getInt32(Mixed c, Target t) {
        return ArgumentValidation.getInt32(c, t);
    }

    @Deprecated
    public static short getInt16(Mixed c, Target t) {
        return ArgumentValidation.getInt16(c, t);
    }

    @Deprecated
    public static byte getInt8(Mixed c, Target t) {
        return ArgumentValidation.getInt8(c, t);
    }

    @Deprecated
    public static boolean getBoolean(Mixed c, Target t) {
        return ArgumentValidation.getBooleanish(c, t);
    }

    @Deprecated
    public static CPrimitive getPrimitive(Mixed c, Target t) {
        return ArgumentValidation.getObject(c, t, CPrimitive.class);
    }

    @Deprecated
    public static CByteArray getByteArray(Mixed c, Target t) {
        return ArgumentValidation.getByteArray(c, t);
    }

    @Deprecated
    public static boolean anyDoubles(Mixed ... c) {
        return ArgumentValidation.anyDoubles(c);
    }

    @Deprecated
    public static boolean anyStrings(Mixed ... c) {
        return ArgumentValidation.anyStrings(c);
    }

    @Deprecated
    public static boolean anyBooleans(Mixed ... c) {
        return ArgumentValidation.anyBooleans(c);
    }

    @Deprecated
    public static boolean anyNulls(Mixed ... c) {
        return ArgumentValidation.anyNulls(c);
    }

    public static Logger getLogger() {
        if (logger == null) {
            logger = Implementation.GetServerType() == Implementation.Type.BUKKIT ? CommandHelperPlugin.self.getLogger() : Logger.getLogger("MethodScript");
        }
        return logger;
    }

    public static MCServer getServer() throws NotInitializedYetException {
        MCServer s = CommandHelperPlugin.myServer;
        if (s == null) {
            throw new NotInitializedYetException("The server has not been initialized yet");
        }
        return s;
    }

    public static AliasCore getAliasCore() throws NotInitializedYetException {
        AliasCore ac = CommandHelperPlugin.getCore();
        if (ac == null) {
            throw new NotInitializedYetException("The core has not been initialized yet");
        }
        return ac;
    }

    public static SimpleVersion getVersion() throws NotInitializedYetException {
        SimpleVersion v = null;
        if (Implementation.GetServerType() == Implementation.Type.BUKKIT) {
            v = CommandHelperPlugin.version;
        } else {
            try {
                v = Static.loadSelfVersion();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (v == null) {
            throw new NotInitializedYetException("The plugin has not been initialized yet");
        }
        return v;
    }

    public static SimpleVersion loadSelfVersion() throws Exception {
        File file = new File(new File(Main.class.getProtectionDomain().getCodeSource().getLocation().toURI()), "plugin.yml");
        ZipReader reader = new ZipReader(file);
        if (!reader.exists()) {
            throw new FileNotFoundException(String.format("%s does not exist", file.getPath()));
        }
        try {
            String contents = reader.getFileContents();
            Yaml yaml = new Yaml();
            Map map = (Map)yaml.load(contents);
            return new SimpleVersion((String)map.get("version"));
        }
        catch (IOException | RuntimeException ex) {
            throw new Exception(ex);
        }
    }

    public static String getNoClassDefFoundErrorMessage(NoClassDefFoundError error) {
        Object ret = "The main class requires craftbukkit or bukkit to be included in order to run. If you are seeing this message, you have two options. First, it seems you have renamed your craftbukkit jar, or you are altogether not using craftbukkit. If this is the case, you can download craftbukkit and place it in the correct directory (one above this one) or you can download bukkit, rename it to bukkit.jar, and put it in the CommandHelper directory.";
        ret = (String)ret + " If you're dying for more details, here:\n";
        ret = (String)ret + StackTraceUtils.GetStacktrace(error);
        return ret;
    }

    public static FileWriter debugLogFile(File root) throws IOException {
        String currentFileName = root.getPath() + "/" + DateUtils.ParseCalendarNotation(Prefs.DebugLogFile());
        if (!currentFileName.equals(debugLogFileCurrent)) {
            if (debugLogFileHandle != null) {
                debugLogFileHandle.close();
            }
            debugLogFileCurrent = currentFileName;
            new File(debugLogFileCurrent).getParentFile().mkdirs();
            if (!new File(debugLogFileCurrent).exists()) {
                new File(debugLogFileCurrent).createNewFile();
            }
            debugLogFileHandle = new FileWriter(currentFileName, true);
        }
        return debugLogFileHandle;
    }

    public static FileWriter standardLogFile(File root) throws IOException {
        String currentFileName = root.getPath() + DateUtils.ParseCalendarNotation(Prefs.StandardLogFile());
        if (!currentFileName.equals(standardLogFileCurrent)) {
            if (standardLogFileHandle != null) {
                standardLogFileHandle.close();
            }
            standardLogFileCurrent = currentFileName;
            new File(standardLogFileCurrent).getParentFile().mkdirs();
            standardLogFileHandle = new FileWriter(currentFileName);
        }
        return standardLogFileHandle;
    }

    public static FileWriter profilingLogFile(File root) throws IOException {
        String currentFileName = root.getPath() + DateUtils.ParseCalendarNotation(Prefs.ProfilingFile());
        if (!currentFileName.equals(profilingLogFileCurrent)) {
            if (profilingLogFileHandle != null) {
                profilingLogFileHandle.close();
            }
            profilingLogFileCurrent = currentFileName;
            new File(profilingLogFileCurrent).getParentFile().mkdirs();
            profilingLogFileHandle = new FileWriter(currentFileName);
        }
        return profilingLogFileHandle;
    }

    public static void checkPlugin(String name, Target t) throws ConfigRuntimeException {
        if (Static.getServer().getPluginManager().getPlugin(name) == null) {
            throw new CREInvalidPluginException("Needed plugin " + name + " not found!", t);
        }
    }

    public static Construct resolveConstruct(String val, Target t) throws ConfigRuntimeException {
        return Static.resolveConstruct(val, t, false);
    }

    public static Construct resolveConstruct(String val, Target t, boolean returnBareStrings) throws ConfigRuntimeException {
        if (val == null) {
            return new CString("", t);
        }
        if (val.equals("true")) {
            return CBoolean.TRUE;
        }
        if (val.equals("false")) {
            return CBoolean.FALSE;
        }
        if (val.equals("null")) {
            return CNull.NULL;
        }
        if (val.equals("void")) {
            return CVoid.VOID;
        }
        if (INVALID_HEX.matcher(val).matches()) {
            throw new CREFormatException("Hex numbers must only contain digits 0-9, and the letters A-F, but \"" + val + "\" was found.", t);
        }
        if (VALID_HEX.matcher(val).matches()) {
            if (val.length() > 18) {
                throw new CREFormatException("Hex numbers must contain at most 16 digits, but \"" + val + "\" was found.", t);
            }
            long longVal = val.length() == 18 ? Long.parseLong(val.substring(2, 10), 16) << 32 | Long.parseLong(val.substring(10, 18), 16) : Long.parseLong(val.substring(2), 16);
            return new CInt(longVal, t);
        }
        if (INVALID_BINARY.matcher(val).matches()) {
            throw new CREFormatException("Binary numbers must only contain digits 0 and 1, but \"" + val + "\" was found.", t);
        }
        if (VALID_BINARY.matcher(val).matches()) {
            if (val.length() > 66) {
                throw new CREFormatException("Binary numbers must contain at most 64 digits, but \"" + val + "\" was found.", t);
            }
            long longVal = val.length() == 66 ? Long.parseLong(val.substring(2, 34), 2) << 32 | Long.parseLong(val.substring(34, 66), 2) : Long.parseLong(val.substring(2), 2);
            return new CInt(longVal, t);
        }
        if (INVALID_OCTAL.matcher(val).matches()) {
            throw new CREFormatException("Octal numbers must only contain digits 0-7, but \"" + val + "\" was found.", t);
        }
        if (VALID_OCTAL.matcher(val).matches()) {
            long longVal;
            if (val.length() > 24) {
                throw new CREFormatException("Octal numbers must contain at most 22 digits, but \"" + val + "\" was found.", t);
            }
            if (val.length() == 24) {
                if (val.charAt(2) != '1') {
                    throw new CREFormatException("Octal number exceeds maximum 64-bit value 0o1777777777777777777777. Found \"" + val + "\".", t);
                }
                longVal = Long.parseLong(val.substring(3), 8) | Long.MIN_VALUE;
            } else {
                longVal = Long.parseLong(val.substring(2), 8);
            }
            return new CInt(longVal, t);
        }
        if (INVALID_DECIMAL.matcher(val).matches()) {
            throw new CREFormatException("Decimal numbers must only contain digits, but \"" + val + "\" was found.", t);
        }
        if (VALID_DECIMAL.matcher(val).matches()) {
            return new CDecimal(val.substring(2), t);
        }
        try {
            return new CInt(Long.parseLong(val), t);
        }
        catch (NumberFormatException e) {
            try {
                if (!val.contains(" ") && !val.contains("\t")) {
                    return new CDouble(Double.parseDouble(val), t);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            String fqType = NativeTypeList.resolveNativeType(val);
            if (fqType != null) {
                try {
                    return CClassType.get(FullyQualifiedClassName.forFullyQualifiedClass(fqType));
                }
                catch (ClassNotFoundException ex) {
                    throw new Error(ex);
                }
            }
            if (returnBareStrings) {
                return new CBareString(val, t);
            }
            return new CString(val, t);
        }
    }

    public static Construct resolveDollarVar(Construct variable, List<Variable> vars) {
        if (variable == null) {
            return CNull.NULL;
        }
        if (variable.getCType() == Construct.ConstructType.VARIABLE) {
            for (Variable var : vars) {
                if (!var.getVariableName().equals(((Variable)variable).getVariableName())) continue;
                return new CString(var.val(), var.getTarget());
            }
            return new CString(((Variable)variable).getDefault(), variable.getTarget());
        }
        return variable;
    }

    public static void SendMessage(MCCommandSender m, String msg2, Target t) {
        if (m != null && !(m instanceof MCConsoleCommandSender)) {
            MCPlayer p2;
            if (m instanceof MCPlayer && !(p2 = (MCPlayer)m).isOnline()) {
                throw new CREPlayerOfflineException("The player " + p2.getName() + " is not online", t);
            }
            m.sendMessage((String)msg2);
        } else if (m instanceof MCRemoteCommandSender) {
            MCRemoteCommandSender rcon = (MCRemoteCommandSender)m;
            if (!Prefs.UseColors().booleanValue()) {
                msg2 = MCChatColor.stripColor((String)msg2);
            }
            rcon.sendMessage((String)msg2);
        } else {
            if (((String)(msg2 = Static.MCToANSIColors((String)msg2))).contains("\u001b")) {
                msg2 = (String)msg2 + TermColors.reset();
            }
            StreamUtils.GetSystemOut().println((String)msg2);
        }
    }

    public static void SendMessage(MCCommandSender m, String msg2) {
        try {
            Static.SendMessage(m, msg2, Target.UNKNOWN);
        }
        catch (ConfigRuntimeException configRuntimeException) {
            // empty catch block
        }
    }

    public static String getConsoleName() {
        return CONSOLE_NAME;
    }

    public static String getBlockPrefix() {
        return BLOCK_PREFIX;
    }

    @Deprecated
    public static MCItemStack ParseItemNotation(String functionName, String notation, int qty, Target t) {
        int type;
        int data = 0;
        try {
            int separatorIndex = notation.indexOf(58);
            if (separatorIndex != -1) {
                type = Integer.parseInt(notation.substring(0, separatorIndex));
                data = (short)Integer.parseInt(notation.substring(separatorIndex + 1));
            } else {
                type = Integer.parseInt(notation);
            }
        }
        catch (NumberFormatException e) {
            throw new CREFormatException("Invalid item format: " + notation, t);
        }
        MCMaterial mat = StaticLayer.GetMaterialFromLegacy(type, data);
        if (mat == null) {
            throw new CREFormatException("Invalid item format: " + notation, t);
        }
        if (!mat.isItem()) {
            mat = MCMaterial.get("AIR");
        }
        MCItemStack is = StaticLayer.GetItemStack(mat, qty);
        MSLog.GetLogger().w(MSLog.Tags.DEPRECATION, "Item notation is deprecated. Converting '" + notation + "' to '" + is.getType().getName() + "'.", t);
        return is;
    }

    public static UUID GetUUID(String subject, Target t) {
        try {
            if (subject.length() == 36) {
                return UUID.fromString(subject);
            }
            if (subject.length() == 32) {
                Matcher matcher = DASHLESS_PATTERN.matcher(subject);
                if (!matcher.matches()) {
                    throw new IllegalArgumentException("Invalid UUID format.");
                }
                return UUID.fromString(matcher.replaceAll("$1-$2-$3-$4-$5"));
            }
            throw new CRELengthException("A UUID is expected to be 32 or 36 characters, but the given string was " + subject.length() + " characters.", t);
        }
        catch (IllegalArgumentException iae) {
            throw new CREFormatException("A UUID length string was given, but was not a valid UUID.", t);
        }
    }

    public static UUID GetUUID(Mixed subject, Target t) {
        return Static.GetUUID(subject.val(), t);
    }

    public static MCOfflinePlayer GetUser(Mixed search, Target t) {
        return Static.GetUser(search.val(), t);
    }

    public static MCOfflinePlayer GetUser(String search, Target t) {
        MCOfflinePlayer ofp;
        if (search.length() > 0 && search.length() <= 16) {
            ofp = CONSOLE_NAME.equals(search) ? null : Static.getServer().getOfflinePlayer(search);
        } else {
            try {
                ofp = Static.getServer().getOfflinePlayer(Static.GetUUID(search, t));
            }
            catch (ConfigRuntimeException cre) {
                if (cre instanceof CREThrowable && ((CREThrowable)cre).isInstanceOf(CRELengthException.TYPE)) {
                    throw new CRELengthException("The given string was the wrong size to identify a player. A player name is expected to be between 1 and 16 characters. " + cre.getMessage(), t);
                }
                throw cre;
            }
        }
        return ofp;
    }

    public static MCPlayer GetPlayer(String player2, Target t) throws ConfigRuntimeException {
        MCPlayer p2;
        if (player2 == null) {
            throw new CREPlayerOfflineException("No player was specified!", t);
        }
        if (player2.length() > 0 && player2.length() <= 16) {
            MCCommandSender sender = Static.GetCommandSender(player2, t);
            if (!(sender instanceof MCPlayer)) {
                throw new CREPlayerOfflineException("Expecting a player name, but \"" + player2 + "\" was found.", t);
            }
            p2 = (MCPlayer)sender;
            if (!p2.isOnline()) {
                throw new CREPlayerOfflineException("The specified player (" + player2 + ") is not online", t);
            }
        } else {
            try {
                p2 = Static.getServer().getPlayer(Static.GetUUID(player2, t));
                if (p2 == null) {
                    throw new CREPlayerOfflineException("The specified player (" + player2 + ") is not online", t);
                }
            }
            catch (CREThrowable ex) {
                if (ex.isInstanceOf(CRELengthException.TYPE)) {
                    throw new CRELengthException("The given string was the wrong size to identify a player. A player name is expected to be between 1 and 16 characters. " + ex.getMessage(), t);
                }
                throw ex;
            }
        }
        return p2;
    }

    public static MCPlayer GetPlayer(Mixed player2, Target t) throws ConfigRuntimeException {
        return Static.GetPlayer(player2.val(), t);
    }

    public static MCCommandSender GetCommandSender(String name, Target t) throws ConfigRuntimeException {
        MCCommandSender injectedPlayer = INJECTED_PLAYERS.get(name.toLowerCase());
        if (injectedPlayer != null) {
            return injectedPlayer;
        }
        if (CONSOLE_NAME.equals(name)) {
            return Static.getServer().getConsole();
        }
        MCPlayer p2 = Static.getServer().getPlayer(name);
        if (p2 == null) {
            throw new CREPlayerOfflineException("The specified player (" + name + ") is not online", t);
        }
        return p2;
    }

    public static MCPlayer getPlayer(Environment environment, Target t) {
        MCPlayer player2 = environment.getEnv(CommandHelperEnvironment.class).GetPlayer();
        if (player2 != null) {
            return player2;
        }
        throw new CREPlayerOfflineException("The passed arguments induce that the function must be run by a player.", t);
    }

    public static boolean isNull(Mixed construct) {
        return construct instanceof CNull;
    }

    public static int Normalize(int i, int min2, int max2) {
        return Math.min(max2, Math.max(min2, i));
    }

    public static MCEntity getEntity(Mixed id, Target t) {
        return Static.getEntityByUuid(Static.GetUUID(id.val(), t), t);
    }

    public static MCLivingEntity getLivingEntity(Mixed id, Target t) {
        return Static.getLivingByUUID(Static.GetUUID(id.val(), t), t);
    }

    public static MCEntity getEntityByUuid(UUID id, Target t) {
        if (injectedEntity != null && injectedEntity.getUniqueId().compareTo(id) == 0) {
            return injectedEntity;
        }
        MCEntity ent = Static.getServer().getEntity(id);
        if (ent == null && (ent = Static.getServer().getPlayer(id)) == null) {
            throw new CREBadEntityException("That entity (UUID: " + String.valueOf(id) + ") does not exist.", t);
        }
        return ent;
    }

    public static MCLivingEntity getLivingByUUID(UUID id, Target t) {
        if (injectedEntity != null && injectedEntity.getUniqueId().compareTo(id) == 0) {
            if (injectedEntity instanceof MCLivingEntity) {
                return (MCLivingEntity)injectedEntity;
            }
            throw new CREBadEntityException("That entity (UUID: " + String.valueOf(id) + ") is not alive.", t);
        }
        MCEntity ent = Static.getServer().getEntity(id);
        if (ent == null) {
            throw new CREBadEntityException("That entity (UUID: " + String.valueOf(id) + ") does not exist.", t);
        }
        if (!(ent instanceof MCLivingEntity)) {
            throw new CREBadEntityException("That entity (UUID: " + String.valueOf(id) + ") is not alive.", t);
        }
        return (MCLivingEntity)ent;
    }

    public static MCWorld getWorld(String name, Target t) {
        MCWorld world = Static.getServer().getWorld(name);
        if (world != null) {
            return world;
        }
        throw new CREInvalidWorldException("Unknown world:" + name + ".", t);
    }

    public static MCWorld getWorld(Mixed name, Target t) {
        return Static.getWorld(name.val(), t);
    }

    public static MCPlugin getPlugin(String name, Target t) {
        MCPlugin plugin = Static.getServer().getPluginManager().getPlugin(name);
        if (plugin != null) {
            return plugin;
        }
        throw new CREInvalidPluginException("Unknown plugin:" + name + ".", t);
    }

    public static MCPlugin getPlugin(Mixed name, Target t) {
        return Static.getPlugin(name.val(), t);
    }

    public static String strJoin(Collection c, String inner) {
        StringBuilder b = new StringBuilder();
        Object[] o = c.toArray();
        for (int i = 0; i < o.length; ++i) {
            if (i != 0) {
                b.append(inner);
            }
            b.append(o[i]);
        }
        return b.toString();
    }

    public static String strJoin(Object[] o, String inner) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < o.length; ++i) {
            if (i != 0) {
                b.append(inner);
            }
            b.append(o[i]);
        }
        return b.toString();
    }

    public static String LF() {
        return System.getProperty("line.separator");
    }

    public static void LogDebug(File root, String message) throws IOException {
        Static.LogDebug(root, message, LogLevel.OFF);
    }

    public static synchronized void LogDebug(File root, String message, LogLevel level) throws IOException {
        Static.LogDebug(root, message, level, true);
    }

    public static synchronized void LogDebug(File root, String message, LogLevel level, boolean printScreen) throws IOException {
        if (Prefs.DebugMode().booleanValue() || Prefs.ShowWarnings().booleanValue() || level == LogLevel.ERROR || level == LogLevel.ALWAYS) {
            String color2 = "";
            Level lev = Level.INFO;
            boolean show = false;
            switch (level) {
                case ALWAYS: {
                    color2 = TermColors.WHITE;
                    lev = Level.INFO;
                    show = true;
                    break;
                }
                case ERROR: {
                    color2 = TermColors.RED;
                    lev = Level.SEVERE;
                    show = true;
                    break;
                }
                case WARNING: {
                    color2 = TermColors.YELLOW;
                    lev = Level.WARNING;
                    if (!Prefs.DebugMode().booleanValue() && !Prefs.ShowWarnings().booleanValue()) break;
                    show = true;
                    break;
                }
                case INFO: {
                    color2 = TermColors.GREEN;
                    lev = Level.INFO;
                    if (!Prefs.DebugMode().booleanValue()) break;
                    show = true;
                    break;
                }
                case DEBUG: {
                    color2 = TermColors.BRIGHT_BLUE;
                    lev = Level.INFO;
                    if (!Prefs.DebugMode().booleanValue()) break;
                    show = true;
                    break;
                }
                case VERBOSE: {
                    color2 = TermColors.WHITE;
                    lev = Level.INFO;
                    if (!Prefs.DebugMode().booleanValue()) break;
                    show = true;
                }
            }
            if (show && printScreen) {
                Static.getLogger().log(lev, "{0}{1}{2}", new Object[]{color2, message, TermColors.reset()});
            }
        }
        String timestamp = DateUtils.ParseCalendarNotation("%Y-%M-%D %h:%m.%s - ");
        Static.QuickAppend(Static.debugLogFile(root), timestamp + "[" + Implementation.GetServerType().getBranding() + "]" + message + Static.LF());
    }

    public static void QuickAppend(FileWriter f, String message) throws IOException {
        f.append(message);
        f.flush();
    }

    public static boolean hasCHPermission(String functionName, Environment env) {
        if (GLOBAL_PERMISSION.equals(env.getEnv(GlobalEnv.class).GetLabel())) {
            return true;
        }
        MCPlayer player2 = env.getEnv(CommandHelperEnvironment.class).GetPlayer();
        return player2 == null || player2.isOp() || player2.hasPermission("ch.func.use." + functionName) || player2.hasPermission("commandhelper.func.use." + functionName);
    }

    public static String Logo() {
        String logo = Installer.parseISToString(Static.class.getResourceAsStream("/mainlogo"));
        logo = logo.replaceAll("( +)", TermColors.BG_BLACK + "$1");
        logo = logo.replace("_", TermColors.BG_RED + TermColors.RED + "_");
        logo = logo.replace("/", TermColors.BG_BRIGHT_WHITE + TermColors.WHITE + "/");
        logo = logo.replace("\n", TermColors.reset() + "\n");
        String s = logo + TermColors.reset();
        return s;
    }

    public static String DataManagerLogo() {
        String logo = Installer.parseISToString(Static.class.getResourceAsStream("/datamanagerlogo"));
        logo = logo.replaceAll("( +)", TermColors.BG_BLACK + "$1");
        logo = logo.replace("_", TermColors.CYAN + TermColors.BG_CYAN + "_");
        logo = logo.replace("/", TermColors.BG_WHITE + TermColors.WHITE + "/");
        String s = logo + TermColors.reset();
        return s;
    }

    public static String GetStringResource(String name) {
        return Static.GetStringResource(Static.class, name);
    }

    public static String GetStringResource(Class path, String name) {
        return Installer.parseISToString(path.getResourceAsStream(name));
    }

    public static String MCToANSIColors(String mes) {
        if (mes == null) {
            return null;
        }
        return mes.replaceAll("(?i)\u00a7x(\u00a7[a-f0-9]){6}", "").replace("\u00a70", TermColors.BLACK).replace("\u00a71", TermColors.BLUE).replace("\u00a72", TermColors.GREEN).replace("\u00a73", TermColors.CYAN).replace("\u00a74", TermColors.RED).replace("\u00a75", TermColors.MAGENTA).replace("\u00a76", TermColors.YELLOW).replace("\u00a77", TermColors.WHITE).replace("\u00a78", TermColors.BRIGHT_BLACK).replace("\u00a79", TermColors.BRIGHT_BLUE).replace("\u00a7a", TermColors.BRIGHT_GREEN).replace("\u00a7b", TermColors.BRIGHT_CYAN).replace("\u00a7c", TermColors.BRIGHT_RED).replace("\u00a7d", TermColors.BRIGHT_MAGENTA).replace("\u00a7e", TermColors.BRIGHT_YELLOW).replace("\u00a7f", TermColors.BRIGHT_WHITE).replace("\u00a7k", "").replace("\u00a7l", TermColors.BOLD).replace("\u00a7m", TermColors.STRIKE).replace("\u00a7n", TermColors.UNDERLINE).replace("\u00a7o", TermColors.ITALIC).replace("\u00a7r", TermColors.RESET);
    }

    public static MCCommandSender GetInjectedPlayer(String name) {
        return INJECTED_PLAYERS.get(name.toLowerCase());
    }

    public static void InjectPlayer(MCCommandSender player2) {
        String name = player2.getName();
        if ("CONSOLE".equals(name)) {
            name = CONSOLE_NAME;
        }
        INJECTED_PLAYERS.put(name.toLowerCase(), player2);
    }

    public static MCCommandSender UninjectPlayer(MCCommandSender player2) {
        String name = player2.getName();
        if ("CONSOLE".equals(name)) {
            name = CONSOLE_NAME;
        }
        return INJECTED_PLAYERS.remove(name.toLowerCase());
    }

    public static void InjectEntity(MCEntity entity) {
        injectedEntity = entity;
    }

    public static void UninjectEntity(MCEntity entity) {
        injectedEntity = null;
    }

    public static void HostnameCache(final String name, final InetSocketAddress address) {
        CommandHelperPlugin.hostnameLookupThreadPool.submit(new Runnable(){

            @Override
            public void run() {
                CommandHelperPlugin.hostnameLookupCache.put(name, address.getHostName());
            }
        });
    }

    public static void SetPlayerHost(String playerName, String host) {
        HOST_CACHE.put(playerName, host);
    }

    public static String GetHost(MCPlayer p2) {
        return HOST_CACHE.get(p2.getName());
    }

    public static void AssertPlayerNonNull(MCPlayer p2, Target t) throws ConfigRuntimeException {
        if (p2 == null) {
            throw new CREPlayerOfflineException("No player was specified!", t);
        }
    }

    public static long msToTicks(long ms) {
        return ms / 50L;
    }

    public static long ticksToMs(long ticks) {
        return ticks * 50L;
    }

    public static void AssertNonNull(Object var, String message) throws NullPointerException {
        if (var == null) {
            throw new NullPointerException(message);
        }
    }

    public static Environment GenerateStandaloneEnvironment(boolean install, EnumSet<RuntimeMode> runtimeModes) throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException {
        return Static.GenerateStandaloneEnvironment(install, runtimeModes, null, null);
    }

    public static Environment GenerateStandaloneEnvironment(boolean install, EnumSet<RuntimeMode> runtimeModes, IncludeCache includeCache, StaticAnalysis staticAnalysis) throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException {
        File platformFolder = MethodScriptFileLocations.getDefault().getConfigDirectory();
        if (install) {
            Installer.Install(platformFolder);
        }
        ConnectionMixinFactory.ConnectionMixinOptions options = new ConnectionMixinFactory.ConnectionMixinOptions();
        options.setWorkingDirectory(platformFolder);
        ProfilesImpl profiles = MethodScriptFileLocations.getDefault().getProfilesFile().exists() ? new ProfilesImpl(MethodScriptFileLocations.getDefault().getProfilesFile()) : new ProfilesImpl();
        PersistenceNetworkImpl persistenceNetwork = new PersistenceNetworkImpl(MethodScriptFileLocations.getDefault().getPersistenceConfig(), new URI(URLEncoder.encode("sqlite://" + new File(platformFolder, "persistence.db").getCanonicalPath().replace('\\', '/'), "UTF-8")), options);
        GlobalEnv gEnv = new GlobalEnv(platformFolder, runtimeModes);
        gEnv.SetLabel(GLOBAL_PERMISSION);
        StaticRuntimeEnv staticRuntimeEnv = new StaticRuntimeEnv(new Profiler(MethodScriptFileLocations.getDefault().getProfilerConfigFile()), persistenceNetwork, profiles, new TaskManagerImpl(), new ExecutionQueueImpl("MethodScriptExecutionQueue", "default"), includeCache == null ? new IncludeCache() : includeCache, staticAnalysis);
        return Environment.createEnvironment(gEnv, staticRuntimeEnv, new CompilerEnvironment());
    }

    public static Environment GenerateStandaloneEnvironment(boolean install) throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException {
        return Static.GenerateStandaloneEnvironment(install, EnumSet.of(RuntimeMode.EMBEDDED));
    }

    public static Environment GenerateStandaloneEnvironment() throws IOException, DataSourceException, URISyntaxException, Profiles.InvalidProfileException {
        return Static.GenerateStandaloneEnvironment(true);
    }

    public static void AssertNonCNull(Target t, Mixed ... args) throws ConfigRuntimeException {
        for (Mixed arg : args) {
            if (!(arg instanceof CNull)) continue;
            throw new CRENullPointerException("Argument was null, and nulls are not allowed.", t);
        }
    }

    public static String GetStacktraceString(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static File GetFileFromArgument(String arg, Environment env, Target t, File def) throws ConfigRuntimeException {
        File f;
        if (arg == null) {
            return def;
        }
        if (((String)arg).startsWith("~")) {
            arg = System.getProperty("user.home") + ((String)arg).substring(1);
        }
        if ((f = new File((String)arg)).isAbsolute()) {
            return f;
        }
        if (env != null && env.hasEnv(GlobalEnv.class) && env.getEnv(GlobalEnv.class).inInterpreterMode()) {
            return new File(env.getEnv(GlobalEnv.class).GetRootFolder(), (String)arg);
        }
        if (t.file() == null) {
            throw new CREIOException("Unable to receive a non-absolute file with an unknown target", t);
        }
        return new File(t.file().getParent(), (String)arg);
    }

    public static boolean InCmdLine(Environment environment, boolean defaultValue) {
        if (environment == null || !environment.hasEnv(GlobalEnv.class)) {
            return defaultValue;
        }
        return environment.getEnv(GlobalEnv.class).inCmdlineMode();
    }

    public static <T extends Mixed> T AssertType(Class<T> type, Mixed[] args, int argNumber, Function func, Target t) {
        Mixed value = args[argNumber];
        if (!type.isAssignableFrom(value.getClass())) {
            typeof todesired = ClassDiscovery.GetClassAnnotation(type, typeof.class);
            CClassType toactual = value.typeof();
            if (todesired != null) {
                throw new CRECastException("Argument " + (argNumber + 1) + " of " + func.getName() + " was expected to be a " + todesired.value() + ", but " + String.valueOf(toactual) + " \"" + value.val() + "\" was found.", t);
            }
            throw new IllegalArgumentException("");
        }
        return (T)value;
    }

    public static Construct getMSObject(Object object, Target t) {
        if (object == null) {
            return CNull.NULL;
        }
        if (object instanceof Boolean) {
            return CBoolean.get((Boolean)object);
        }
        if (object instanceof Byte) {
            Byte b = (Byte)object;
            return new CInt(b.longValue(), t);
        }
        if (object instanceof Short) {
            Short s = (Short)object;
            return new CInt(s.longValue(), t);
        }
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return new CInt(i.longValue(), t);
        }
        if (object instanceof Long) {
            return new CInt((Long)object, t);
        }
        if (object instanceof Float) {
            Float f = (Float)object;
            return new CDouble(f.doubleValue(), t);
        }
        if (object instanceof Double) {
            return new CDouble((Double)object, t);
        }
        if (object instanceof Character) {
            return new CString(((Character)object).charValue(), t);
        }
        if (object instanceof String) {
            return new CString((String)object, t);
        }
        if (object instanceof StringBuffer) {
            return new CResource<StringBuffer>((StringBuffer)object, new CResource.ResourceToString(){

                @Override
                public String getString(CResource res) {
                    return res.getResource().toString();
                }
            }, t);
        }
        if (object instanceof XMLDocument) {
            return new CResource<XMLDocument>((XMLDocument)object, t);
        }
        if (object instanceof Construct) {
            return (Construct)object;
        }
        if (object instanceof boolean[]) {
            boolean[] array2 = (boolean[])object;
            CArray r = new CArray(t);
            for (boolean b : array2) {
                r.push(CBoolean.get(b), t);
            }
            return r;
        }
        if (object instanceof byte[]) {
            return CByteArray.wrap((byte[])object, t);
        }
        if (object instanceof char[]) {
            char[] array3 = (char[])object;
            CArray r = new CArray(t);
            for (char c : array3) {
                r.push(new CString(c, t), t);
            }
            return r;
        }
        if (object instanceof short[]) {
            short[] array4 = (short[])object;
            CArray r = new CArray(t);
            for (short s : array4) {
                r.push(new CInt(s, t), t);
            }
            return r;
        }
        if (object instanceof int[]) {
            int[] array5 = (int[])object;
            CArray r = new CArray(t);
            for (int i : array5) {
                r.push(new CInt(i, t), t);
            }
            return r;
        }
        if (object instanceof long[]) {
            long[] array6 = (long[])object;
            CArray r = new CArray(t);
            for (long l : array6) {
                r.push(new CInt(l, t), t);
            }
            return r;
        }
        if (object instanceof float[]) {
            float[] array7 = (float[])object;
            CArray r = new CArray(t);
            for (float f : array7) {
                r.push(new CDouble(f, t), t);
            }
            return r;
        }
        if (object instanceof double[]) {
            double[] array8 = (double[])object;
            CArray r = new CArray(t);
            for (double d : array8) {
                r.push(new CDouble(d, t), t);
            }
            return r;
        }
        if (object instanceof Object[]) {
            CArray r = new CArray(t);
            for (Object o : (Object[])object) {
                r.push(o == object ? r : Static.getMSObject(o, t), t);
            }
            return r;
        }
        if (object instanceof Collection) {
            return Static.getMSObject(((Collection)object).toArray(), t);
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            CArray r = CArray.GetAssociativeArray(t);
            for (Object key : map.keySet()) {
                Object o = map.get(key);
                r.set(key.toString(), (Mixed)(o == object ? r : Static.getMSObject(o, t)), t);
            }
            return r;
        }
        return new CString(object.toString(), t);
    }

    public static Object getJavaObject(Mixed construct) {
        if (construct == null || construct instanceof CNull) {
            return null;
        }
        if (construct instanceof CVoid) {
            return "";
        }
        if (construct instanceof CBoolean) {
            return ((CBoolean)construct).getBoolean();
        }
        if (construct instanceof CInt) {
            return ((CInt)construct).getInt();
        }
        if (construct instanceof CDouble) {
            return ((CDouble)construct).getDouble();
        }
        if (construct instanceof CString) {
            return construct.val();
        }
        if (construct instanceof CByteArray) {
            return ((CByteArray)construct).asByteArrayCopy();
        }
        if (construct instanceof CResource) {
            return ((CResource)construct).getResource();
        }
        if (construct.isInstanceOf(CArray.TYPE)) {
            CArray array2 = (CArray)construct;
            if (array2.isAssociative()) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                for (Mixed key : array2.keySet()) {
                    Mixed c = array2.get(key.val(), Target.UNKNOWN);
                    map.put(key.val(), c == array2 ? map : Static.getJavaObject(c));
                }
                return map;
            }
            Object[] a = new Object[(int)array2.size()];
            boolean nullable = false;
            Class<?> clazz = null;
            int i = 0;
            while ((long)i < array2.size()) {
                Mixed c = array2.get(i, Target.UNKNOWN);
                a[i] = c == array2 ? a : Static.getJavaObject(array2.get(i, Target.UNKNOWN));
                if (a[i] != null) {
                    if (clazz == null) {
                        clazz = a[i].getClass();
                    } else if (!clazz.equals(Object.class)) {
                        Class<?> cl = a[i].getClass();
                        while (!clazz.isAssignableFrom(cl)) {
                            clazz = clazz.getSuperclass();
                        }
                    }
                } else {
                    nullable = true;
                }
                ++i;
            }
            if (clazz != null && !clazz.equals(Object.class)) {
                if (clazz.equals(Boolean.class) && !nullable) {
                    boolean[] r = new boolean[a.length];
                    for (int i2 = 0; i2 < a.length; ++i2) {
                        r[i2] = (Boolean)a[i2];
                    }
                    return r;
                }
                if (clazz.equals(Long.class) && !nullable) {
                    long[] r = new long[a.length];
                    for (int i3 = 0; i3 < a.length; ++i3) {
                        r[i3] = (Long)a[i3];
                    }
                    return r;
                }
                if (clazz.equals(Double.class) && !nullable) {
                    double[] r = new double[a.length];
                    for (int i4 = 0; i4 < a.length; ++i4) {
                        r[i4] = (Double)a[i4];
                    }
                    return r;
                }
                Object[] r = (Object[])Array.newInstance(clazz, a.length);
                System.arraycopy(a, 0, r, 0, a.length);
                return r;
            }
            return a;
        }
        return construct;
    }

    public static Locale GetLocale(String fromLocaleString) {
        for (Locale loc : Locale.getAvailableLocales()) {
            if (!loc.toString().toLowerCase().equals(fromLocaleString.toLowerCase())) continue;
            return loc;
        }
        return null;
    }

    static {
        HOST_CACHE = new HashMap<String, String>();
        debugLogFileCurrent = null;
        debugLogFileHandle = null;
        standardLogFileCurrent = null;
        standardLogFileHandle = null;
        profilingLogFileCurrent = null;
        profilingLogFileHandle = null;
        INVALID_HEX = Pattern.compile("0x[a-fA-F0-9]*[^a-fA-F0-9]+[a-fA-F0-9]*");
        VALID_HEX = Pattern.compile("0x[a-fA-F0-9]+");
        INVALID_BINARY = Pattern.compile("0b[01]*[^01]+[01]*");
        VALID_BINARY = Pattern.compile("0b[01]+");
        INVALID_OCTAL = Pattern.compile("0o[0-7]*[^0-7]+[0-7]*");
        VALID_OCTAL = Pattern.compile("0o[0-7]+");
        VALID_DECIMAL = Pattern.compile("0m[0-9]+");
        INVALID_DECIMAL = Pattern.compile("0m[0-9]*[^0-9]+[0-9]*");
        INJECTED_PLAYERS = new HashMap<String, MCCommandSender>();
        DASHLESS_PATTERN = Pattern.compile("^([A-Fa-f0-9]{8})([A-Fa-f0-9]{4})([A-Fa-f0-9]{4})([A-Fa-f0-9]{4})([A-Fa-f0-9]{12})$");
    }
}

