/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.HeapDumper;
import com.laytonsmith.PureUtilities.TermColors;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.noboilerplate;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.MethodScriptFileLocations;
import com.laytonsmith.core.Optimizable;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Prefs;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.FileOptions;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.IVariable;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CREPluginInternalException;
import com.laytonsmith.core.exceptions.CRE.CREThrowable;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.AbstractFunction;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.natives.interfaces.Sizeable;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class Debug {
    public static String docs() {
        return "Provides methods for viewing data about both CommandHelper and the other plugins in your server. Though not meant to be called by normal scripts, these methods are available everywhere other methods are available. Note that for some of these functions to even work, play-dirty mode must set to on. These are most useful in conjunction with interpreter mode.";
    }

    @api
    @noboilerplate
    public static class set_debug_output
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Script.debugOutput = ArgumentValidation.getBoolean(args[0], t);
            if (Script.debugOutput) {
                StreamUtils.GetSystemOut().println(TermColors.BG_RED + "[[DEBUG]] set_debug_output(true)" + TermColors.RESET);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "set_debug_output";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "void {booleanValue} Turns verbose debug output on or off. This should generally never be on in a production server, but can be useful to quickly trace what a script is doing when it runs in a test environment. When on, every single function call will be printed out, along with the parameters passed in to it. To reduce impact on scripts when this is disabled, this has been implemented as a system wide setting, and applies to all scripts running in the same system.";
        }

        @Override
        public Version since() {
            return MSVersion.V3_3_3;
        }
    }

    @api
    @noboilerplate
    public static class heap_dump
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREPluginInternalException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            File file = new File("dump.hprof");
            try {
                HeapDumper.dumpHeap(file.getAbsolutePath(), true);
            }
            catch (Throwable tt) {
                throw new CREPluginInternalException("Could not create a heap dump: " + tt.getMessage(), t, tt);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "heap_dump";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        @Override
        public String docs() {
            return "void {} Creates a heap dump file, and places it in the working directory, as \"dump.hprof\". This might throw a PluginInternalException if the heap dump tools aren't available in your JVM. Once dumped, the heap dump can be analyzed using tools such as jhat. More information about jhat can be found [http://docs.oracle.com/javase/6/docs/technotes/tools/share/jhat.html here].";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    public static class dump_threads
    extends AbstractFunction {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return null;
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
            CArray carray = new CArray(t);
            for (Thread thread2 : threadSet) {
                carray.push(new CString(thread2.getName(), t), t);
            }
            return carray;
        }

        @Override
        public String getName() {
            return "dump_threads";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{0};
        }

        @Override
        public String docs() {
            return "array {} Returns an array of all thread names that are currently running in the JVM. This is a debugging tool for your server, and less of a CommandHelper specific thing.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api
    @seealso(value={trace.class})
    public static class always_trace
    extends AbstractFunction
    implements Optimizable {
        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CRECastException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public Boolean runAsync() {
            return null;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            return always_trace.doTrace(t, environment, args);
        }

        @Override
        public boolean preResolveVariables() {
            return false;
        }

        @Override
        public String getName() {
            return "always_trace";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "void {ivar} Outputs debug information about a variable to standard out. Unlike {{function|debug}}, this only accepts an ivar; it is a meta function. The runtime will then take the variable, and output information about it, in a human readable format, including the variable's defined type, actual type, name and value.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_4;
        }

        @Override
        public ExampleScript[] examples() throws ConfigCompileException {
            return new ExampleScript[]{new ExampleScript("Basic usage with auto type", "@m = 2;\nalways_trace(@m);", "auto (actual type ms.lang.int) @m: 2"), new ExampleScript("With defined type", "int @i = 1;\nalways_trace(@i);", "ms.lang.int (actual type ms.lang.int) @i: 1"), new ExampleScript("With subtype", "number @n = 2.0;\nalways_trace(@n);", "ms.lang.number (actual type ms.lang.double) @n: 2.0")};
        }

        public static CVoid doTrace(Target t, Environment environment, Mixed ... args) {
            if (args[0] instanceof IVariable) {
                IVariable ivar = environment.getEnv(GlobalEnv.class).GetVarList().get(((IVariable)args[0]).getVariableName(), t, environment);
                Mixed val = ivar.ival();
                StreamUtils.GetSystemOut().println(TermColors.GREEN + environment.getEnv(GlobalEnv.class).GetStackTraceManager().getCurrentStackTrace().get(0).getProcedureName() + TermColors.RESET + ":" + TermColors.YELLOW + t.file().getName() + TermColors.RESET + ":" + TermColors.CYAN + t.line() + "." + t.col() + TermColors.RESET + ": " + TermColors.BRIGHT_WHITE + String.valueOf(ivar.getDefinedType()) + TermColors.RESET + " (actual type " + TermColors.BRIGHT_WHITE + String.valueOf(val.typeof()) + (String)(val.isInstanceOf(Sizeable.TYPE) ? ", length: " + ((Sizeable)val).size() : "") + TermColors.RESET + ") " + TermColors.CYAN + ivar.getVariableName() + TermColors.RESET + ": " + val.val());
                return CVoid.VOID;
            }
            throw new CRECastException("Expecting an ivar, but received " + args[0].typeof().getSimpleName() + " instead", t);
        }

        @Override
        public Set<Optimizable.OptimizationOption> optimizationOptions() {
            return EnumSet.of(Optimizable.OptimizationOption.OPTIMIZE_DYNAMIC);
        }

        @Override
        public ParseTree optimizeDynamic(Target t, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, List<ParseTree> children, FileOptions fileOptions) throws ConfigCompileException, ConfigRuntimeException {
            if (children.size() != 1) {
                throw new ConfigCompileException(this.getName() + " expects 1 parameter, but " + children.size() + " were provided.", t);
            }
            ParseTree child = children.get(0);
            if (!(child.getData() instanceof IVariable)) {
                throw new ConfigCompileException(this.getName() + " can only accept an ivar as the argument.", t);
            }
            return null;
        }
    }

    @api
    @seealso(value={always_trace.class})
    public static class trace
    extends always_trace {
        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (Prefs.DebugMode().booleanValue()) {
                return always_trace.doTrace(t, environment, args);
            }
            return CVoid.VOID;
        }

        @Override
        public String getName() {
            return "trace";
        }

        @Override
        public String docs() {
            return "void {ivar} Works like {{function|always_trace}}, but only if debug-mode is enabled in the preferences. See {{function|always_trace}} for details of the output.";
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_1;
        }
    }

    @api(environments={GlobalEnv.class})
    public static class debug
    extends AbstractFunction {
        @Override
        public String getName() {
            return "debug";
        }

        @Override
        public Integer[] numArgs() {
            return new Integer[]{1};
        }

        @Override
        public String docs() {
            return "void {message} Manually logs a timestamped message to the debug log and the console, if debug-mode is set to true in the preferences";
        }

        @Override
        public Class<? extends CREThrowable>[] thrown() {
            return new Class[]{CREIOException.class};
        }

        @Override
        public boolean isRestricted() {
            return true;
        }

        @Override
        public MSVersion since() {
            return MSVersion.V3_3_0;
        }

        @Override
        public Boolean runAsync() {
            return true;
        }

        @Override
        public Mixed exec(Target t, Environment environment, Mixed ... args) throws ConfigRuntimeException {
            if (Prefs.DebugMode().booleanValue()) {
                try {
                    Static.LogDebug(MethodScriptFileLocations.getDefault().getConfigDirectory(), args[0].val(), LogLevel.DEBUG);
                }
                catch (IOException ex) {
                    throw new CREIOException(ex.getMessage(), t, ex);
                }
            }
            return CVoid.VOID;
        }
    }
}

