/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums;

import com.laytonsmith.abstraction.MCNamespacedKey;
import com.laytonsmith.abstraction.MCTagContainer;
import com.laytonsmith.abstraction.StaticLayer;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CDouble;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.CString;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CREFormatException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.function.Function;

public enum MCTagType {
    BYTE(v -> ArgumentValidation.getInt8(v, v.getTarget()), v -> new CInt(((Number)v).longValue(), Target.UNKNOWN)),
    BYTE_ARRAY(v -> {
        CArray array2 = ArgumentValidation.getArray(v, v.getTarget());
        if (array2.isAssociative()) {
            throw new CRECastException("Expected byte array to not be associative.", v.getTarget());
        }
        byte[] bytes = new byte[(int)array2.size()];
        int i = 0;
        for (Mixed m : array2) {
            bytes[i++] = ArgumentValidation.getInt8(m, m.getTarget());
        }
        return bytes;
    }, array2 -> {
        CArray r = new CArray(Target.UNKNOWN);
        for (byte i : array2) {
            r.push(new CInt(i, Target.UNKNOWN), Target.UNKNOWN);
        }
        return r;
    }),
    DOUBLE(v -> ArgumentValidation.getDouble(v, v.getTarget()), v -> new CDouble((double)v, Target.UNKNOWN)),
    FLOAT(v -> Float.valueOf(ArgumentValidation.getDouble32(v, v.getTarget())), v -> new CDouble(v.doubleValue(), Target.UNKNOWN)),
    INTEGER(v -> ArgumentValidation.getInt32(v, v.getTarget()), v -> new CInt(((Number)v).longValue(), Target.UNKNOWN)),
    INTEGER_ARRAY(v -> {
        CArray array2 = ArgumentValidation.getArray(v, v.getTarget());
        if (array2.isAssociative()) {
            throw new CRECastException("Expected integer array to not be associative.", v.getTarget());
        }
        int[] ints = new int[(int)array2.size()];
        int i = 0;
        for (Mixed m : array2) {
            ints[i++] = ArgumentValidation.getInt32(m, m.getTarget());
        }
        return ints;
    }, array2 -> {
        CArray r = new CArray(Target.UNKNOWN);
        for (int i : array2) {
            r.push(new CInt(i, Target.UNKNOWN), Target.UNKNOWN);
        }
        return r;
    }),
    LONG(v -> ArgumentValidation.getInt(v, v.getTarget()), v -> new CInt((long)v, Target.UNKNOWN)),
    LONG_ARRAY(v -> {
        CArray array2 = ArgumentValidation.getArray(v, v.getTarget());
        if (array2.isAssociative()) {
            throw new CRECastException("Expected long array to not be associative.", v.getTarget());
        }
        long[] longs = new long[(int)array2.size()];
        int i = 0;
        for (Mixed m : array2) {
            longs[i++] = ArgumentValidation.getInt(m, m.getTarget());
        }
        return longs;
    }, array2 -> {
        CArray ret = new CArray(Target.UNKNOWN);
        for (long i : array2) {
            ret.push(new CInt(i, Target.UNKNOWN), Target.UNKNOWN);
        }
        return ret;
    }),
    SHORT(v -> ArgumentValidation.getInt16(v, v.getTarget()), v -> new CInt(((Number)v).longValue(), Target.UNKNOWN)),
    STRING(v -> v.val(), v -> new CString((String)v, Target.UNKNOWN)),
    TAG_CONTAINER(v -> {
        throw new UnsupportedOperationException();
    }, v -> {
        throw new UnsupportedOperationException();
    }),
    TAG_CONTAINER_ARRAY(v -> {
        throw new UnsupportedOperationException();
    }, v -> {
        throw new UnsupportedOperationException();
    });

    private final Function conversion;
    private final Function construction;

    private <T extends Mixed, Z> MCTagType(Function<T, Z> conversion, Function<Z, T> construction) {
        this.conversion = conversion;
        this.construction = construction;
    }

    public Object convert(MCTagContainer container, Mixed value) {
        if (this == TAG_CONTAINER) {
            if (!value.isInstanceOf(CArray.TYPE)) {
                throw new CREFormatException("Expected tag container to be an array.", value.getTarget());
            }
            CArray containerArray = (CArray)value;
            if (!containerArray.isAssociative()) {
                throw new CREFormatException("Expected tag container array to be associative.", value.getTarget());
            }
            for (String key : containerArray.stringKeySet()) {
                MCTagType tagType;
                Mixed possibleArray = containerArray.get(key, value.getTarget());
                if (!possibleArray.isInstanceOf(CArray.TYPE)) {
                    throw new CREFormatException("Expected tag entry to be an array.", possibleArray.getTarget());
                }
                CArray entryArray = (CArray)possibleArray;
                if (!entryArray.isAssociative()) {
                    throw new CREFormatException("Expected tag array to be associative.", entryArray.getTarget());
                }
                Mixed entryType = entryArray.get("type", entryArray.getTarget());
                Mixed entryValue = entryArray.get("value", entryArray.getTarget());
                try {
                    tagType = MCTagType.valueOf(entryType.val());
                }
                catch (IllegalArgumentException ex) {
                    throw new CREFormatException("Tag type is not valid: " + entryType.val(), entryType.getTarget());
                }
                Object tagValue = tagType == TAG_CONTAINER ? tagType.convert(container.newContainer(), entryValue) : (tagType == TAG_CONTAINER_ARRAY ? tagType.convert(container, entryValue) : tagType.convert(container, entryValue));
                try {
                    container.set(StaticLayer.GetConvertor().GetNamespacedKey(key), tagType, tagValue);
                }
                catch (ClassCastException ex) {
                    throw new CREFormatException("Tag value does not match expected type.", entryValue.getTarget());
                }
                catch (IllegalArgumentException ex) {
                    throw new CREFormatException(ex.getMessage(), entryValue.getTarget());
                }
            }
            return container;
        }
        if (this == TAG_CONTAINER_ARRAY) {
            if (!value.isInstanceOf(CArray.TYPE)) {
                throw new CREFormatException("Expected tag container to be an array.", value.getTarget());
            }
            CArray array2 = (CArray)value;
            if (array2.isAssociative()) {
                throw new CREFormatException("Expected tag container array to not be associative.", array2.getTarget());
            }
            MCTagContainer[] containers = new MCTagContainer[(int)array2.size()];
            int i = 0;
            for (Mixed possibleContainer : array2) {
                containers[i++] = (MCTagContainer)TAG_CONTAINER.convert(container.newContainer(), possibleContainer);
            }
            return containers;
        }
        return this.conversion.apply(value);
    }

    public Mixed construct(Object value) throws ClassCastException {
        if (this == TAG_CONTAINER) {
            MCTagContainer container = (MCTagContainer)value;
            CArray containerArray = CArray.GetAssociativeArray(Target.UNKNOWN);
            for (MCNamespacedKey key : container.getKeys()) {
                CArray entry = CArray.GetAssociativeArray(Target.UNKNOWN);
                MCTagType type = container.getType(key);
                entry.set("type", type.name(), Target.UNKNOWN);
                entry.set("value", type.construct(container.get(key, type)), Target.UNKNOWN);
                containerArray.set(key.toString(), (Mixed)entry, Target.UNKNOWN);
            }
            return containerArray;
        }
        if (this == TAG_CONTAINER_ARRAY) {
            MCTagContainer[] containers = (MCTagContainer[])value;
            CArray array2 = new CArray(Target.UNKNOWN, containers.length);
            for (MCTagContainer container : containers) {
                array2.push(TAG_CONTAINER.construct(container), Target.UNKNOWN);
            }
            return array2;
        }
        return (Mixed)this.construction.apply(value);
    }
}

