/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events;

import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.blocks.MCBlockState;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorld;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockState;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.enums.MCTreeType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCTreeType;
import com.laytonsmith.abstraction.events.MCStructureGrowEvent;
import com.laytonsmith.abstraction.events.MCWorldEvent;
import com.laytonsmith.abstraction.events.MCWorldLoadEvent;
import com.laytonsmith.abstraction.events.MCWorldSaveEvent;
import com.laytonsmith.abstraction.events.MCWorldUnloadEvent;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.event.world.WorldEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldSaveEvent;
import org.bukkit.event.world.WorldUnloadEvent;

public final class BukkitWorldEvents {
    private BukkitWorldEvents() {
    }

    public static class BukkitMCWorldLoadEvent
    extends BukkitMCWorldEvent
    implements MCWorldLoadEvent {
        public BukkitMCWorldLoadEvent(WorldLoadEvent event) {
            super((WorldEvent)event);
        }
    }

    public static class BukkitMCWorldUnloadEvent
    extends BukkitMCWorldEvent
    implements MCWorldUnloadEvent {
        public BukkitMCWorldUnloadEvent(WorldUnloadEvent event) {
            super((WorldEvent)event);
        }
    }

    public static class BukkitMCWorldSaveEvent
    extends BukkitMCWorldEvent
    implements MCWorldSaveEvent {
        public BukkitMCWorldSaveEvent(WorldSaveEvent event) {
            super((WorldEvent)event);
        }
    }

    public static class BukkitMCStructureGrowEvent
    extends BukkitMCWorldEvent
    implements MCStructureGrowEvent {
        private final StructureGrowEvent event;

        public BukkitMCStructureGrowEvent(StructureGrowEvent event) {
            super((WorldEvent)event);
            this.event = event;
        }

        @Override
        public List<MCBlockState> getBlocks() {
            List blocks = this.event.getBlocks();
            ArrayList<MCBlockState> r = new ArrayList<MCBlockState>(blocks.size());
            for (BlockState block : blocks) {
                r.add(new BukkitMCBlockState(block));
            }
            return r;
        }

        @Override
        public MCLocation getLocation() {
            return new BukkitMCLocation(this.event.getLocation());
        }

        @Override
        public MCPlayer getPlayer() {
            Player player2 = this.event.getPlayer();
            return player2 == null ? null : new BukkitMCPlayer((Entity)this.event.getPlayer());
        }

        @Override
        public MCTreeType getSpecies() {
            return (MCTreeType)((Object)BukkitMCTreeType.getConvertor().getAbstractedEnum(this.event.getSpecies()));
        }

        @Override
        public boolean isFromBonemeal() {
            return this.event.isFromBonemeal();
        }
    }

    public static abstract class BukkitMCWorldEvent
    implements MCWorldEvent {
        private final WorldEvent event;

        public BukkitMCWorldEvent(WorldEvent event) {
            this.event = event;
        }

        @Override
        public Object _GetObject() {
            return this.event;
        }

        @Override
        public MCWorld getWorld() {
            return new BukkitMCWorld(this.event.getWorld());
        }
    }
}

