/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.threeten.bp.zone;

import com.laytonsmith.libs.threeten.bp.zone.ZoneRulesProvider;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

public abstract class ZoneRulesInitializer {
    public static final ZoneRulesInitializer DO_NOTHING = new DoNothingZoneRulesInitializer();
    private static final AtomicBoolean INITIALIZED = new AtomicBoolean(false);
    private static final AtomicReference<ZoneRulesInitializer> INITIALIZER = new AtomicReference();

    public static void setInitializer(ZoneRulesInitializer initializer) {
        if (INITIALIZED.get()) {
            throw new IllegalStateException("Already initialized");
        }
        if (!INITIALIZER.compareAndSet(null, initializer)) {
            throw new IllegalStateException("Initializer was already set, possibly with a default during initialization");
        }
    }

    static void initialize() {
        if (INITIALIZED.getAndSet(true)) {
            throw new IllegalStateException("Already initialized");
        }
        INITIALIZER.compareAndSet(null, new ServiceLoaderZoneRulesInitializer());
        INITIALIZER.get().initializeProviders();
    }

    protected abstract void initializeProviders();

    static class ServiceLoaderZoneRulesInitializer
    extends ZoneRulesInitializer {
        ServiceLoaderZoneRulesInitializer() {
        }

        @Override
        protected void initializeProviders() {
            ServiceLoader<ZoneRulesProvider> loader = ServiceLoader.load(ZoneRulesProvider.class, ZoneRulesProvider.class.getClassLoader());
            for (ZoneRulesProvider provider : loader) {
                try {
                    ZoneRulesProvider.registerProvider(provider);
                }
                catch (ServiceConfigurationError ex) {
                    if (ex.getCause() instanceof SecurityException) continue;
                    throw ex;
                }
            }
        }
    }

    static class DoNothingZoneRulesInitializer
    extends ZoneRulesInitializer {
        DoNothingZoneRulesInitializer() {
        }

        @Override
        protected void initializeProviders() {
        }
    }
}

