/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.AbstractionObject;
import com.laytonsmith.abstraction.MCAttributeModifier;
import com.laytonsmith.abstraction.MCCooldownComponent;
import com.laytonsmith.abstraction.MCEquippableComponent;
import com.laytonsmith.abstraction.MCFoodComponent;
import com.laytonsmith.abstraction.MCItemMeta;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCTagContainer;
import com.laytonsmith.abstraction.blocks.MCBlockData;
import com.laytonsmith.abstraction.blocks.MCMaterial;
import com.laytonsmith.abstraction.bukkit.BukkitMCAttributeModifier;
import com.laytonsmith.abstraction.bukkit.BukkitMCCooldownComponent;
import com.laytonsmith.abstraction.bukkit.BukkitMCEquippableComponent;
import com.laytonsmith.abstraction.bukkit.BukkitMCFoodComponent;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCServer;
import com.laytonsmith.abstraction.bukkit.BukkitMCTagContainer;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockData;
import com.laytonsmith.abstraction.enums.MCEnchantment;
import com.laytonsmith.abstraction.enums.MCItemFlag;
import com.laytonsmith.abstraction.enums.MCItemRarity;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEnchantment;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCItemFlag;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.JukeboxSong;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.block.data.BlockData;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemRarity;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockDataMeta;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.Repairable;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.inventory.meta.components.FoodComponent;
import org.bukkit.inventory.meta.components.JukeboxPlayableComponent;
import org.bukkit.inventory.meta.components.UseCooldownComponent;

public class BukkitMCItemMeta
implements MCItemMeta {
    ItemMeta im;

    public BukkitMCItemMeta(ItemMeta im) {
        this.im = im;
    }

    public BukkitMCItemMeta(AbstractionObject o) {
        this.im = (ItemMeta)o;
    }

    @Override
    public boolean hasDisplayName() {
        return this.im.hasDisplayName();
    }

    @Override
    public String getDisplayName() {
        return this.im.getDisplayName();
    }

    @Override
    public void setDisplayName(String name) {
        this.im.setDisplayName(name);
    }

    @Override
    public boolean hasLore() {
        return this.im.hasLore();
    }

    @Override
    public List<String> getLore() {
        return this.im.getLore();
    }

    @Override
    public void setLore(List<String> lore) {
        this.im.setLore(lore);
    }

    @Override
    public boolean hasEnchants() {
        return this.im.hasEnchants();
    }

    @Override
    public Map<MCEnchantment, Integer> getEnchants() {
        HashMap<MCEnchantment, Integer> map = new HashMap<MCEnchantment, Integer>();
        for (Map.Entry entry : this.im.getEnchants().entrySet()) {
            map.put(BukkitMCEnchantment.valueOfConcrete((Enchantment)entry.getKey()), (Integer)entry.getValue());
        }
        return map;
    }

    @Override
    public boolean addEnchant(MCEnchantment ench, int level, boolean ignoreLevelRestriction) {
        return this.im.addEnchant((Enchantment)ench.getConcrete(), level, ignoreLevelRestriction);
    }

    @Override
    public boolean removeEnchant(MCEnchantment ench) {
        return this.im.removeEnchant((Enchantment)ench.getConcrete());
    }

    @Override
    public Object getHandle() {
        return this.im;
    }

    public ItemMeta asItemMeta() {
        return this.im;
    }

    public boolean equals(Object obj) {
        return obj instanceof MCItemMeta && this.im.equals(((MCItemMeta)obj).getHandle());
    }

    public int hashCode() {
        return this.im.hashCode();
    }

    public String toString() {
        return this.im.toString();
    }

    @Override
    public boolean hasRepairCost() {
        return ((Repairable)this.im).hasRepairCost();
    }

    @Override
    public int getRepairCost() {
        return ((Repairable)this.im).getRepairCost();
    }

    @Override
    public void setRepairCost(int cost) {
        ((Repairable)this.im).setRepairCost(cost);
    }

    @Override
    public void addItemFlags(MCItemFlag ... flags) {
        for (MCItemFlag flag : flags) {
            this.im.addItemFlags(new ItemFlag[]{(ItemFlag)BukkitMCItemFlag.getConvertor().getConcreteEnum(flag)});
        }
    }

    @Override
    public Set<MCItemFlag> getItemFlags() {
        Set flags = this.im.getItemFlags();
        HashSet<MCItemFlag> ret = new HashSet<MCItemFlag>(flags.size());
        for (ItemFlag flag : flags) {
            try {
                ret.add(MCItemFlag.valueOf(flag.name()));
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return ret;
    }

    @Override
    public boolean isUnbreakable() {
        return this.im.isUnbreakable();
    }

    @Override
    public void setUnbreakable(boolean unbreakable2) {
        this.im.setUnbreakable(unbreakable2);
    }

    @Override
    public boolean hasDamage() {
        if (((BukkitMCServer)Static.getServer()).isPaper() && Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_21)) {
            return ((Damageable)this.im).hasDamageValue();
        }
        return ((Damageable)this.im).hasDamage();
    }

    @Override
    public int getDamage() {
        return ((Damageable)this.im).getDamage();
    }

    @Override
    public void setDamage(int damage) {
        ((Damageable)this.im).setDamage(damage);
    }

    @Override
    public boolean hasMaxDamage() {
        return ((Damageable)this.im).hasMaxDamage();
    }

    @Override
    public int getMaxDamage() {
        return ((Damageable)this.im).getMaxDamage();
    }

    @Override
    public void setMaxDamage(Integer damage) {
        ((Damageable)this.im).setMaxDamage(damage);
    }

    @Override
    public MCBlockData getBlockData(MCMaterial material) {
        return new BukkitMCBlockData(((BlockDataMeta)this.im).getBlockData((Material)material.getHandle()));
    }

    @Override
    public Map<String, String> getExistingBlockData() {
        try {
            Class<?> clz = Class.forName(Bukkit.getServer().getClass().getPackage().getName() + ".inventory.CraftMetaItem");
            return (Map)ReflectionUtils.get(clz, this.im, "blockData");
        }
        catch (ClassNotFoundException e) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Failed to get CraftMetaItem class.", Target.UNKNOWN);
            return null;
        }
        catch (ReflectionUtils.ReflectionException ex) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Failed to get blockData from CraftMetaItem.", Target.UNKNOWN);
            return null;
        }
    }

    @Override
    public boolean hasBlockData() {
        return ((BlockDataMeta)this.im).hasBlockData();
    }

    @Override
    public void setBlockData(MCBlockData blockData) {
        ((BlockDataMeta)this.im).setBlockData((BlockData)blockData.getHandle());
    }

    @Override
    public boolean hasCustomModelData() {
        return this.im.hasCustomModelData();
    }

    @Override
    public int getCustomModelData() {
        return this.im.getCustomModelData();
    }

    @Override
    public void setCustomModelData(int id) {
        this.im.setCustomModelData(Integer.valueOf(id));
    }

    @Override
    public List<MCAttributeModifier> getAttributeModifiers() {
        Multimap modifiers = this.im.getAttributeModifiers();
        if (modifiers == null) {
            return null;
        }
        ArrayList<MCAttributeModifier> ret = new ArrayList<MCAttributeModifier>();
        for (Map.Entry modifier : modifiers.entries()) {
            ret.add(new BukkitMCAttributeModifier((Attribute)modifier.getKey(), (AttributeModifier)modifier.getValue()));
        }
        return ret;
    }

    @Override
    public void setAttributeModifiers(List<MCAttributeModifier> modifiers) {
        LinkedHashMultimap map = LinkedHashMultimap.create();
        for (MCAttributeModifier m : modifiers) {
            map.put((Object)((Attribute)m.getAttribute().getConcrete()), (Object)((AttributeModifier)m.getHandle()));
        }
        this.im.setAttributeModifiers((Multimap)map);
    }

    @Override
    public boolean hasCustomTags() {
        return !this.im.getPersistentDataContainer().isEmpty();
    }

    @Override
    public MCTagContainer getCustomTags() {
        return new BukkitMCTagContainer(this.im.getPersistentDataContainer());
    }

    @Override
    public boolean hasItemName() {
        return this.im.hasItemName();
    }

    @Override
    public String getItemName() {
        return this.im.getItemName();
    }

    @Override
    public void setItemName(String name) {
        this.im.setItemName(name);
    }

    @Override
    public boolean isHideTooltip() {
        return this.im.isHideTooltip();
    }

    @Override
    public void setHideTooltip(boolean hide2) {
        this.im.setHideTooltip(hide2);
    }

    @Override
    public boolean hasEnchantmentGlintOverride() {
        return this.im.hasEnchantmentGlintOverride();
    }

    @Override
    public boolean getEnchantmentGlintOverride() {
        return this.im.getEnchantmentGlintOverride();
    }

    @Override
    public void setEnchantmentGlintOverride(boolean glint) {
        this.im.setEnchantmentGlintOverride(Boolean.valueOf(glint));
    }

    @Override
    public boolean hasMaxStackSize() {
        return this.im.hasMaxStackSize();
    }

    @Override
    public int getMaxStackSize() {
        return this.im.getMaxStackSize();
    }

    @Override
    public void setMaxStackSize(Integer size) {
        this.im.setMaxStackSize(size);
    }

    @Override
    public boolean hasRarity() {
        return this.im.hasRarity();
    }

    @Override
    public MCItemRarity getRarity() {
        return MCItemRarity.valueOf(this.im.getRarity().name());
    }

    @Override
    public void setRarity(MCItemRarity rarity) {
        this.im.setRarity(ItemRarity.valueOf((String)rarity.name()));
    }

    @Override
    public boolean hasEnchantable() {
        return this.im.hasEnchantable();
    }

    @Override
    public int getEnchantable() {
        return this.im.getEnchantable();
    }

    @Override
    public void setEnchantable(Integer enchantability) {
        this.im.setEnchantable(enchantability);
    }

    @Override
    public boolean hasJukeboxPlayable() {
        return this.im.hasJukeboxPlayable();
    }

    @Override
    public String getJukeboxPlayable() {
        return this.im.getJukeboxPlayable().getSongKey().toString();
    }

    @Override
    public void setJukeboxPlayable(String playable) {
        if (playable == null) {
            this.im.setJukeboxPlayable(null);
        } else {
            JukeboxSong song = (JukeboxSong)Registry.JUKEBOX_SONG.get(NamespacedKey.fromString((String)playable));
            if (song != null) {
                JukeboxPlayableComponent component = this.im.getJukeboxPlayable();
                component.setSong(song);
                this.im.setJukeboxPlayable(component);
            }
        }
    }

    @Override
    public boolean isGlider() {
        return this.im.isGlider();
    }

    @Override
    public void setGlider(boolean glider) {
        this.im.setGlider(glider);
    }

    @Override
    public boolean hasUseRemainder() {
        return this.im.hasUseRemainder();
    }

    @Override
    public MCItemStack getUseRemainder() {
        return new BukkitMCItemStack(this.im.getUseRemainder());
    }

    @Override
    public void setUseRemainder(MCItemStack remainder) {
        this.im.setUseRemainder((ItemStack)remainder.getHandle());
    }

    @Override
    public boolean hasFood() {
        return this.im.hasFood();
    }

    @Override
    public MCFoodComponent getFood() {
        return new BukkitMCFoodComponent(this.im.getFood());
    }

    @Override
    public void setFood(MCFoodComponent component) {
        this.im.setFood((FoodComponent)component.getHandle());
    }

    @Override
    public boolean hasItemModel() {
        return this.im.hasItemModel();
    }

    @Override
    public String getItemModel() {
        return this.im.getItemModel().toString();
    }

    @Override
    public void setItemModel(String key) {
        this.im.setItemModel(NamespacedKey.fromString((String)key));
    }

    @Override
    public boolean hasTooltipStyle() {
        return this.im.hasTooltipStyle();
    }

    @Override
    public String getTooltipStyle() {
        return this.im.getTooltipStyle().toString();
    }

    @Override
    public void setTooltipStyle(String key) {
        this.im.setTooltipStyle(NamespacedKey.fromString((String)key));
    }

    @Override
    public boolean hasUseCooldown() {
        return this.im.hasUseCooldown();
    }

    @Override
    public MCCooldownComponent getUseCooldown() {
        return new BukkitMCCooldownComponent(this.im.getUseCooldown());
    }

    @Override
    public void setUseCooldown(MCCooldownComponent component) {
        this.im.setUseCooldown((UseCooldownComponent)component.getHandle());
    }

    @Override
    public boolean hasEquippable() {
        return this.im.hasEquippable();
    }

    @Override
    public MCEquippableComponent getEquippable() {
        return new BukkitMCEquippableComponent(this.im.getEquippable());
    }

    @Override
    public void setEquippable(MCEquippableComponent component) {
        this.im.setEquippable((EquippableComponent)component.getHandle());
    }
}

