/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.blocks;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCBlockProjectileSource;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import com.laytonsmith.abstraction.entities.MCProjectile;
import com.laytonsmith.abstraction.enums.MCEntityType;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Projectile;
import org.bukkit.projectiles.BlockProjectileSource;
import org.bukkit.util.Vector;

public class BukkitMCBlockProjectileSource
implements MCBlockProjectileSource {
    BlockProjectileSource bps;

    public BukkitMCBlockProjectileSource(BlockProjectileSource source) {
        this.bps = source;
    }

    @Override
    public MCProjectile launchProjectile(MCEntityType projectile) {
        EntityType et = (EntityType)projectile.getConcrete();
        Class c = et.getEntityClass();
        Projectile proj = this.bps.launchProjectile(c.asSubclass(Projectile.class));
        MCEntity e = BukkitConvertor.BukkitGetCorrectEntity((Entity)proj);
        if (e instanceof MCProjectile) {
            return (MCProjectile)e;
        }
        return null;
    }

    @Override
    public MCProjectile launchProjectile(MCEntityType projectile, Vector3D init) {
        EntityType et = (EntityType)projectile.getConcrete();
        Class c = et.getEntityClass();
        Vector vector = new Vector(init.X(), init.Y(), init.Z());
        Projectile proj = this.bps.launchProjectile(c.asSubclass(Projectile.class), vector);
        MCEntity e = BukkitConvertor.BukkitGetCorrectEntity((Entity)proj);
        if (e instanceof MCProjectile) {
            return (MCProjectile)e;
        }
        return null;
    }

    @Override
    public MCBlock getBlock() {
        return new BukkitMCBlock(this.bps.getBlock());
    }

    @Override
    public Object getHandle() {
        return this.bps;
    }
}

