/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums;

import com.laytonsmith.annotations.abstractionenum;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.constructs.Target;

public abstract class EnumConvertor<Abstracted extends Enum, Concrete extends Enum> {
    private Class<? extends Abstracted> abstractedClass;
    private Class<? extends Concrete> concreteClass;

    protected EnumConvertor() {
        abstractionenum annotation = this.getClass().getAnnotation(abstractionenum.class);
        if (annotation == null) {
            throw new Error(String.valueOf(this.getClass()) + " is not annotated with @abstractionenum.");
        }
        this.abstractedClass = annotation.forAbstractEnum();
        this.concreteClass = annotation.forConcreteEnum();
    }

    public final Abstracted getAbstractedEnum(Concrete concrete) {
        if (concrete == null) {
            return null;
        }
        try {
            return this.getAbstractedEnumCustom(concrete);
        }
        catch (IllegalArgumentException e) {
            this.doLog(this.concreteClass, this.abstractedClass, (Enum)concrete);
            return null;
        }
    }

    protected Abstracted getAbstractedEnumCustom(Concrete concrete) throws IllegalArgumentException {
        return Enum.valueOf(this.abstractedClass, ((Enum)concrete).name());
    }

    public final Concrete getConcreteEnum(Abstracted abstracted) {
        if (abstracted == null) {
            return null;
        }
        try {
            return this.getConcreteEnumCustom(abstracted);
        }
        catch (IllegalArgumentException e) {
            this.doLog(this.abstractedClass, this.concreteClass, (Enum)abstracted);
            return null;
        }
    }

    protected Concrete getConcreteEnumCustom(Abstracted abstracted) throws IllegalArgumentException {
        return Enum.valueOf(this.concreteClass, ((Enum)abstracted).name());
    }

    private void doLog(Class from, Class to, Enum value) {
        MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.RUNTIME, from.getSimpleName() + "." + value.name() + " missing a match in " + to.getSimpleName(), Target.UNKNOWN);
    }
}

