/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core;

import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import java.util.Objects;

public class UnqualifiedClassName {
    private final String unqualifedClassName;
    private final Target target;
    private final FullyQualifiedClassName fqcn;

    public UnqualifiedClassName(String unqualifiedClassName, Target target) {
        Objects.requireNonNull(unqualifiedClassName, "unqualifiedClassName may not be null");
        this.unqualifedClassName = unqualifiedClassName;
        this.target = target;
        this.fqcn = null;
    }

    public UnqualifiedClassName(FullyQualifiedClassName fqcn) {
        Objects.requireNonNull(fqcn, "fqcn may not be null");
        this.unqualifedClassName = null;
        this.target = null;
        this.fqcn = fqcn;
    }

    public String getUnqualifiedClassName() {
        return this.unqualifedClassName == null ? this.fqcn.getFQCN() : this.unqualifedClassName;
    }

    public Target getTarget() {
        return this.target;
    }

    public FullyQualifiedClassName getFQCN(Environment env) throws CRECastException {
        return this.fqcn != null ? this.fqcn : FullyQualifiedClassName.forName(this.unqualifedClassName, this.target, env);
    }

    public String toString() {
        return this.unqualifedClassName != null ? this.unqualifedClassName : "FQCN: " + String.valueOf(this.fqcn);
    }
}

