/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit;

import com.laytonsmith.abstraction.MCColor;
import com.laytonsmith.abstraction.MCFireworkBuilder;
import com.laytonsmith.abstraction.MCFireworkEffect;
import com.laytonsmith.abstraction.bukkit.BukkitMCColor;
import com.laytonsmith.abstraction.bukkit.BukkitMCFireworkEffect;
import com.laytonsmith.abstraction.enums.MCFireworkType;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCFireworkType;
import org.bukkit.FireworkEffect;

public class BukkitMCFireworkBuilder
implements MCFireworkBuilder {
    private final FireworkEffect.Builder builder = FireworkEffect.builder();

    @Override
    public MCFireworkBuilder setFlicker(boolean flicker) {
        this.builder.flicker(flicker);
        return this;
    }

    @Override
    public MCFireworkBuilder setTrail(boolean trail) {
        this.builder.trail(trail);
        return this;
    }

    @Override
    public MCFireworkBuilder addColor(MCColor color2) {
        this.builder.withColor(BukkitMCColor.GetColor(color2));
        return this;
    }

    @Override
    public MCFireworkBuilder addFadeColor(MCColor color2) {
        this.builder.withFade(BukkitMCColor.GetColor(color2));
        return this;
    }

    @Override
    public MCFireworkBuilder setType(MCFireworkType type) {
        this.builder.with((FireworkEffect.Type)BukkitMCFireworkType.getConvertor().getConcreteEnum(type));
        return this;
    }

    @Override
    public MCFireworkEffect build() {
        return new BukkitMCFireworkEffect(this.builder.build());
    }
}

