/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.functions;

import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MethodScriptCompiler;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.Security;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.compiler.analysis.Scope;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.environments.GlobalEnv;
import com.laytonsmith.core.environments.StaticRuntimeEnv;
import com.laytonsmith.core.exceptions.CRE.CREIOException;
import com.laytonsmith.core.exceptions.CRE.CREIncludeException;
import com.laytonsmith.core.exceptions.CRE.CRESecurityException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigCompileGroupException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.exceptions.ProgramFlowManipulationException;
import com.laytonsmith.core.profiler.ProfilePoint;
import com.laytonsmith.core.profiler.Profiler;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IncludeCache {
    private static final MSLog.Tags TAG = MSLog.Tags.INCLUDES;
    private final List<File> autoIncludes = new ArrayList<File>();
    private final Map<File, ParseTree> cache = new HashMap<File, ParseTree>();
    private final Map<File, StaticAnalysis> analysisCache = new HashMap<File, StaticAnalysis>();
    private final Map<Target, Scope> dynamicAnalysisParentScopeCache = new HashMap<Target, Scope>();

    public void add(File file, ParseTree tree) {
        this.cache.put(file, tree);
    }

    public void addAll(Map<File, ParseTree> files) {
        this.cache.putAll(files);
    }

    public boolean has(File file) {
        return this.cache.containsKey(file);
    }

    public int size() {
        return this.cache.size();
    }

    public static ParseTree get(File file, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Target t) {
        return IncludeCache.get(file, env, envs, new StaticAnalysis(false), t, null);
    }

    public static ParseTree get(File file, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, StaticAnalysis staticAnalysis, Target t) {
        return IncludeCache.get(file, env, envs, staticAnalysis, t, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ParseTree get(File file, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, StaticAnalysis staticAnalysis, Target t, Set<ConfigCompileException> exceptions) {
        MSLog.GetLogger().Log((MSLog.Tag)TAG, LogLevel.DEBUG, "Loading " + String.valueOf(file), t);
        IncludeCache includeCache = env.getEnv(StaticRuntimeEnv.class).getIncludeCache();
        if (includeCache.cache.containsKey(file)) {
            MSLog.GetLogger().Log((MSLog.Tag)TAG, LogLevel.INFO, "Returning " + String.valueOf(file) + " from cache", t);
            return includeCache.cache.get(file);
        }
        MSLog.GetLogger().Log((MSLog.Tag)TAG, LogLevel.VERBOSE, "Cache does not already contain file. Compiling and caching.", t);
        Profiler profiler = env.getEnv(StaticRuntimeEnv.class).GetProfiler();
        try {
            ParseTree tree;
            if (!Static.InCmdLine(env, true) && !Security.CheckSecurity(file)) {
                if (exceptions != null) {
                    exceptions.add(new ConfigCompileException("The script cannot access " + String.valueOf(file) + " due to restrictions imposed by the base-dir setting.", t));
                    return null;
                }
                throw new CRESecurityException("The script cannot access " + String.valueOf(file) + " due to restrictions imposed by the base-dir setting.", t);
            }
            MSLog.GetLogger().Log((MSLog.Tag)TAG, LogLevel.VERBOSE, "Security check passed", t);
            String s = env.getEnv(GlobalEnv.class).GetScriptProvider().getScript(file);
            ProfilePoint p2 = profiler.start("Compiling " + String.valueOf(file), LogLevel.WARNING);
            try {
                tree = MethodScriptCompiler.compile(MethodScriptCompiler.lex(s, env, file, true), env, envs, staticAnalysis);
            }
            finally {
                p2.stop();
            }
            MSLog.GetLogger().Log((MSLog.Tag)TAG, LogLevel.VERBOSE, "Compilation succeeded, adding to cache.", t);
            includeCache.cache.put(file, tree);
            includeCache.analysisCache.put(file, staticAnalysis);
            return tree;
        }
        catch (ConfigCompileException ex) {
            if (exceptions != null) {
                exceptions.add(ex);
                return null;
            }
            String fileName = ex.getFile() == null ? "Unknown Source" : ex.getFile().getName();
            throw new CREIncludeException("There was a compile error when trying to include the script at " + String.valueOf(file) + "\n" + ex.getMessage() + " :: " + fileName + ":" + ex.getLineNum(), t);
        }
        catch (ConfigCompileGroupException exs) {
            if (exceptions != null) {
                exceptions.addAll(exs.getList());
                return null;
            }
            StringBuilder b = new StringBuilder();
            b.append("There were compile errors when trying to include the script at ").append(file).append("\n");
            for (ConfigCompileException ex : exs.getList()) {
                String fileName = ex.getFile() == null ? "Unknown Source" : ex.getFile().getName();
                b.append(ex.getMessage()).append(" :: ").append(fileName).append(":").append(ex.getLineNum()).append("\n");
            }
            throw new CREIncludeException(b.toString(), t);
        }
        catch (IOException ex) {
            if (exceptions != null) {
                exceptions.add(new ConfigCompileException("The script at " + String.valueOf(file) + " could not be found or read in.", t, ex));
                return null;
            }
            throw new CREIOException("The script at " + String.valueOf(file) + " could not be found or read in.", t, ex);
        }
    }

    public StaticAnalysis getStaticAnalysis(File file) {
        return this.analysisCache.get(file);
    }

    public Map<Target, Scope> getDynamicAnalysisParentScopeCache() {
        return this.dynamicAnalysisParentScopeCache;
    }

    public void addAutoIncludes(List<File> autoIncludes) {
        this.autoIncludes.addAll(autoIncludes);
    }

    @Deprecated
    public void registerAutoIncludes(Environment env, Script s) {
        this.executeAutoIncludes(env, s);
    }

    public void executeAutoIncludes(Environment env, Script s) {
        for (File f : this.autoIncludes) {
            try {
                MethodScriptCompiler.execute(IncludeCache.get(f, env, env.getEnvClasses(), new Target(0, f, 0)), env, null, s);
            }
            catch (ProgramFlowManipulationException e) {
                ConfigRuntimeException.HandleUncaughtException(ConfigRuntimeException.CreateUncatchableException("Cannot break program flow in auto include files.", e.getTarget()), env);
            }
            catch (ConfigRuntimeException e) {
                e.setEnv(env);
                ConfigRuntimeException.HandleUncaughtException(e, env);
            }
        }
    }

    public void clear() {
        this.analysisCache.clear();
        this.autoIncludes.clear();
        this.dynamicAnalysisParentScopeCache.clear();
        this.cache.clear();
    }
}

