/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.org.postgresql.geometric;

import com.laytonsmith.libs.org.postgresql.geometric.PGpoint;
import com.laytonsmith.libs.org.postgresql.util.PGobject;
import com.laytonsmith.libs.org.postgresql.util.PGtokenizer;
import java.io.Serializable;
import java.sql.SQLException;

public class PGpolygon
extends PGobject
implements Serializable,
Cloneable {
    public PGpoint[] points;

    public PGpolygon(PGpoint[] points) {
        this();
        this.points = points;
    }

    public PGpolygon(String s) throws SQLException {
        this();
        this.setValue(s);
    }

    public PGpolygon() {
        this.setType("polygon");
    }

    @Override
    public void setValue(String s) throws SQLException {
        PGtokenizer t = new PGtokenizer(PGtokenizer.removePara(s), ',');
        int npoints = t.getSize();
        this.points = new PGpoint[npoints];
        for (int p2 = 0; p2 < npoints; ++p2) {
            this.points[p2] = new PGpoint(t.getToken(p2));
        }
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PGpolygon) {
            PGpolygon p2 = (PGpolygon)obj;
            if (p2.points.length != this.points.length) {
                return false;
            }
            for (int i = 0; i < this.points.length; ++i) {
                if (this.points[i].equals(p2.points[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int hash2 = 0;
        for (int i = 0; i < this.points.length && i < 5; ++i) {
            hash2 ^= this.points[i].hashCode();
        }
        return hash2;
    }

    @Override
    public Object clone() throws CloneNotSupportedException {
        PGpolygon newPGpolygon = (PGpolygon)super.clone();
        if (newPGpolygon.points != null) {
            newPGpolygon.points = (PGpoint[])newPGpolygon.points.clone();
            for (int i = 0; i < newPGpolygon.points.length; ++i) {
                if (newPGpolygon.points[i] == null) continue;
                newPGpolygon.points[i] = (PGpoint)newPGpolygon.points[i].clone();
            }
        }
        return newPGpolygon;
    }

    @Override
    public String getValue() {
        StringBuffer b = new StringBuffer();
        b.append("(");
        for (int p2 = 0; p2 < this.points.length; ++p2) {
            if (p2 > 0) {
                b.append(",");
            }
            b.append(this.points[p2].toString());
        }
        b.append(")");
        return b.toString();
    }
}

