/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.entities;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCLivingEntity;
import com.laytonsmith.abstraction.entities.MCArmorStand;
import com.laytonsmith.abstraction.enums.MCBodyPart;
import java.util.EnumMap;
import java.util.Map;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.util.EulerAngle;

public class BukkitMCArmorStand
extends BukkitMCLivingEntity
implements MCArmorStand {
    ArmorStand as;

    public BukkitMCArmorStand(Entity le) {
        super(le);
        this.as = (ArmorStand)le;
    }

    @Override
    public Map<MCBodyPart, Vector3D> getAllPoses() {
        EnumMap<MCBodyPart, Vector3D> slots = new EnumMap<MCBodyPart, Vector3D>(MCBodyPart.class);
        block8: for (MCBodyPart key : MCBodyPart.values()) {
            switch (key) {
                case Head: {
                    slots.put(key, this.getHeadPose());
                    continue block8;
                }
                case Torso: {
                    slots.put(key, this.getBodyPose());
                    continue block8;
                }
                case ArmLeft: {
                    slots.put(key, this.getLeftArmPose());
                    continue block8;
                }
                case ArmRight: {
                    slots.put(key, this.getRightArmPose());
                    continue block8;
                }
                case LegLeft: {
                    slots.put(key, this.getLeftLegPose());
                    continue block8;
                }
                case LegRight: {
                    slots.put(key, this.getRightLegPose());
                }
            }
        }
        return slots;
    }

    @Override
    public void setAllPoses(Map<MCBodyPart, Vector3D> posemap) {
        for (Map.Entry<MCBodyPart, Vector3D> part : posemap.entrySet()) {
            Vector3D pose = part.getValue();
            switch (part.getKey()) {
                case Head: {
                    this.setHeadPose(pose);
                    break;
                }
                case Torso: {
                    this.setBodyPose(pose);
                    break;
                }
                case ArmLeft: {
                    this.setLeftArmPose(pose);
                    break;
                }
                case ArmRight: {
                    this.setRightArmPose(pose);
                    break;
                }
                case LegLeft: {
                    this.setLeftLegPose(pose);
                    break;
                }
                case LegRight: {
                    this.setRightLegPose(pose);
                }
            }
        }
    }

    @Override
    public Vector3D getBodyPose() {
        EulerAngle pose = this.as.getBodyPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setBodyPose(Vector3D pose) {
        this.as.setBodyPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getLeftArmPose() {
        EulerAngle pose = this.as.getLeftArmPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setLeftArmPose(Vector3D pose) {
        this.as.setLeftArmPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getRightArmPose() {
        EulerAngle pose = this.as.getRightArmPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setRightArmPose(Vector3D pose) {
        this.as.setRightArmPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getLeftLegPose() {
        EulerAngle pose = this.as.getLeftLegPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setLeftLegPose(Vector3D pose) {
        this.as.setLeftLegPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getRightLegPose() {
        EulerAngle pose = this.as.getRightLegPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setRightLegPose(Vector3D pose) {
        this.as.setRightLegPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public Vector3D getHeadPose() {
        EulerAngle pose = this.as.getHeadPose();
        return new Vector3D(pose.getX(), pose.getY(), pose.getZ());
    }

    @Override
    public void setHeadPose(Vector3D pose) {
        this.as.setHeadPose(new EulerAngle(pose.X(), pose.Y(), pose.Z()));
    }

    @Override
    public boolean hasBasePlate() {
        return this.as.hasBasePlate();
    }

    @Override
    public void setHasBasePlate(boolean basePlate) {
        this.as.setBasePlate(basePlate);
    }

    @Override
    public boolean hasGravity() {
        return this.as.hasGravity();
    }

    @Override
    public void setHasGravity(boolean gravity) {
        this.as.setGravity(gravity);
    }

    @Override
    public boolean isVisible() {
        return this.as.isVisible();
    }

    @Override
    public void setVisible(boolean visible) {
        this.as.setVisible(visible);
    }

    @Override
    public boolean hasArms() {
        return this.as.hasArms();
    }

    @Override
    public void setHasArms(boolean arms) {
        this.as.setArms(arms);
    }

    @Override
    public boolean isSmall() {
        return this.as.isSmall();
    }

    @Override
    public void setSmall(boolean small) {
        this.as.setSmall(small);
    }

    @Override
    public Boolean isMarker() {
        return this.as.isMarker();
    }

    @Override
    public void setMarker(boolean marker) {
        this.as.setMarker(marker);
    }
}

