/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.libs.redis.clients.jedis;

import com.laytonsmith.libs.org.slf4j.Logger;
import com.laytonsmith.libs.org.slf4j.LoggerFactory;
import com.laytonsmith.libs.redis.clients.jedis.Connection;
import com.laytonsmith.libs.redis.clients.jedis.DefaultJedisClientConfig;
import com.laytonsmith.libs.redis.clients.jedis.DefaultJedisSocketFactory;
import com.laytonsmith.libs.redis.clients.jedis.HostAndPort;
import com.laytonsmith.libs.redis.clients.jedis.JedisClientConfig;
import com.laytonsmith.libs.redis.clients.jedis.JedisSocketFactory;
import com.laytonsmith.libs.redis.clients.jedis.csc.ClientSideCache;
import com.laytonsmith.libs.redis.clients.jedis.exceptions.JedisException;
import org.apache.commons.pool2.PooledObject;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.DefaultPooledObject;

public class ConnectionFactory
implements PooledObjectFactory<Connection> {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionFactory.class);
    private final JedisSocketFactory jedisSocketFactory;
    private final JedisClientConfig clientConfig;
    private ClientSideCache clientSideCache = null;

    public ConnectionFactory(HostAndPort hostAndPort) {
        this.clientConfig = DefaultJedisClientConfig.builder().build();
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort);
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort, this.clientConfig);
    }

    public ConnectionFactory(HostAndPort hostAndPort, JedisClientConfig clientConfig, ClientSideCache csCache) {
        this.clientConfig = clientConfig;
        this.jedisSocketFactory = new DefaultJedisSocketFactory(hostAndPort, this.clientConfig);
        this.clientSideCache = csCache;
    }

    public ConnectionFactory(JedisSocketFactory jedisSocketFactory, JedisClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.jedisSocketFactory = jedisSocketFactory;
    }

    public void activateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    public void destroyObject(PooledObject<Connection> pooledConnection) throws Exception {
        Connection jedis = (Connection)pooledConnection.getObject();
        if (jedis.isConnected()) {
            try {
                jedis.close();
            }
            catch (RuntimeException e) {
                logger.debug("Error while close", e);
            }
        }
    }

    public PooledObject<Connection> makeObject() throws Exception {
        try {
            Connection jedis = new Connection(this.jedisSocketFactory, this.clientConfig, this.clientSideCache);
            return new DefaultPooledObject((Object)jedis);
        }
        catch (JedisException je) {
            logger.debug("Error while makeObject", je);
            throw je;
        }
    }

    public void passivateObject(PooledObject<Connection> pooledConnection) throws Exception {
    }

    public boolean validateObject(PooledObject<Connection> pooledConnection) {
        Connection jedis = (Connection)pooledConnection.getObject();
        try {
            return jedis.isConnected() && jedis.ping();
        }
        catch (Exception e) {
            logger.warn("Error while validating pooled Connection object.", e);
            return false;
        }
    }
}

