/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen.localization;

import java.awt.Frame;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import javax.swing.LayoutStyle;

public class AzureKeyInputDialog
extends JDialog {
    KeyListener validationListener = new KeyListener(){

        @Override
        public void keyTyped(KeyEvent e) {
            AzureKeyInputDialog.this.validateInput();
        }

        @Override
        public void keyPressed(KeyEvent e) {
            AzureKeyInputDialog.this.validateInput();
        }

        @Override
        public void keyReleased(KeyEvent e) {
            AzureKeyInputDialog.this.validateInput();
        }
    };
    private JButton cancelButton;
    private JLabel jLabel1;
    private JPasswordField keyField;
    private JButton okButton;
    private JCheckBox storeKeyCheckbox;

    public AzureKeyInputDialog(Frame parent, AzureKeyInputDialogCallback callback) {
        super(parent, true);
        this.initComponents();
        this.keyField.setText("");
        this.okButton.setEnabled(false);
        this.storeKeyCheckbox.setSelected(false);
        this.cancelButton.addActionListener(ae -> {
            this.setVisible(false);
            this.dispose();
        });
        this.okButton.addActionListener(ae -> {
            callback.getResults(new String(this.keyField.getPassword()), this.storeKeyCheckbox.isSelected());
            this.setVisible(false);
            this.dispose();
        });
        this.keyField.addKeyListener(this.validationListener);
    }

    private void validateInput() {
        if (this.keyField.getPassword().length == 0) {
            this.okButton.setEnabled(false);
        } else {
            this.okButton.setEnabled(true);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.storeKeyCheckbox = new JCheckBox();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.keyField = new JPasswordField();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setText("Input Azure Cognitive Services Key");
        this.storeKeyCheckbox.setText("Store Key (key is stored locally in plain text!)");
        this.okButton.setText("Ok");
        this.cancelButton.setText("Cancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.storeKeyCheckbox).addComponent(this.jLabel1).addGroup(layout.createSequentialGroup().addComponent(this.okButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton))).addGap(0, 250, Short.MAX_VALUE)).addComponent(this.keyField)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.keyField, -2, -1, -2).addGap(8, 8, 8).addComponent(this.storeKeyCheckbox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.okButton).addComponent(this.cancelButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    public static interface AzureKeyInputDialogCallback {
        public void getResults(String var1, boolean var2);
    }
}

