/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class InstanceofUtil {
    private static final Map<CClassType, Set<CClassType>> ISINSTANCEOF_CACHE = new HashMap<CClassType, Set<CClassType>>();

    public static Set<CClassType> getAllCastableClasses(CClassType c, Environment env) {
        HashSet<CClassType> ret = new HashSet<CClassType>();
        InstanceofUtil.getAllCastableClassesWithBlacklist(c, ret, env);
        return ret;
    }

    private static Set<CClassType> getAllCastableClassesWithBlacklist(CClassType c, Set<CClassType> blacklist, Environment env) {
        block5: {
            if (blacklist.contains(c)) {
                return blacklist;
            }
            blacklist.add(c);
            try {
                for (CClassType s : c.getTypeSuperclasses(env)) {
                    blacklist.addAll(InstanceofUtil.getAllCastableClassesWithBlacklist(s, blacklist, env));
                }
                for (CClassType iface : c.getTypeInterfaces(env)) {
                    blacklist.addAll(InstanceofUtil.getAllCastableClassesWithBlacklist(iface, blacklist, env));
                }
            }
            catch (UnsupportedOperationException ex) {
                if (ClassDiscovery.GetClassAnnotation(c.getClass(), typeof.class) == null) break block5;
                throw new RuntimeException("Unexpected UnsupportedOperationException from " + c.getName());
            }
        }
        return blacklist;
    }

    public static boolean isInstanceof(Mixed value, FullyQualifiedClassName instanceofThis, Environment env) {
        Static.AssertNonNull(instanceofThis, "instanceofThis may not be null");
        if (instanceofThis.getFQCN().equals("auto")) {
            return true;
        }
        if (value instanceof CFunction) {
            return false;
        }
        return InstanceofUtil.isInstanceof(value.typeof(), instanceofThis, env);
    }

    public static boolean isInstanceof(CClassType type, FullyQualifiedClassName instanceofThis, Environment env) {
        Static.AssertNonNull(instanceofThis, "instanceofThis may not be null");
        if (instanceofThis.getFQCN().equals("auto")) {
            return true;
        }
        for (CClassType c : InstanceofUtil.getAllCastableClasses(type, env)) {
            FullyQualifiedClassName typeof2 = c.getFQCN();
            if (typeof2 == null || !typeof2.equals(instanceofThis)) continue;
            return true;
        }
        return false;
    }

    public static boolean isInstanceof(Mixed value, Class<? extends Mixed> instanceofThis, Environment env) {
        FullyQualifiedClassName typeof2 = InstanceofUtil.typeof(instanceofThis);
        return typeof2 == null ? false : InstanceofUtil.isInstanceof(value, typeof2, env);
    }

    public static boolean isInstanceof(Mixed value, CClassType instanceofThis, Environment env) {
        return InstanceofUtil.isInstanceof(value, instanceofThis.getFQCN(), env);
    }

    public static boolean isInstanceof(CClassType type, CClassType instanceofThis, Environment env) {
        if (type == instanceofThis || instanceofThis == null || type == CClassType.AUTO || type == CNull.TYPE || instanceofThis == CClassType.AUTO) {
            return true;
        }
        if (type == null || type == CVoid.TYPE || instanceofThis == CVoid.TYPE || instanceofThis == CNull.TYPE) {
            return false;
        }
        Set<CClassType> castableClasses = ISINSTANCEOF_CACHE.get(type);
        if (castableClasses == null) {
            castableClasses = InstanceofUtil.getAllCastableClasses(type, env);
            ISINSTANCEOF_CACHE.put(type, castableClasses);
        }
        return castableClasses.contains(instanceofThis);
    }

    private static FullyQualifiedClassName typeof(Class<? extends Mixed> c) {
        typeof type = ClassDiscovery.GetClassAnnotation(c, typeof.class);
        if (type == null) {
            return null;
        }
        return FullyQualifiedClassName.forNativeClass(c);
    }
}

