/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.abstraction.enums.MCPatternShape;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.Keyed;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.banner.PatternType;

public class BukkitMCPatternShape
extends MCPatternShape<PatternType> {
    private static final Map<PatternType, MCPatternShape> BUKKIT_MAP = new HashMap<PatternType, MCPatternShape>();

    public BukkitMCPatternShape(MCPatternShape.MCVanillaPatternShape vanillaPatternShape, PatternType pattern) {
        super(vanillaPatternShape, pattern);
    }

    @Override
    public String name() {
        if (this.getAbstracted() == MCPatternShape.MCVanillaPatternShape.UNKNOWN) {
            try {
                NamespacedKey key = (NamespacedKey)ReflectionUtils.invokeMethod(Keyed.class, this.getConcrete(), "getKey");
                return key.getKey().toUpperCase(Locale.ROOT);
            }
            catch (ReflectionUtils.ReflectionException ex) {
                MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Could not resolve unknown PatternType", Target.UNKNOWN);
            }
        }
        return ((MCPatternShape.MCVanillaPatternShape)((Object)this.getAbstracted())).name();
    }

    public static MCPatternShape valueOfConcrete(PatternType test) {
        MCPatternShape type = BUKKIT_MAP.get(test);
        if (type == null) {
            MSLog.GetLogger().w(MSLog.Tags.GENERAL, "PatternType missing in BUKKIT_MAP: " + String.valueOf(test), Target.UNKNOWN);
            return new BukkitMCPatternShape(MCPatternShape.MCVanillaPatternShape.UNKNOWN, test);
        }
        return type;
    }

    public static void build() {
        for (MCPatternShape.MCVanillaPatternShape v : MCPatternShape.MCVanillaPatternShape.values()) {
            PatternType type;
            if (!v.existsIn(Static.getServer().getMinecraftVersion())) continue;
            try {
                type = BukkitMCPatternShape.getBukkitType(v);
            }
            catch (IllegalArgumentException ex) {
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find Bukkit PatternType for " + v.name(), Target.UNKNOWN);
                continue;
            }
            BukkitMCPatternShape wrapper = new BukkitMCPatternShape(v, type);
            BUKKIT_MAP.put(type, wrapper);
            MAP.put(v.name(), wrapper);
        }
        try {
            for (PatternType type : Registry.BANNER_PATTERN) {
                if (BUKKIT_MAP.containsKey(type)) continue;
                String name = type.getKey().getKey().toUpperCase(Locale.ROOT);
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find MCPatternShape for " + name, Target.UNKNOWN);
                BukkitMCPatternShape wrapper = new BukkitMCPatternShape(MCPatternShape.MCVanillaPatternShape.UNKNOWN, type);
                MAP.put(name, wrapper);
                BUKKIT_MAP.put(type, wrapper);
            }
        }
        catch (IncompatibleClassChangeError incompatibleClassChangeError) {
            // empty catch block
        }
    }

    private static PatternType getBukkitType(MCPatternShape.MCVanillaPatternShape v) throws IllegalArgumentException {
        try {
            String typeName;
            typeName = switch (typeName = v.name()) {
                case "DIAGONAL_RIGHT_MIRROR" -> "diagonal_right";
                case "DIAGONAL_RIGHT" -> "diagonal_up_right";
                case "STRIPE_SMALL" -> "small_stripes";
                case "DIAGONAL_LEFT_MIRROR" -> "diagonal_up_left";
                case "CIRCLE_MIDDLE" -> "circle";
                case "RHOMBUS_MIDDLE" -> "rhombus";
                case "HALF_VERTICAL_MIRROR" -> "half_vertical_right";
                case "HALF_HORIZONTAL_MIRROR" -> "half_horizontal_bottom";
                default -> typeName.toLowerCase(Locale.ROOT);
            };
            PatternType t = (PatternType)Registry.BANNER_PATTERN.get(NamespacedKey.minecraft((String)typeName));
            if (t == null) {
                throw new IllegalArgumentException();
            }
            return t;
        }
        catch (NoSuchFieldError ex) {
            try {
                Class<?> cls = Class.forName("org.bukkit.block.banner.PatternType");
                return (PatternType)ReflectionUtils.invokeMethod(cls, null, "valueOf", new Class[]{String.class}, new Object[]{v.name()});
            }
            catch (ClassNotFoundException exc) {
                throw new IllegalArgumentException();
            }
        }
    }
}

