/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.tools.docgen;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.Common.ReflectionUtils;
import com.laytonsmith.PureUtilities.Common.StreamUtils;
import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.annotations.api;
import com.laytonsmith.core.events.BindableEvent;
import com.laytonsmith.core.events.Event;
import com.laytonsmith.core.events.prefilters.Prefilter;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.libs.org.json.simple.JSONValue;
import com.laytonsmith.tools.docgen.DocGen;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DocGenExportTool {
    private final ClassDiscovery classDiscovery;
    private final OutputStream out;

    public DocGenExportTool(ClassDiscovery classDiscovery, OutputStream out) {
        this.classDiscovery = classDiscovery;
        this.out = out;
    }

    public void export() {
        Set<Class<Function>> functions = this.classDiscovery.loadClassesWithAnnotationThatExtend(api.class, Function.class, this.getClass().getClassLoader(), false);
        Set<Class<Event>> events = this.classDiscovery.loadClassesWithAnnotationThatExtend(api.class, Event.class, this.getClass().getClassLoader(), false);
        HashMap topLevel = new HashMap();
        ArrayList<Object> functionList = new ArrayList<Object>();
        topLevel.put("functions", functionList);
        ArrayList eventList = new ArrayList();
        topLevel.put("events", eventList);
        for (Class<Function> functionC : functions) {
            Function function;
            HashMap function2 = new HashMap();
            try {
                function = ReflectionUtils.newInstance(functionC);
            }
            catch (NoClassDefFoundError ex) {
                StreamUtils.GetSystemErr().println("While attempting to load: " + functionC.getName() + ": " + ex.getMessage());
                continue;
            }
            DocGen.DocInfo di = new DocGen.DocInfo(function.docs());
            function2.put("name", function.getName());
            function2.put("ret", di.ret);
            function2.put("args", di.originalArgs);
            function2.put("desc", di.desc);
            functionList.add(function2);
        }
        Pattern eventPattern = Pattern.compile("\\{(.*?)\\} *?(.*?) *?\\{(.*?)\\} *?\\{(.*?)\\}");
        DocGen.MarkupType type = DocGen.MarkupType.TEXT;
        for (Class clazz : events) {
            HashMap<String, String> event = new HashMap<String, String>();
            Event e = (Event)ReflectionUtils.newInstance(clazz);
            Map<String, Prefilter<? extends BindableEvent>> prefilters = e.getPrefilters();
            Matcher m = eventPattern.matcher(e.docs());
            if (!m.find()) continue;
            String name = e.getName();
            String description = m.group(2).trim();
            String prefilter = prefilters == null ? DocGen.PrefilterData.Get(m.group(1).split("\\|"), type) : DocGen.PrefilterData.GetFromModernPrefilters(prefilters, type);
            String eventData = DocGen.EventData.Get(m.group(3).split("\\|"), type);
            String mutability = DocGen.MutabilityData.Get(m.group(4).split("\\|"), type);
            event.put("name", name);
            event.put("desc", description);
            event.put("prefilter", prefilter);
            event.put("eventData", eventData);
            event.put("mutability", mutability);
            eventList.add(event);
        }
        String output = JSONValue.toJSONString(topLevel) + StringUtils.nl();
        try {
            this.out.write(output.getBytes("UTF-8"));
            this.out.flush();
        }
        catch (IOException iOException) {
            Logger.getLogger(DocGenExportTool.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }
}

