/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.client;

import com.laytonsmith.libs.com.squareup.okhttp.MediaType;
import com.laytonsmith.libs.com.squareup.okhttp.ResponseBody;
import com.laytonsmith.libs.okio.Buffer;
import com.laytonsmith.libs.okio.BufferedSource;
import com.laytonsmith.libs.okio.ForwardingSource;
import com.laytonsmith.libs.okio.Okio;
import com.laytonsmith.libs.okio.Source;
import java.io.IOException;

public class ProgressResponseBody
extends ResponseBody {
    private final ResponseBody responseBody;
    private final ProgressListener progressListener;
    private BufferedSource bufferedSource;

    public ProgressResponseBody(ResponseBody responseBody, ProgressListener progressListener) {
        this.responseBody = responseBody;
        this.progressListener = progressListener;
    }

    @Override
    public MediaType contentType() {
        return this.responseBody.contentType();
    }

    @Override
    public long contentLength() throws IOException {
        return this.responseBody.contentLength();
    }

    @Override
    public BufferedSource source() throws IOException {
        if (this.bufferedSource == null) {
            this.bufferedSource = Okio.buffer(this.source(this.responseBody.source()));
        }
        return this.bufferedSource;
    }

    private Source source(Source source2) {
        return new ForwardingSource(source2){
            long totalBytesRead;
            {
                this.totalBytesRead = 0L;
            }

            @Override
            public long read(Buffer sink2, long byteCount) throws IOException {
                long bytesRead = super.read(sink2, byteCount);
                this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                ProgressResponseBody.this.progressListener.update(this.totalBytesRead, ProgressResponseBody.this.responseBody.contentLength(), bytesRead == -1L);
                return bytesRead;
            }
        };
    }

    public static interface ProgressListener {
        public void update(long var1, long var3, boolean var5);
    }
}

