/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics;

import com.laytonsmith.PureUtilities.ObjectHelpers;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.Constraints;
import com.laytonsmith.core.constructs.generics.constraints.Constraint;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@ObjectHelpers.StandardField
public class GenericDeclaration {
    private final List<Constraints> constraints;

    public GenericDeclaration(Target t, Constraints ... constraints) {
        this.constraints = Arrays.asList(constraints);
    }

    public List<Constraints> getConstraints() {
        return new ArrayList<Constraints>(this.constraints);
    }

    public Constraints getParameter(int location) {
        return this.constraints.get(location);
    }

    public int getParameterCount() {
        return this.constraints.size();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean joinComma = false;
        for (Constraints c : this.constraints) {
            if (joinComma) {
                b.append(", ");
            }
            joinComma = true;
            boolean join = false;
            for (Constraint cc : c) {
                if (join) {
                    b.append(" & ");
                }
                join = true;
                b.append(cc.toString());
            }
        }
        return b.toString();
    }

    public boolean equals(Object that) {
        return ObjectHelpers.DoEquals(this, that);
    }

    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }
}

