/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.ArgumentValidation;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.CArray;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CInt;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CRECastException;
import com.laytonsmith.core.exceptions.CRE.CRERangeException;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.ArrayHandling;
import com.laytonsmith.core.natives.interfaces.Mixed;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;

@typeof(value="ms.lang.slice")
public class CSlice
extends CArray {
    public static final CClassType TYPE = CClassType.get(CSlice.class);
    private long start;
    private long finish;
    private int direction;
    private long max;
    private long size;

    public CSlice(String slice, Target t) throws ConfigCompileException {
        super(t);
        String sfinish;
        String sstart;
        String[] split2 = slice.split("\\.\\.");
        if (split2.length > 2) {
            throw new ConfigCompileException("Invalid slice notation! (" + slice + ")", t);
        }
        if (split2.length == 1) {
            sstart = slice.trim().substring(0, slice.trim().length() - 2);
            sfinish = "-1";
        } else if (slice.trim().startsWith("..")) {
            sstart = "0";
            sfinish = slice.trim().substring(2);
        } else {
            sstart = split2[0];
            sfinish = split2[1];
        }
        try {
            this.start = Long.parseLong(sstart.trim());
            this.finish = Long.parseLong(sfinish.trim());
        }
        catch (NumberFormatException e) {
            throw new CRECastException("Expecting integer in a slice, but was given \"" + sstart + "\" and \"" + sfinish + "\"", t);
        }
        this.calculateCaches();
    }

    public CSlice(long from, long to, Target t) {
        super(t);
        this.start = from;
        this.finish = to;
        this.calculateCaches();
    }

    @Override
    public List<Mixed> asList() {
        CArray ca = new ArrayHandling.range().exec(Target.UNKNOWN, null, null, new CInt(this.start, Target.UNKNOWN), new CInt(this.finish, Target.UNKNOWN));
        return ca.asList();
    }

    private void calculateCaches() {
        this.direction = this.start < this.finish ? 1 : (this.start == this.finish ? 0 : -1);
        this.max = Math.abs(this.finish - this.start);
        this.size = this.max + 1L;
    }

    public long getStart() {
        return this.start;
    }

    public long getFinish() {
        return this.finish;
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    @Override
    public String val() {
        return this.start + ".." + this.finish;
    }

    @Override
    public String toString() {
        return this.val();
    }

    @Override
    protected String getString(Stack<CArray> arrays, Target t) {
        return this.val();
    }

    @Override
    public boolean inAssociativeMode() {
        return false;
    }

    @Override
    public void set(Mixed index, Mixed c, Target t) {
        throw new CRECastException("CSlices cannot set values", t);
    }

    @Override
    public Mixed get(Mixed index, Target t) {
        long i = ArgumentValidation.getInt(index, t);
        if (i > this.max) {
            throw new CRERangeException("Index out of bounds. Index: " + i + " Size: " + this.max, t);
        }
        return new CInt(this.start + (long)this.direction * i, t);
    }

    @Override
    public Set<Mixed> keySet() {
        return new AbstractSet<Mixed>(){

            @Override
            public Iterator<Mixed> iterator() {
                return new Iterator<Mixed>(){
                    int index = 0;

                    @Override
                    public boolean hasNext() {
                        return (long)this.index < CSlice.this.size;
                    }

                    @Override
                    public Mixed next() {
                        return new CInt(this.index++, Target.UNKNOWN);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Not supported yet.");
                    }
                };
            }

            @Override
            public int size() {
                return (int)CSlice.this.size();
            }
        };
    }

    @Override
    public long size() {
        return this.size;
    }

    @Override
    public boolean contains(Mixed c) {
        try {
            long i = ArgumentValidation.getInt(c, Target.UNKNOWN);
            if (this.start < this.finish) {
                return this.start <= i && i <= this.finish;
            }
            return this.start >= i && i <= this.finish;
        }
        catch (ConfigRuntimeException e) {
            return false;
        }
    }

    @Override
    public boolean containsKey(String c) {
        try {
            long i = Long.parseLong(c);
            return i >= 0L && i < this.size;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Override
    public String docs() {
        return "A slice is a value that represents a numeric range, either in the positive direction, or negative.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_1;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{CArray.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }
}

