/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics;

import com.laytonsmith.PureUtilities.Either;
import com.laytonsmith.PureUtilities.ObjectHelpers;
import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConcreteGenericParameter;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.ConstraintValidator;
import com.laytonsmith.core.constructs.generics.Constraints;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUse;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUseParameter;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GenericTypeParameters {
    @ObjectHelpers.StandardField
    private final List<Either<LeftHandSideType, Pair<String, Constraints>>> parameters;
    @ObjectHelpers.StandardField
    private final CClassType forType;
    private final Target target;
    private final Environment env;

    public static GenericTypeParameters fromTypes(CClassType forType, Target t, Environment env, ConcreteGenericParameter ... constraints) {
        return new GenericTypeParameters(forType, t, env, (Either[])Arrays.asList(constraints).stream().map(item -> Either.left(item)).toList().toArray(Either[]::new));
    }

    public static GenericTypeParameters fromTypenames(CClassType forType, Target t, Environment env, Pair<String, Constraints> ... typenames) {
        return new GenericTypeParameters(forType, t, env, (Either[])Arrays.asList(typenames).stream().map(item -> Either.right(item)).toList().toArray(Either[]::new));
    }

    public GenericTypeParameters(CClassType forType, Target t, Environment env, Either<LeftHandSideType, Pair<String, Constraints>> ... parameters) {
        ArrayList<Constraints> validation = new ArrayList<Constraints>();
        for (Either<LeftHandSideType, Pair<String, Constraints>> param : parameters) {
            if (param.hasLeft()) {
                LeftHandSideType type = param.getLeft().get();
                Constraints c = new Constraints(t, ConstraintLocation.LHS, new ExactTypeConstraint(t, type));
                validation.add(c);
                continue;
            }
            validation.add(param.getRight().get().getValue());
        }
        ConstraintValidator.ValidateLHS(t, forType, validation, env);
        this.parameters = Arrays.asList(parameters);
        this.forType = forType;
        this.target = t;
        this.env = env;
    }

    public List<Either<LeftHandSideType, Pair<String, Constraints>>> getParameters() {
        return new ArrayList<Either<LeftHandSideType, Pair<String, Constraints>>>(this.parameters);
    }

    public Constraints getParameter(int location) {
        Constraints c;
        Either<LeftHandSideType, Pair<String, Constraints>> param = this.parameters.get(location);
        if (param.hasLeft()) {
            LeftHandSideType type = param.getLeft().get();
            c = new Constraints(Target.UNKNOWN, ConstraintLocation.LHS, new ExactTypeConstraint(Target.UNKNOWN, type));
        } else {
            c = param.getRight().get().getValue();
        }
        return c;
    }

    public List<LeftHandSideType> toLeftHandSideTypes() {
        ArrayList<LeftHandSideType> ret = new ArrayList<LeftHandSideType>();
        for (Either<LeftHandSideType, Pair<String, Constraints>> param : this.parameters) {
            if (param.hasRight()) {
                throw new RuntimeException("Cannot create LeftHandSideType from type parameters, contains typenames.");
            }
            ret.add(param.getLeft().get());
        }
        return ret;
    }

    public LeftHandGenericUse toLeftHandGenericUse() {
        ArrayList<LeftHandGenericUseParameter> params = new ArrayList<LeftHandGenericUseParameter>();
        int count = 0;
        for (Either<LeftHandSideType, Pair<String, Constraints>> param : this.parameters) {
            if (param.hasRight()) {
                throw new RuntimeException("Cannot create LeftHandSideType from type parameters, contains typenames.");
            }
            params.add(param.getLeft().get().toLeftHandGenericUse(this.forType, this.target, this.env, ConstraintLocation.RHS, count++));
        }
        return new LeftHandGenericUse(this.forType, this.target, this.env, params);
    }

    public boolean hasTypenames() {
        for (Either<LeftHandSideType, Pair<String, Constraints>> param : this.parameters) {
            if (!param.hasRight()) continue;
            return true;
        }
        return false;
    }

    public boolean isInstanceof(LeftHandGenericUse lhgu, Environment env) {
        if (lhgu.getConstraints().size() != this.parameters.size()) {
            return false;
        }
        for (int i = 0; i < this.parameters.size(); ++i) {
            Constraints superClass = lhgu.getConstraints().get(i);
            Either<LeftHandSideType, Pair<String, Constraints>> sub = this.parameters.get(i);
            if (sub.hasLeft()) {
                if (superClass.withinBounds(sub.getLeft().get(), env)) continue;
                return false;
            }
            ArrayList<String> errors = new ArrayList<String>();
            if (superClass.withinBounds(sub.getRight().get().getValue(), errors, env)) continue;
            return false;
        }
        return true;
    }

    public int getParameterCount() {
        return this.parameters.size();
    }

    public CClassType getForType() {
        return this.forType;
    }

    public String toSimpleString() {
        StringBuilder b = new StringBuilder();
        boolean joinComma = false;
        for (Either<LeftHandSideType, Pair<String, Constraints>> c : this.parameters) {
            if (joinComma) {
                b.append(", ");
            }
            joinComma = true;
            if (c.hasLeft()) {
                LeftHandSideType type = c.getLeft().get();
                b.append(type.getSimpleName());
                continue;
            }
            b.append(c.getRight().get().getKey());
        }
        return b.toString();
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        boolean joinComma = false;
        for (Either<LeftHandSideType, Pair<String, Constraints>> c : this.parameters) {
            if (joinComma) {
                b.append(", ");
            }
            joinComma = true;
            if (c.hasLeft()) {
                LeftHandSideType type = c.getLeft().get();
                b.append(type.toString());
                continue;
            }
            b.append(c.getRight().get().getKey());
        }
        return b.toString();
    }

    public boolean equals(Object that) {
        return ObjectHelpers.DoEquals(this, that);
    }

    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }

    public static GenericTypeParametersBuilder addParameter(CClassType forType, Target t, Environment env, Either<LeftHandSideType, Pair<String, Constraints>> type) {
        return new GenericTypeParametersBuilder(forType, t, env).addParameter(type);
    }

    public static GenericTypeParametersBuilder addParameter(CClassType forType, Target t, Environment env, String typename, Constraints constraints) {
        return new GenericTypeParametersBuilder(forType, t, env).addParameter(typename, constraints);
    }

    public static GenericTypeParametersBuilder addParameter(CClassType forType, Target t, Environment env, ConcreteGenericParameter parameter) {
        return new GenericTypeParametersBuilder(forType, t, env).addParameter(parameter);
    }

    public static GenericTypeParametersBuilder addParameter(CClassType forType, Target t, Environment env, CClassType type, LeftHandGenericUse lhgu) {
        return new GenericTypeParametersBuilder(forType, t, env).addParameter(type, lhgu);
    }

    public static GenericTypeParametersBuilder emptyBuilder(CClassType forType, Target t, Environment env) {
        return new GenericTypeParametersBuilder(forType, t, env);
    }

    public static GenericTypeParametersBuilder nativeBuilder(CClassType forType) {
        return new GenericTypeParametersBuilder(forType, Target.UNKNOWN, null);
    }

    public static final class GenericTypeParametersBuilder {
        List<Either<LeftHandSideType, Pair<String, Constraints>>> p = new ArrayList<Either<LeftHandSideType, Pair<String, Constraints>>>();
        CClassType forType;
        Target target;
        Environment env;

        public GenericTypeParametersBuilder(CClassType forType, Target t, Environment env) {
            this.forType = forType;
            this.target = t;
            this.env = env;
        }

        public GenericTypeParametersBuilder addParameter(Either<LeftHandSideType, Pair<String, Constraints>> type) {
            this.p.add(type);
            return this;
        }

        public GenericTypeParametersBuilder addParameter(String typename, Constraints constraints) {
            return this.addParameter(Either.right(new Pair<String, Constraints>(typename, constraints)));
        }

        public GenericTypeParametersBuilder addParameter(ConcreteGenericParameter type) {
            return this.addParameter(type.asLeftHandSideType());
        }

        public GenericTypeParametersBuilder addParameter(LeftHandSideType type) {
            return this.addParameter(Either.left(type));
        }

        public GenericTypeParametersBuilder addParameter(CClassType type, LeftHandGenericUse lhgu) {
            return this.addParameter(new ConcreteGenericParameter(type, lhgu, this.target, this.env));
        }

        public boolean isEmpty() {
            return this.p.isEmpty();
        }

        public GenericTypeParameters build() {
            if (this.p.isEmpty()) {
                throw new Error("Empty parameter builders cannot be used. Check for this condition with isEmpty()");
            }
            return new GenericTypeParameters(this.forType, this.target, this.env, (Either[])this.p.toArray(Either[]::new));
        }

        public GenericTypeParameters buildWithSubclassDefinition(CClassType t) {
            ArrayList<Either<LeftHandSideType, Object>> parameters = new ArrayList<Either<LeftHandSideType, Object>>();
            for (Either<LeftHandSideType, Pair<String, Constraints>> val : this.p) {
                if (val.hasLeft()) {
                    if (CClassType.RECURSIVE_DEFINITION.getFQCN().getFQCN().equals(val.getLeft().get().val())) {
                        parameters.add(Either.left(t.asLeftHandSideType()));
                        continue;
                    }
                    parameters.add(val);
                    continue;
                }
                Pair<String, Constraints> pair = val.getRight().get();
                if (pair.getValue() == null) {
                    Constraints c = null;
                    for (Constraints r : t.getGenericDeclaration().getConstraints()) {
                        if (!pair.getKey().equals(r.getTypeName())) continue;
                        c = r;
                        break;
                    }
                    pair = new Pair<String, Object>(pair.getKey(), c);
                }
                parameters.add(Either.right(pair));
            }
            return new GenericTypeParameters(this.forType, this.target, this.env, (Either[])parameters.toArray(Either[]::new));
        }
    }
}

