/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.Constraints;
import com.laytonsmith.core.constructs.generics.GenericDeclaration;
import com.laytonsmith.core.constructs.generics.GenericParameters;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUse;
import com.laytonsmith.core.constructs.generics.constraints.Constraint;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREGenericConstraintException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;

public final class ConstraintValidator {
    private ConstraintValidator() {
    }

    public static List<String> ValidateDefinition(List<Constraints> parameters, Target t) throws CREGenericConstraintException {
        ArrayList<String> typenames = new ArrayList<String>();
        for (int i = 0; i < parameters.size(); ++i) {
            Constraints c = parameters.get(i);
            if (c.isVariadic() && i != parameters.size() - 1) {
                throw new CREGenericConstraintException("Variadic generic types can only be the last parameter.", t);
            }
            typenames.add(ConstraintValidator.ValidateDefinition(new TreeSet<Constraint>(c.getInDefinitionOrder()), t));
        }
        return typenames;
    }

    public static String ValidateDefinition(SortedSet<Constraint> constraints, Target t) throws CREGenericConstraintException {
        String typename = null;
        for (Constraint c : constraints) {
            if (typename == null) {
                typename = c.getTypeName();
            } else if (!typename.equals(c.getTypeName())) {
                throw new CREGenericConstraintException("Multiple constraints in the same parameter must be named with the same type name.", t);
            }
            if (!c.validLocations().contains((Object)ConstraintLocation.DEFINITION)) {
                throw new CREGenericConstraintException("The " + c.getConstraintName() + " constraint type cannot be used at the location of the " + ConstraintLocation.DEFINITION.getLocationName(), c.getTarget());
            }
            if (c.isWildcard()) {
                throw new CREGenericConstraintException("Constraints cannot use wildcards at the definition site.", c.getTarget());
            }
            for (Constraint cc : constraints) {
                if (c == cc || !c.equals(cc)) continue;
                throw new CREGenericConstraintException("Duplicate constraint found. One constraint defined at " + String.valueOf(c.getTarget()) + ", the other constraint at " + String.valueOf(cc.getTarget()), t);
            }
        }
        if (constraints.size() == 1) {
            return typename;
        }
        throw new CREGenericConstraintException("Multiple constraints are not yet supported.", t);
    }

    public static void ValidateLHS(Target t, CClassType type, LeftHandGenericUse genericParameters, Environment env) {
        ConstraintValidator.ValidateLHS(t, type, genericParameters == null ? null : genericParameters.getConstraints(), env);
    }

    public static void ValidateLHS(Target t, CClassType type, List<Constraints> c, Environment env) throws CREGenericConstraintException {
        GenericDeclaration dec2 = type.getGenericDeclaration();
        if (dec2 == null) {
            if (c != null && !c.isEmpty()) {
                throw new CREGenericConstraintException(type.getFQCN().getFQCN() + " does not define generic parameters, but they were provided anyways", t);
            }
            return;
        }
        List<Constraints> declarationConstraints = dec2.getConstraints();
        if (c == null) {
            for (Constraints cc : declarationConstraints) {
                cc.convertFromDiamond(t);
            }
        } else {
            ConstraintValidator.ValidateLHStoLHS(t, c, declarationConstraints, env);
        }
    }

    public static void ValidateRHStoLHS(Constraints declarationConstraints, Target t, LeftHandSideType type, Environment env) {
        ArrayList<Constraints> exactType = new ArrayList<Constraints>();
        exactType.add(new Constraints(t, ConstraintLocation.RHS, new ExactTypeConstraint(t, type)));
        ConstraintValidator.ValidateLHStoLHS(t, exactType, Arrays.asList(declarationConstraints), env);
    }

    public static void ValidateLHStoLHS(Target t, List<Constraints> checkIfTheseConstraints, List<Constraints> areWithinBoundsOfThese, Environment env) throws CREGenericConstraintException {
        boolean isVariadic;
        if ((checkIfTheseConstraints == null || checkIfTheseConstraints.isEmpty()) && (areWithinBoundsOfThese == null || areWithinBoundsOfThese.isEmpty())) {
            return;
        }
        if (areWithinBoundsOfThese != null && checkIfTheseConstraints == null) {
            throw new RuntimeException("Missing constraints.");
        }
        if (areWithinBoundsOfThese.get(areWithinBoundsOfThese.size() - 1).isVariadic()) {
            if (checkIfTheseConstraints.size() < areWithinBoundsOfThese.size() - 1) {
                throw new CREGenericConstraintException("Expected at least " + (areWithinBoundsOfThese.size() - 1) + " parameter(s), but found only " + checkIfTheseConstraints.size(), t);
            }
            isVariadic = true;
        } else {
            if (checkIfTheseConstraints.size() != areWithinBoundsOfThese.size()) {
                throw new CREGenericConstraintException("Expected " + areWithinBoundsOfThese.size() + " parameter(s), but found " + checkIfTheseConstraints.size(), t);
            }
            isVariadic = false;
        }
        for (int i = 0; i < checkIfTheseConstraints.size(); ++i) {
            Constraints definition = isVariadic ? (i >= areWithinBoundsOfThese.size() ? areWithinBoundsOfThese.get(areWithinBoundsOfThese.size() - 1) : areWithinBoundsOfThese.get(i)) : areWithinBoundsOfThese.get(i);
            Constraints lhs = checkIfTheseConstraints.get(i);
            ArrayList<String> errors = new ArrayList<String>();
            if (definition.withinBounds(lhs, errors, env)) continue;
            throw new CREGenericConstraintException("The constraint " + lhs.toString() + " does not fit within the bounds " + definition.toString() + ": " + StringUtils.Join(errors, "\n"), t);
        }
    }

    public static void ValidateParametersToDeclaration(Target t, Environment env, GenericParameters parameters, GenericDeclaration declaration, LeftHandSideType inferredType) {
        if (declaration == null) {
            if (parameters != null) {
                throw new CREGenericConstraintException("No generics are defined here, unexpected generic parameters provided.", t);
            }
            return;
        }
        if (parameters == null) {
            GenericParameters.GenericParametersBuilder builder = GenericParameters.emptyBuilder((CClassType)null);
            for (int i = 0; i < declaration.getParameterCount(); ++i) {
                LeftHandSideType type = inferredType == null ? Auto.LHSTYPE : inferredType;
                builder.addParameter(type);
            }
            parameters = builder.buildWithoutValidation();
        }
        if (parameters.getParameters().size() != declaration.getParameterCount()) {
            throw new CREGenericConstraintException(StringUtils.PluralTemplateHelper(declaration.getParameterCount(), "Expected %d generic parameter", "Expected %d generic parameters") + " to be provided, but instead " + StringUtils.PluralTemplateHelper(parameters.getParameters().size(), "%d was found.", "%d were found."), t);
        }
        for (int i = 0; i < declaration.getParameterCount(); ++i) {
            LeftHandSideType param;
            Constraints c = declaration.getConstraints().get(i);
            if (c.withinBounds(param = parameters.getParameters().get(i), env)) continue;
            throw new CREGenericConstraintException("Generic parameter at location " + i + " does not satisfy the constraints: " + c.toString(), t);
        }
    }

    public static void ValidateTypename(String typename, Target t) throws CREGenericConstraintException {
        String regex = "[a-zA-Z][a-zA-Z0-9_]*|\\?";
        if (!typename.matches(regex)) {
            throw new CREGenericConstraintException("Typenames must match the regex " + regex + " but found \"" + typename + "\"", t);
        }
    }
}

