/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics.constraints;

import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConstraintValidator;
import com.laytonsmith.core.constructs.generics.constraints.Constraint;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREGenericConstraintException;

public abstract class BoundaryConstraint
extends Constraint {
    protected LeftHandSideType bound;

    protected BoundaryConstraint(Target t, String typename, LeftHandSideType bound) {
        super(t, typename);
        ConstraintValidator.ValidateTypename(typename, t);
        if (Auto.LHSTYPE.equals(bound)) {
            throw new CREGenericConstraintException("Cannot use auto types on " + this.getConstraintName() + " constraints", t);
        }
        this.bound = bound;
    }

    @Override
    public boolean isWithinConstraint(LeftHandSideType type, Environment env) {
        return this.isConcreteClassWithinConstraint(type, env);
    }

    protected abstract boolean isConcreteClassWithinConstraint(LeftHandSideType var1, Environment var2);

    @Override
    public ExactTypeConstraint convertFromNull(Target t) throws CREGenericConstraintException {
        return new ExactTypeConstraint(t, Auto.LHSTYPE);
    }
}

