/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics.constraints;

import com.laytonsmith.PureUtilities.Common.Annotations.ForceImplementation;
import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.ConstraintToConstraintValidator;
import com.laytonsmith.core.constructs.generics.constraints.ConstructorConstraint;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.constructs.generics.constraints.LowerBoundConstraint;
import com.laytonsmith.core.constructs.generics.constraints.UnboundedConstraint;
import com.laytonsmith.core.constructs.generics.constraints.UpperBoundConstraint;
import com.laytonsmith.core.constructs.generics.constraints.VariadicTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREGenericConstraintException;
import java.util.Set;

public abstract class Constraint
implements Comparable<Constraint> {
    private final String typename;
    private final boolean isWildcard;
    private final Target target;

    protected Constraint(Target t, String constraintName) {
        this.typename = constraintName;
        this.isWildcard = this.typename.equals("?");
        this.target = t;
    }

    public String getTypeName() {
        return this.typename;
    }

    public abstract Set<ConstraintLocation> validLocations();

    public abstract String getConstraintName();

    public boolean isWildcard() {
        return this.isWildcard;
    }

    public Target getTarget() {
        return this.target;
    }

    public final Boolean isWithinConstraint(Constraint lhs, Environment env) {
        ConstraintToConstraintValidator validator = this.getConstraintToConstraintValidator(env);
        Boolean baseResult = false;
        if (lhs instanceof ConstructorConstraint) {
            ConstructorConstraint c = (ConstructorConstraint)lhs;
            baseResult = validator.isWithinBounds(c);
        } else if (lhs instanceof ExactTypeConstraint) {
            ExactTypeConstraint c = (ExactTypeConstraint)lhs;
            baseResult = validator.isWithinBounds(c);
        } else if (lhs instanceof LowerBoundConstraint) {
            LowerBoundConstraint c = (LowerBoundConstraint)lhs;
            baseResult = validator.isWithinBounds(c);
        } else if (lhs instanceof UpperBoundConstraint) {
            UpperBoundConstraint c = (UpperBoundConstraint)lhs;
            baseResult = validator.isWithinBounds(c);
        } else if (lhs instanceof UnboundedConstraint) {
            UnboundedConstraint c = (UnboundedConstraint)lhs;
            baseResult = validator.isWithinBounds(c);
        } else if (lhs instanceof VariadicTypeConstraint) {
            VariadicTypeConstraint c = (VariadicTypeConstraint)lhs;
            baseResult = validator.isWithinBounds(c);
        } else {
            throw new Error("Unhandled constraint type");
        }
        return baseResult;
    }

    public abstract boolean isWithinConstraint(LeftHandSideType var1, Environment var2);

    public abstract boolean supportsTypeUnions();

    @ForceImplementation
    protected abstract ConstraintToConstraintValidator getConstraintToConstraintValidator(Environment var1);

    public abstract ExactTypeConstraint convertFromDiamond(Target var1) throws CREGenericConstraintException;

    public abstract ExactTypeConstraint convertFromNull(Target var1) throws CREGenericConstraintException;

    public abstract String toSimpleString();

    @Override
    public int compareTo(Constraint o) {
        return this.toString().compareTo(o.toString());
    }
}

