/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.blocks;

import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.blocks.MCBeehive;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlockState;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Beehive;
import org.bukkit.block.BlockState;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntitySnapshot;

public class BukkitMCBeehive
extends BukkitMCBlockState
implements MCBeehive {
    Beehive bh;

    public BukkitMCBeehive(Beehive hive) {
        super((BlockState)hive);
        this.bh = hive;
    }

    public Beehive getHandle() {
        return this.bh;
    }

    @Override
    public MCLocation getFlowerLocation() {
        Location loc = this.bh.getFlower();
        if (loc == null) {
            return null;
        }
        return new BukkitMCLocation(loc);
    }

    @Override
    public void setFlowerLocation(MCLocation loc) {
        if (loc == null) {
            this.bh.setFlower(null);
        } else {
            this.bh.setFlower((Location)loc.getHandle());
        }
    }

    @Override
    public void addBees(int count) {
        try {
            EntitySnapshot beeSnapshot = Bukkit.getEntityFactory().createEntitySnapshot("{id:\"minecraft:bee\"}");
            World world = this.bh.isPlaced() ? this.bh.getWorld() : (World)Bukkit.getWorlds().get(0);
            for (int i = 0; i < count; ++i) {
                this.bh.addEntity((Entity)((Bee)beeSnapshot.createEntity(world)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public int getEntityCount() {
        return this.bh.getEntityCount();
    }
}

