/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics;

import com.laytonsmith.PureUtilities.Either;
import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.core.constructs.generics.Constraints;
import java.util.Objects;

public class LeftHandGenericUseParameter {
    private final Either<Constraints, Pair<String, Constraints>> value;

    public LeftHandGenericUseParameter(Either<Constraints, Pair<String, Constraints>> value) {
        if (!value.hasLeft() && !value.hasRight()) {
            throw new Error("LeftHandGenericUseParameter must contain one or the other type, and cannot be empty");
        }
        this.value = value;
    }

    public Either<Constraints, Pair<String, Constraints>> getValue() {
        return this.value;
    }

    public Constraints getConstraints() {
        if (this.value.hasLeft()) {
            return this.value.getLeft().get();
        }
        return this.value.getRight().get().getValue();
    }

    public String toString() {
        if (this.value.hasLeft()) {
            return this.value.getLeft().get().toString();
        }
        return this.value.getRight().get().getKey();
    }

    public String toSimpleString() {
        if (this.value.hasLeft()) {
            return this.value.getLeft().get().toSimpleString();
        }
        return this.value.getRight().get().getKey();
    }

    public int hashCode() {
        int hash2 = 3;
        hash2 = 97 * hash2 + Objects.hashCode(this.value);
        return hash2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeftHandGenericUseParameter other = (LeftHandGenericUseParameter)obj;
        return Objects.equals(this.value, other.value);
    }
}

