/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.enums.bukkit;

import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.enums.MCEnchantment;
import com.laytonsmith.abstraction.enums.MCVersion;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.constructs.Target;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.bukkit.NamespacedKey;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;

public class BukkitMCEnchantment
extends MCEnchantment<Enchantment> {
    private static final Map<Enchantment, MCEnchantment> BUKKIT_MAP = new HashMap<Enchantment, MCEnchantment>();

    public BukkitMCEnchantment(MCEnchantment.MCVanillaEnchantment vanillaType, Enchantment effect) {
        super(vanillaType, effect);
    }

    @Override
    public String name() {
        if (this.getAbstracted() == MCEnchantment.MCVanillaEnchantment.UNKNOWN) {
            return ((Enchantment)this.getConcrete()).getKey().getKey().toUpperCase(Locale.ROOT);
        }
        return ((MCEnchantment.MCVanillaEnchantment)((Object)this.getAbstracted())).name();
    }

    public static MCEnchantment valueOfConcrete(Enchantment test) {
        MCEnchantment type = BUKKIT_MAP.get(test);
        if (type == null) {
            MSLog.GetLogger().e((MSLog.Tag)MSLog.Tags.GENERAL, "Bukkit Enchantment missing in BUKKIT_MAP: " + test.getKey().getKey().toUpperCase(Locale.ROOT), Target.UNKNOWN);
            return new BukkitMCEnchantment(MCEnchantment.MCVanillaEnchantment.UNKNOWN, test);
        }
        return type;
    }

    @Override
    public boolean canEnchantItem(MCItemStack is) {
        return ((Enchantment)this.getConcrete()).canEnchantItem((ItemStack)is.getHandle());
    }

    @Override
    public int getMaxLevel() {
        return ((Enchantment)this.getConcrete()).getMaxLevel();
    }

    public static void build() {
        BukkitMCEnchantment wrapper;
        for (MCEnchantment.MCVanillaEnchantment mCVanillaEnchantment : MCEnchantment.MCVanillaEnchantment.values()) {
            if (!mCVanillaEnchantment.existsIn(Static.getServer().getMinecraftVersion())) continue;
            Enchantment type = BukkitMCEnchantment.getBukkitType(mCVanillaEnchantment);
            if (type == null) {
                MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find a Bukkit enchantment for " + mCVanillaEnchantment.name(), Target.UNKNOWN);
                continue;
            }
            wrapper = new BukkitMCEnchantment(mCVanillaEnchantment, type);
            MAP.put(mCVanillaEnchantment.name(), wrapper);
            BUKKIT_MAP.put(type, wrapper);
        }
        for (MCEnchantment.MCVanillaEnchantment mCVanillaEnchantment : Enchantment.values()) {
            if (mCVanillaEnchantment == null || BUKKIT_MAP.containsKey((Object)mCVanillaEnchantment)) continue;
            String name = mCVanillaEnchantment.getKey().getKey().toUpperCase(Locale.ROOT);
            MSLog.GetLogger().w(MSLog.Tags.GENERAL, "Could not find MCEnchantment for " + name, Target.UNKNOWN);
            wrapper = new BukkitMCEnchantment(MCEnchantment.MCVanillaEnchantment.UNKNOWN, (Enchantment)mCVanillaEnchantment);
            MAP.put(name, wrapper);
            BUKKIT_MAP.put((Enchantment)mCVanillaEnchantment, wrapper);
        }
    }

    private static Enchantment getBukkitType(MCEnchantment.MCVanillaEnchantment v) {
        if (Static.getServer().getMinecraftVersion().gte(MCVersion.MC1_20_6) && v == MCEnchantment.MCVanillaEnchantment.SWEEPING) {
            return Enchantment.SWEEPING_EDGE;
        }
        return Enchantment.getByKey((NamespacedKey)NamespacedKey.minecraft((String)v.name().toLowerCase(Locale.ROOT)));
    }
}

