/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.commandhelper;

import com.laytonsmith.abstraction.MCCommandSender;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.events.BukkitServerEvents;
import com.laytonsmith.abstraction.enums.MCChatColor;
import com.laytonsmith.core.InternalException;
import com.laytonsmith.core.Static;
import com.laytonsmith.core.events.Driver;
import com.laytonsmith.core.events.EventUtils;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import java.util.logging.Level;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.RemoteServerCommandEvent;
import org.bukkit.event.server.ServerCommandEvent;

public class CommandHelperServerListener
implements Listener {
    @EventHandler(priority=EventPriority.LOWEST)
    public void onServerCommand(ServerCommandEvent event) {
        this.processServerCommand(event);
    }

    @EventHandler(priority=EventPriority.LOWEST)
    public void onRemoteCommand(RemoteServerCommandEvent event) {
        this.processServerCommand((ServerCommandEvent)event);
    }

    private void processServerCommand(ServerCommandEvent event) {
        MCCommandSender sender = BukkitConvertor.BukkitGetCorrectSender(event.getSender());
        BukkitServerEvents.BukkitMCServerCommandEvent cce = new BukkitServerEvents.BukkitMCServerCommandEvent(event, sender);
        EventUtils.TriggerListener(Driver.SERVER_COMMAND, "server_command", cce);
        if (event.isCancelled()) {
            return;
        }
        boolean match = false;
        try {
            match = Static.getAliasCore().alias("/" + event.getCommand(), sender);
        }
        catch (InternalException e) {
            Static.getLogger().log(Level.SEVERE, e.getMessage());
        }
        catch (ConfigRuntimeException e) {
            Static.getLogger().log(Level.WARNING, e.getMessage());
        }
        catch (Throwable e) {
            sender.sendMessage(String.valueOf((Object)MCChatColor.RED) + "Command failed with following reason: " + e.getMessage());
            e.printStackTrace();
            return;
        }
        if (match) {
            event.setCommand("commandhelper null");
        }
    }
}

