/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs;

import com.laytonsmith.PureUtilities.Common.StringUtils;
import com.laytonsmith.PureUtilities.Either;
import com.laytonsmith.PureUtilities.ObjectHelpers;
import com.laytonsmith.PureUtilities.Pair;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.core.MSLog;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.constructs.Auto;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CNull;
import com.laytonsmith.core.constructs.CVoid;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.InstanceofUtil;
import com.laytonsmith.core.constructs.SourceType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConcreteGenericParameter;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.ConstraintValidator;
import com.laytonsmith.core.constructs.generics.Constraints;
import com.laytonsmith.core.constructs.generics.GenericDeclaration;
import com.laytonsmith.core.constructs.generics.GenericParameters;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUse;
import com.laytonsmith.core.constructs.generics.LeftHandGenericUseParameter;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.ObjectModifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;

public final class LeftHandSideType
extends Construct
implements SourceType {
    private boolean isTypeName;
    @ObjectHelpers.StandardField
    private final List<ConcreteGenericParameter> types;
    private final List<Boolean> isTypenameList;
    @ObjectHelpers.StandardField
    private String genericTypeName;
    @ObjectHelpers.StandardField
    private boolean isVariadicType = false;

    public static LeftHandSideType fromTypeUnion(Target t, Environment env, LeftHandSideType ... types) {
        HashSet<ConcreteGenericParameter> set = new HashSet<ConcreteGenericParameter>();
        ArrayList<Boolean> isTypenameList = new ArrayList<Boolean>();
        for (LeftHandSideType union : types) {
            set.addAll(union.getTypes());
            isTypenameList.add(union.isTypeName);
        }
        return LeftHandSideType.createCClassTypeUnion(t, env, new ArrayList<ConcreteGenericParameter>(set), isTypenameList);
    }

    public static LeftHandSideType fromNativeTypeUnion(LeftHandSideType ... types) {
        return LeftHandSideType.fromTypeUnion(Target.UNKNOWN, null, types);
    }

    public static LeftHandSideType fromHardCodedType(CClassType type) {
        return LeftHandSideType.fromCClassType(type, Target.UNKNOWN, null);
    }

    public static LeftHandSideType fromGenericDefinitionType(GenericDeclaration declaration, String genericTypeName, LeftHandGenericUse genericLHGU, Target t, Environment env) throws IllegalArgumentException {
        Constraints constraints = null;
        for (Constraints c : declaration.getConstraints()) {
            if (!c.getTypeName().equals(genericTypeName)) continue;
            constraints = c;
            break;
        }
        if (constraints == null) {
            throw new IllegalArgumentException("Provided GenericDeclaration does not contain the specified type name.");
        }
        return new LeftHandSideType(genericTypeName, t, env, null, Arrays.asList(true), genericTypeName, genericLHGU);
    }

    public static LeftHandSideType fromNativeGenericDefinitionType(GenericDeclaration declaration, String genericTypeName, LeftHandGenericUse genericLHGU) throws IllegalArgumentException {
        return LeftHandSideType.fromGenericDefinitionType(declaration, genericTypeName, genericLHGU, Target.UNKNOWN, null);
    }

    public static LeftHandSideType fromCClassType(CClassType classType, Target t, Environment env) {
        ArrayList<Boolean> isTypenameList = new ArrayList<Boolean>();
        isTypenameList.add(false);
        LeftHandSideType lhst = LeftHandSideType.createCClassTypeUnion(t, env, Arrays.asList(new ConcreteGenericParameter(classType, null, Target.UNKNOWN, null)), isTypenameList);
        if (classType != null) {
            lhst.isVariadicType = classType.isVariadicType();
        }
        return lhst;
    }

    public static LeftHandSideType fromCClassType(ConcreteGenericParameter type, Target t, Environment env) {
        ArrayList<Boolean> isTypenameList = new ArrayList<Boolean>();
        isTypenameList.add(false);
        return LeftHandSideType.createCClassTypeUnion(t, env, Arrays.asList(type), isTypenameList);
    }

    public static LeftHandSideType fromNativeCClassType(CClassType nativeClass, Renderer ... generics) {
        LeftHandGenericUseParameter[] rendered = new LeftHandGenericUseParameter[generics.length];
        for (int i = 0; i < rendered.length; ++i) {
            rendered[i] = generics[i].render(nativeClass, i);
        }
        return LeftHandSideType.fromCClassType(new ConcreteGenericParameter(nativeClass, LeftHandGenericUse.forNativeParameters(nativeClass, rendered), Target.UNKNOWN, null), Target.UNKNOWN, null);
    }

    public static LeftHandSideType fromNativeCClassType(CClassType type, LeftHandGenericUse lhgu) {
        return LeftHandSideType.fromCClassType(new ConcreteGenericParameter(type, lhgu, Target.UNKNOWN, null), Target.UNKNOWN, null);
    }

    public static LeftHandSideType fromCClassTypeUnion(Target t, Environment env, CClassType ... classTypes) {
        ArrayList<ConcreteGenericParameter> pairs = new ArrayList<ConcreteGenericParameter>();
        ArrayList<Boolean> isTypenameList = new ArrayList<Boolean>();
        ArrayList<CClassType> tempTypes = new ArrayList<CClassType>(Arrays.asList(classTypes));
        Iterator it = tempTypes.iterator();
        while (it.hasNext()) {
            boolean remove = false;
            CClassType subType = (CClassType)it.next();
            for (CClassType superType : tempTypes) {
                if (subType == superType || !InstanceofUtil.isInstanceof(subType.asLeftHandSideType(), superType.asLeftHandSideType(), env)) continue;
                remove = true;
                break;
            }
            if (!remove) continue;
            it.remove();
        }
        for (CClassType type : tempTypes) {
            pairs.add(new ConcreteGenericParameter(type, null, t, env));
            isTypenameList.add(false);
        }
        return LeftHandSideType.createCClassTypeUnion(t, env, pairs, isTypenameList);
    }

    private static LeftHandSideType createCClassTypeUnion(Target t, Environment env, List<ConcreteGenericParameter> classTypes, List<Boolean> isTypenameList) {
        Objects.requireNonNull(classTypes);
        if (classTypes.isEmpty()) {
            throw new IllegalArgumentException("A LeftHandSideType object must contain at least one type");
        }
        String value = StringUtils.Join(classTypes, " | ", pair -> {
            if (pair.getType() == null) {
                return "none";
            }
            return pair.toString();
        });
        for (ConcreteGenericParameter classType : classTypes) {
            if (!Auto.TYPE.equals(classType.getType())) continue;
            if (Auto.LHSTYPE == null) {
                List<ConcreteGenericParameter> types = Arrays.asList(new ConcreteGenericParameter(Auto.TYPE, null, Target.UNKNOWN, null));
                List<Boolean> itl = Arrays.asList(false);
                return new LeftHandSideType("auto", Target.UNKNOWN, env, types, itl, null, null);
            }
            return Auto.LHSTYPE;
        }
        return new LeftHandSideType(value, t, env, classTypes, isTypenameList, null, null);
    }

    public static LeftHandSideType resolveTypeFromGenerics(Target t, Environment env, LeftHandSideType types, GenericParameters parameters, GenericDeclaration declaration, Map<String, LeftHandSideType> inferredTypes) {
        if (types == null) {
            return types;
        }
        LeftHandSideType[] lhst = new LeftHandSideType[types.getTypes().size()];
        for (int i = 0; i < lhst.length; ++i) {
            ConcreteGenericParameter type = types.getTypes().get(i);
            LeftHandSideType inferredType = inferredTypes == null ? Auto.LHSTYPE : inferredTypes.get(type.getType().getFQCN().getFQCN());
            LeftHandGenericUse lhgu = type.getLeftHandGenericUse();
            if (lhgu != null && lhgu.hasTypename()) {
                ArrayList<LeftHandGenericUseParameter> newParameters = new ArrayList<LeftHandGenericUseParameter>();
                int k = 0;
                for (LeftHandGenericUseParameter parameter : type.getLeftHandGenericUse().getParameters()) {
                    if (parameter.getValue().hasLeft()) {
                        newParameters.add(parameter);
                    } else if (inferredType == null) {
                        newParameters.add(Auto.LHSTYPE.toNativeLeftHandGenericUse(type.getType(), k));
                    } else {
                        newParameters.add(inferredType.toLeftHandGenericUse(type.getType(), t, env, ConstraintLocation.LHS, k));
                    }
                    ++k;
                }
                lhgu = new LeftHandGenericUse(type.getType(), t, env, newParameters);
            }
            LeftHandSideType newType = LeftHandSideType.fromCClassType(new ConcreteGenericParameter(type.getType(), lhgu, t, env), t, env);
            newType.isTypeName = types.isTypenameList.get(i);
            if (newType.isTypeName) {
                newType.genericTypeName = type.getType().getFQCN().getFQCN();
            }
            lhst[i] = LeftHandSideType.resolveTypeFromGenerics(t, env, newType, parameters, declaration, inferredType);
        }
        return LeftHandSideType.fromTypeUnion(t, env, lhst);
    }

    public static LeftHandSideType resolveTypeFromGenerics(Target t, Environment env, LeftHandSideType type, GenericParameters parameters, GenericDeclaration declaration, LeftHandSideType inferredType) {
        if (type == null) {
            return type;
        }
        if (type.isTypeUnion()) {
            LeftHandSideType[] lhst = new LeftHandSideType[type.getTypes().size()];
            for (int i = 0; i < lhst.length; ++i) {
                ConcreteGenericParameter _type = type.getTypes().get(i);
                LeftHandSideType newType = LeftHandSideType.fromCClassType(_type, t, env);
                newType.isTypeName = type.isTypenameList.get(i);
                if (newType.isTypeName) {
                    newType.genericTypeName = _type.getType().getFQCN().getFQCN();
                }
                lhst[i] = LeftHandSideType.resolveTypeFromGenerics(t, env, newType, parameters, declaration, inferredType);
            }
            return LeftHandSideType.fromTypeUnion(t, env, lhst);
        }
        if (!type.isTypeName()) {
            return type;
        }
        ConstraintValidator.ValidateParametersToDeclaration(t, env, parameters, declaration, inferredType);
        if (parameters == null && inferredType == null) {
            return Auto.LHSTYPE;
        }
        String typename = type.getTypename();
        for (int i = 0; i < declaration.getParameterCount(); ++i) {
            if (!declaration.getConstraints().get(i).getTypeName().equals(typename)) continue;
            if (parameters != null) {
                LeftHandSideType p2 = parameters.getParameters().get(i);
                return p2;
            }
            if (inferredType == null) continue;
            return inferredType;
        }
        throw new Error("Typename returned by native function is not in the GenericDeclaration!");
    }

    private LeftHandSideType(String value, Target t, Environment env, List<ConcreteGenericParameter> types, List<Boolean> isTypenameList, String genericTypeName, LeftHandGenericUse genericTypeLHGU) {
        super(value, Construct.ConstructType.CLASS_TYPE, t);
        this.isTypenameList = isTypenameList;
        if (types != null) {
            this.isTypeName = false;
            TreeSet<ConcreteGenericParameter> tempSet = new TreeSet<ConcreteGenericParameter>((o1, o2) -> {
                String o1Index = o1 == null ? "none" : o1.toString();
                String o2Index = o2 == null ? "none" : o2.toString();
                return o1Index.compareTo(o2Index);
            });
            tempSet.addAll(types);
            this.types = new ArrayList<ConcreteGenericParameter>(tempSet);
            if (this.isTypeUnion()) {
                for (ConcreteGenericParameter type : types) {
                    if (!Auto.TYPE.equals(type.getType())) continue;
                    throw new CREIllegalArgumentException("auto type cannot be used in a type union", t);
                }
            }
            this.genericTypeName = null;
        } else {
            this.types = new ArrayList<ConcreteGenericParameter>();
            this.types.add(new ConcreteGenericParameter(CClassType.getFromGenericTypeName(genericTypeName, t), genericTypeLHGU, t, env));
            this.isTypeName = true;
            this.genericTypeName = genericTypeName;
        }
    }

    @Override
    public boolean isDynamic() {
        return false;
    }

    public List<ConcreteGenericParameter> getTypes() {
        return new ArrayList<ConcreteGenericParameter>(this.types);
    }

    public boolean isExtendedBy(CClassType type, Environment env) {
        return CClassType.doesExtend(env, type, this.asConcreteType(Target.UNKNOWN));
    }

    public boolean doesExtend(CClassType type, Environment env) {
        return this.doesExtend(type.asLeftHandSideType(), env);
    }

    public boolean doesExtend(LeftHandSideType type, Environment env) {
        return CClassType.doesExtend(env, this.asConcreteType(Target.UNKNOWN), type.asConcreteType(Target.UNKNOWN));
    }

    public boolean isTypeUnion() {
        return this.types.size() > 1;
    }

    public boolean isTypeName() {
        return this.isTypeName;
    }

    public String getTypename() {
        return this.genericTypeName;
    }

    public String getSimpleName() {
        return StringUtils.Join(this.types, " | ", pair -> pair.toSimpleString());
    }

    public CClassType[] getTypeInterfaces(Environment env) {
        if (!this.isTypeUnion()) {
            return this.types.get(0).getType().getTypeInterfaces(env);
        }
        HashSet<CClassType> interfaces = new HashSet<CClassType>(Arrays.asList(this.types.get(0).getType().getTypeInterfaces(env)));
        for (ConcreteGenericParameter subTypes : this.getTypes()) {
            CClassType type = subTypes.getType();
            Iterator it = interfaces.iterator();
            while (it.hasNext()) {
                CClassType iface = (CClassType)it.next();
                if (Arrays.asList(type.getTypeInterfaces(env)).contains(iface)) continue;
                it.remove();
            }
        }
        return (CClassType[])interfaces.toArray(CClassType[]::new);
    }

    public CClassType[] getTypeSuperclasses(Environment env) {
        if (!this.isTypeUnion()) {
            return this.types.get(0).getType().getTypeInterfaces(env);
        }
        HashSet<CClassType> superclasses = new HashSet<CClassType>(Arrays.asList(this.types.get(0).getType().getTypeSuperclasses(env)));
        for (ConcreteGenericParameter subTypes : this.getTypes()) {
            CClassType type = subTypes.getType();
            Iterator it = superclasses.iterator();
            while (it.hasNext()) {
                CClassType iface = (CClassType)it.next();
                if (Arrays.asList(type.getTypeSuperclasses(env)).contains(iface)) continue;
                it.remove();
            }
        }
        return (CClassType[])superclasses.toArray(CClassType[]::new);
    }

    public CClassType asConcreteType(Target t) throws CREIllegalArgumentException {
        MSLog.StringProvider exMsg = () -> "Cannot use the type \"" + this.getSimpleName() + "\" in this context.";
        ConcreteGenericParameter type = this.types.get(0);
        if (type.getLeftHandGenericUse() != null && !type.getLeftHandGenericUse().getConstraints().isEmpty()) {
            throw new CREIllegalArgumentException(exMsg.getString(), t);
        }
        return type.getType();
    }

    public boolean isVoid() {
        if (this.isTypeUnion()) {
            return false;
        }
        return CVoid.TYPE.equals(this.types.get(0).getType());
    }

    public boolean isAuto() {
        if (this.isTypeUnion()) {
            return false;
        }
        return CClassType.AUTO.equals(this.types.get(0).getType());
    }

    public boolean isNull() {
        if (this.isTypeUnion()) {
            return false;
        }
        return CNull.TYPE.equals(this.types.get(0).getType());
    }

    public LeftHandGenericUseParameter toNativeLeftHandGenericUse(CClassType forType, int parameterPosition) {
        return this.toLeftHandGenericUse(forType, Target.UNKNOWN, null, ConstraintLocation.LHS, parameterPosition);
    }

    public Renderer toNativeLeftHandGenericUse() {
        return new Renderer(){

            @Override
            public LeftHandGenericUseParameter render(CClassType forType, int parameterPosition) {
                return LeftHandSideType.this.toNativeLeftHandGenericUse(forType, parameterPosition);
            }
        };
    }

    public LeftHandGenericUseParameter toLeftHandGenericUse(CClassType forType, Target t, Environment env, ConstraintLocation location, int parameterPosition) {
        if (this.isTypeName) {
            return new LeftHandGenericUseParameter(Either.right(new Pair<String, Constraints>(this.getTypename(), forType.getGenericDeclaration().getConstraints().get(parameterPosition))));
        }
        return new LeftHandGenericUseParameter(Either.left(new Constraints(t, location, new ExactTypeConstraint(t, this))));
    }

    public LeftHandSideType getNakedType(Target t, Environment env) {
        ArrayList<LeftHandSideType> newTypes = new ArrayList<LeftHandSideType>();
        for (ConcreteGenericParameter m : this.types) {
            if (m.getType() == null) {
                return null;
            }
            if (m.getType().equals(Auto.TYPE)) {
                newTypes.add(Auto.LHSTYPE);
                continue;
            }
            newTypes.add(m.getType().getNakedType(env).asLeftHandSideType());
        }
        return LeftHandSideType.fromTypeUnion(t, env, (LeftHandSideType[])newTypes.toArray(LeftHandSideType[]::new));
    }

    @Override
    public Set<ObjectModifier> getObjectModifiers() {
        return EnumSet.of(ObjectModifier.FINAL);
    }

    public List<Set<ObjectModifier>> getTypeObjectModifiers() {
        ArrayList<Set<ObjectModifier>> ret = new ArrayList<Set<ObjectModifier>>();
        for (ConcreteGenericParameter type : this.types) {
            ret.add(type.getType().getObjectModifiers());
        }
        return ret;
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_5;
    }

    @Override
    public CClassType[] getInterfaces() {
        return CClassType.EMPTY_CLASS_ARRAY;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public String docs() {
        return "Represents a left hand side type expression. This has LHS semantics, including supporting bounded generics and type unions.";
    }

    public boolean equals(Object obj) {
        return ObjectHelpers.DoEquals(this, obj);
    }

    @Override
    public int hashCode() {
        return ObjectHelpers.DoHashCode(this);
    }

    @Override
    public String toString() {
        return this.val();
    }

    public GenericParameters getGenericParameters() {
        return null;
    }

    @Override
    public SourceType asVariadicType(Environment env) {
        LeftHandSideType newType = new LeftHandSideType(this.val() + "...", this.getTarget(), env, this.types, this.isTypenameList, this.genericTypeName, null);
        newType.isVariadicType = true;
        return newType;
    }

    @Override
    public boolean isVariadicType() {
        return this.isVariadicType;
    }

    public static interface Renderer {
        public LeftHandGenericUseParameter render(CClassType var1, int var2);
    }
}

