/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.constructs.generics.constraints;

import com.laytonsmith.core.constructs.LeftHandSideType;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.constructs.generics.ConstraintLocation;
import com.laytonsmith.core.constructs.generics.ConstraintToConstraintValidator;
import com.laytonsmith.core.constructs.generics.ConstraintValidator;
import com.laytonsmith.core.constructs.generics.constraints.BoundaryConstraint;
import com.laytonsmith.core.constructs.generics.constraints.ConstructorConstraint;
import com.laytonsmith.core.constructs.generics.constraints.ExactTypeConstraint;
import com.laytonsmith.core.constructs.generics.constraints.LowerBoundConstraint;
import com.laytonsmith.core.constructs.generics.constraints.UnboundedConstraint;
import com.laytonsmith.core.constructs.generics.constraints.VariadicTypeConstraint;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.CRE.CREGenericConstraintException;
import com.laytonsmith.core.objects.ObjectModifier;
import java.util.EnumSet;
import java.util.Set;

public class UpperBoundConstraint
extends BoundaryConstraint {
    public UpperBoundConstraint(Target t, String typename, LeftHandSideType upperBound) {
        super(t, typename, upperBound);
        ConstraintValidator.ValidateTypename(typename, t);
        for (Set<ObjectModifier> upperBoundComponent : upperBound.getTypeObjectModifiers()) {
            if (!upperBoundComponent.contains((Object)ObjectModifier.FINAL)) continue;
            throw new CREGenericConstraintException(upperBound.val() + " is marked as final, and so cannot be used in an upper bound constraint.", t);
        }
    }

    public LeftHandSideType getUpperBound() {
        return this.bound;
    }

    @Override
    public String toSimpleString() {
        return this.getTypeName() + " extends " + this.getUpperBound().getSimpleName();
    }

    public String toString() {
        return this.getTypeName() + " extends " + String.valueOf(this.getUpperBound());
    }

    public EnumSet<ConstraintLocation> validLocations() {
        return EnumSet.allOf(ConstraintLocation.class);
    }

    @Override
    public String getConstraintName() {
        return "upper bound";
    }

    @Override
    protected boolean isConcreteClassWithinConstraint(LeftHandSideType type, Environment env) {
        return type.doesExtend(this.bound, env);
    }

    @Override
    protected ConstraintToConstraintValidator getConstraintToConstraintValidator(final Environment env) {
        return new ConstraintToConstraintValidator(){

            @Override
            public Boolean isWithinBounds(ConstructorConstraint lhs) {
                return null;
            }

            @Override
            public Boolean isWithinBounds(ExactTypeConstraint lhs) {
                if (lhs.getType() == null) {
                    return true;
                }
                return UpperBoundConstraint.this.isWithinConstraint(lhs.getType(), env);
            }

            @Override
            public Boolean isWithinBounds(LowerBoundConstraint lhs) {
                return lhs.getLowerBound().doesExtend(UpperBoundConstraint.this.getUpperBound(), env);
            }

            @Override
            public Boolean isWithinBounds(UpperBoundConstraint lhs) {
                return lhs.getUpperBound().doesExtend(UpperBoundConstraint.this.getUpperBound(), env);
            }

            @Override
            public Boolean isWithinBounds(UnboundedConstraint lhs) {
                throw new Error("Unexpected constraint combination.");
            }

            @Override
            public Boolean isWithinBounds(VariadicTypeConstraint lhs) {
                throw new Error("Unexpected constraint combination.");
            }
        };
    }

    @Override
    public ExactTypeConstraint convertFromDiamond(Target t) {
        return new ExactTypeConstraint(t, this.bound);
    }

    @Override
    public boolean supportsTypeUnions() {
        return true;
    }
}

