/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.abstraction.bukkit.events;

import com.laytonsmith.PureUtilities.Vector3D;
import com.laytonsmith.abstraction.Implementation;
import com.laytonsmith.abstraction.MCBookMeta;
import com.laytonsmith.abstraction.MCEntity;
import com.laytonsmith.abstraction.MCHumanEntity;
import com.laytonsmith.abstraction.MCItemStack;
import com.laytonsmith.abstraction.MCLocation;
import com.laytonsmith.abstraction.MCPlayer;
import com.laytonsmith.abstraction.MCWorld;
import com.laytonsmith.abstraction.blocks.MCBlock;
import com.laytonsmith.abstraction.blocks.MCBlockFace;
import com.laytonsmith.abstraction.bukkit.BukkitConvertor;
import com.laytonsmith.abstraction.bukkit.BukkitMCBookMeta;
import com.laytonsmith.abstraction.bukkit.BukkitMCItemStack;
import com.laytonsmith.abstraction.bukkit.BukkitMCLocation;
import com.laytonsmith.abstraction.bukkit.BukkitMCWorld;
import com.laytonsmith.abstraction.bukkit.blocks.BukkitMCBlock;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCFishHook;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCHumanEntity;
import com.laytonsmith.abstraction.bukkit.entities.BukkitMCPlayer;
import com.laytonsmith.abstraction.bukkit.events.BukkitEntityEvents;
import com.laytonsmith.abstraction.entities.MCFishHook;
import com.laytonsmith.abstraction.enums.MCAction;
import com.laytonsmith.abstraction.enums.MCEnterBedResult;
import com.laytonsmith.abstraction.enums.MCEquipmentSlot;
import com.laytonsmith.abstraction.enums.MCFishingState;
import com.laytonsmith.abstraction.enums.MCGameMode;
import com.laytonsmith.abstraction.enums.MCResourcePackStatus;
import com.laytonsmith.abstraction.enums.MCTeleportCause;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCAction;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCEnterBedResult;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCFishingState;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCGameMode;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCResourcePackStatus;
import com.laytonsmith.abstraction.enums.bukkit.BukkitMCTeleportCause;
import com.laytonsmith.abstraction.events.MCExpChangeEvent;
import com.laytonsmith.abstraction.events.MCFoodLevelChangeEvent;
import com.laytonsmith.abstraction.events.MCGamemodeChangeEvent;
import com.laytonsmith.abstraction.events.MCPlayerChatEvent;
import com.laytonsmith.abstraction.events.MCPlayerCommandEvent;
import com.laytonsmith.abstraction.events.MCPlayerDeathEvent;
import com.laytonsmith.abstraction.events.MCPlayerEditBookEvent;
import com.laytonsmith.abstraction.events.MCPlayerEnterBedEvent;
import com.laytonsmith.abstraction.events.MCPlayerEvent;
import com.laytonsmith.abstraction.events.MCPlayerFishEvent;
import com.laytonsmith.abstraction.events.MCPlayerInteractEvent;
import com.laytonsmith.abstraction.events.MCPlayerItemConsumeEvent;
import com.laytonsmith.abstraction.events.MCPlayerJoinEvent;
import com.laytonsmith.abstraction.events.MCPlayerKickEvent;
import com.laytonsmith.abstraction.events.MCPlayerLeaveBedEvent;
import com.laytonsmith.abstraction.events.MCPlayerLoginEvent;
import com.laytonsmith.abstraction.events.MCPlayerMoveEvent;
import com.laytonsmith.abstraction.events.MCPlayerPortalEvent;
import com.laytonsmith.abstraction.events.MCPlayerQuitEvent;
import com.laytonsmith.abstraction.events.MCPlayerResourcePackEvent;
import com.laytonsmith.abstraction.events.MCPlayerRespawnEvent;
import com.laytonsmith.abstraction.events.MCPlayerTeleportEvent;
import com.laytonsmith.abstraction.events.MCPlayerToggleFlightEvent;
import com.laytonsmith.abstraction.events.MCPlayerToggleSneakEvent;
import com.laytonsmith.abstraction.events.MCPlayerToggleSprintEvent;
import com.laytonsmith.abstraction.events.MCWorldChangedEvent;
import com.laytonsmith.annotations.abstraction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.Action;
import org.bukkit.event.entity.FoodLevelChangeEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.event.player.PlayerBedLeaveEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.event.player.PlayerEditBookEvent;
import org.bukkit.event.player.PlayerEvent;
import org.bukkit.event.player.PlayerExpChangeEvent;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.event.player.PlayerGameModeChangeEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerItemConsumeEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerKickEvent;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerPortalEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.player.PlayerResourcePackStatusEvent;
import org.bukkit.event.player.PlayerRespawnEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.event.player.PlayerToggleFlightEvent;
import org.bukkit.event.player.PlayerToggleSneakEvent;
import org.bukkit.event.player.PlayerToggleSprintEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.util.Vector;

public class BukkitPlayerEvents {

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerMoveEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerMoveEvent {
        PlayerMoveEvent pme;
        int threshold;
        MCLocation from;

        public BukkitMCPlayerMoveEvent(PlayerMoveEvent event, int threshold, MCLocation from) {
            super((PlayerEvent)event);
            this.pme = event;
            this.threshold = threshold;
            this.from = from;
        }

        @Override
        public int getThreshold() {
            return this.threshold;
        }

        @Override
        public MCLocation getFrom() {
            return new BukkitMCLocation(this.from);
        }

        @Override
        public MCLocation getTo() {
            return new BukkitMCLocation(this.pme.getTo());
        }

        @Override
        public boolean isCancelled() {
            return this.pme.isCancelled();
        }

        @Override
        public void setCancelled(boolean bln) {
            this.pme.setCancelled(bln);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerResourcePackEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerResourcePackEvent {
        PlayerResourcePackStatusEvent e;

        public BukkitMCPlayerResourcePackEvent(PlayerResourcePackStatusEvent event) {
            super((PlayerEvent)event);
            this.e = event;
        }

        @Override
        public MCResourcePackStatus getStatus() {
            return (MCResourcePackStatus)((Object)BukkitMCResourcePackStatus.getConvertor().getAbstractedEnum(this.e.getStatus()));
        }

        @Override
        public UUID getId() {
            return this.e.getID();
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerToggleSprintEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerToggleSprintEvent {
        PlayerToggleSprintEvent ptse;

        public BukkitMCPlayerToggleSprintEvent(PlayerToggleSprintEvent event) {
            super((PlayerEvent)event);
            this.ptse = event;
        }

        @Override
        public boolean isSprinting() {
            return this.ptse.isSprinting();
        }

        @Override
        public boolean isCancelled() {
            return this.ptse.isCancelled();
        }

        @Override
        public void setCancelled(boolean bln) {
            this.ptse.setCancelled(bln);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerToggleSneakEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerToggleSneakEvent {
        PlayerToggleSneakEvent ptse;

        public BukkitMCPlayerToggleSneakEvent(PlayerToggleSneakEvent event) {
            super((PlayerEvent)event);
            this.ptse = event;
        }

        @Override
        public boolean isSneaking() {
            return this.ptse.isSneaking();
        }

        @Override
        public boolean isCancelled() {
            return this.ptse.isCancelled();
        }

        @Override
        public void setCancelled(boolean bln) {
            this.ptse.setCancelled(bln);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerToggleFlightEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerToggleFlightEvent {
        PlayerToggleFlightEvent ptfe;

        public BukkitMCPlayerToggleFlightEvent(PlayerToggleFlightEvent event) {
            super((PlayerEvent)event);
            this.ptfe = event;
        }

        @Override
        public boolean isFlying() {
            return this.ptfe.isFlying();
        }

        @Override
        public boolean isCancelled() {
            return this.ptfe.isCancelled();
        }

        @Override
        public void setCancelled(boolean bln) {
            this.ptfe.setCancelled(bln);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerEditBookEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerEditBookEvent {
        PlayerEditBookEvent pebe;

        public BukkitMCPlayerEditBookEvent(PlayerEditBookEvent event) {
            super((PlayerEvent)event);
            this.pebe = event;
        }

        @Override
        public MCBookMeta getNewBookMeta() {
            return new BukkitMCBookMeta(this.pebe.getNewBookMeta());
        }

        @Override
        public MCBookMeta getPreviousBookMeta() {
            return new BukkitMCBookMeta(this.pebe.getPreviousBookMeta());
        }

        @Override
        public void setNewBookMeta(MCBookMeta bookMeta) {
            this.pebe.setNewBookMeta(((BukkitMCBookMeta)bookMeta).getBookMeta());
        }

        @Override
        public int getSlot() {
            int slot = this.pebe.getSlot();
            if (slot == -1) {
                return -106;
            }
            return slot;
        }

        @Override
        public boolean isSigning() {
            return this.pebe.isSigning();
        }

        @Override
        public void setSigning(boolean isSigning) {
            this.pebe.setSigning(isSigning);
        }
    }

    public static class BukkitMCExpChangeEvent
    extends BukkitMCPlayerEvent
    implements MCExpChangeEvent {
        PlayerExpChangeEvent ec;

        public BukkitMCExpChangeEvent(PlayerExpChangeEvent event) {
            super((PlayerEvent)event);
            this.ec = event;
        }

        @Override
        public int getAmount() {
            return this.ec.getAmount();
        }

        @Override
        public void setAmount(int amount) {
            this.ec.setAmount(amount);
        }
    }

    public static class BukkitMCGamemodeChangeEvent
    extends BukkitMCPlayerEvent
    implements MCGamemodeChangeEvent {
        PlayerGameModeChangeEvent gmc;

        public BukkitMCGamemodeChangeEvent(PlayerGameModeChangeEvent event) {
            super((PlayerEvent)event);
            this.gmc = event;
        }

        @Override
        public MCGameMode getNewGameMode() {
            return (MCGameMode)((Object)BukkitMCGameMode.getConvertor().getAbstractedEnum(this.gmc.getNewGameMode()));
        }
    }

    public static class BukkitMCPlayerFishEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerFishEvent {
        PlayerFishEvent e;

        public BukkitMCPlayerFishEvent(PlayerFishEvent event) {
            super((PlayerEvent)event);
            this.e = event;
        }

        @Override
        public MCEntity getCaught() {
            if (this.e.getCaught() == null) {
                return null;
            }
            return BukkitConvertor.BukkitGetCorrectEntity(this.e.getCaught());
        }

        @Override
        public int getExpToDrop() {
            return this.e.getExpToDrop();
        }

        @Override
        public MCFishHook getHook() {
            return new BukkitMCFishHook((Entity)this.e.getHook());
        }

        @Override
        public MCFishingState getState() {
            return (MCFishingState)((Object)BukkitMCFishingState.getConvertor().getAbstractedEnum(this.e.getState()));
        }

        @Override
        public void setExpToDrop(int exp) {
            this.e.setExpToDrop(exp);
        }

        @Override
        public MCEquipmentSlot getHand() {
            if (this.e.getHand() == null) {
                return null;
            }
            if (this.e.getHand() == EquipmentSlot.HAND) {
                return MCEquipmentSlot.WEAPON;
            }
            return MCEquipmentSlot.OFF_HAND;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCWorldChangedEvent
    extends BukkitMCPlayerEvent
    implements MCWorldChangedEvent {
        PlayerChangedWorldEvent pcwe;

        public BukkitMCWorldChangedEvent(PlayerChangedWorldEvent e) {
            super((PlayerEvent)e);
            this.pcwe = e;
        }

        @Override
        public MCWorld getFrom() {
            return new BukkitMCWorld(this.pcwe.getFrom());
        }

        @Override
        public MCWorld getTo() {
            return new BukkitMCWorld(this.pcwe.getPlayer().getWorld());
        }

        public static BukkitMCWorldChangedEvent _instantiate(MCPlayer entity, MCWorld from) {
            return new BukkitMCWorldChangedEvent(new PlayerChangedWorldEvent(((BukkitMCPlayer)entity)._Player(), ((BukkitMCWorld)from).__World()));
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerCommandEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerCommandEvent {
        PlayerCommandPreprocessEvent pcpe;
        boolean isCancelled = false;

        public BukkitMCPlayerCommandEvent(PlayerCommandPreprocessEvent pcpe) {
            super((PlayerEvent)pcpe);
            this.pcpe = pcpe;
        }

        @Override
        public String getCommand() {
            return this.pcpe.getMessage();
        }

        @Override
        public void cancel() {
            this.pcpe.setMessage("/commandhelper null");
            this.pcpe.setCancelled(true);
            this.isCancelled = true;
        }

        public static BukkitMCPlayerCommandEvent _instantiate(MCPlayer entity, String command) {
            return new BukkitMCPlayerCommandEvent(new PlayerCommandPreprocessEvent(((BukkitMCPlayer)entity)._Player(), command));
        }

        @Override
        public void setCommand(String val) {
            this.pcpe.setMessage(val);
        }

        @Override
        public boolean isCancelled() {
            return this.isCancelled;
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerDeathEvent
    extends BukkitEntityEvents.BukkitMCEntityDeathEvent
    implements MCPlayerDeathEvent {
        PlayerDeathEvent pde;

        public BukkitMCPlayerDeathEvent(Event event) {
            super(event);
            this.pde = (PlayerDeathEvent)event;
        }

        public static BukkitMCPlayerDeathEvent _instantiate(MCPlayer entity, List<MCItemStack> listOfDrops, int droppedExp, String deathMessage) {
            ArrayList drops = new ArrayList();
            return new BukkitMCPlayerDeathEvent((Event)new PlayerDeathEvent(((BukkitMCPlayer)entity)._Player(), drops, droppedExp, deathMessage));
        }

        @Override
        public MCPlayer getEntity() {
            return new BukkitMCPlayer((Entity)this.pde.getEntity());
        }

        @Override
        public MCEntity getKiller() {
            return BukkitConvertor.BukkitGetCorrectEntity((Entity)this.pde.getEntity().getKiller());
        }

        @Override
        public String getDeathMessage() {
            return this.pde.getDeathMessage();
        }

        @Override
        public void setDeathMessage(String nval) {
            this.pde.setDeathMessage(nval);
        }

        @Override
        public boolean getKeepInventory() {
            return this.pde.getKeepInventory();
        }

        @Override
        public void setKeepInventory(boolean keepInventory) {
            this.pde.setKeepInventory(keepInventory);
        }

        @Override
        public boolean getKeepLevel() {
            return this.pde.getKeepLevel();
        }

        @Override
        public void setKeepLevel(boolean keepLevel) {
            this.pde.setKeepLevel(keepLevel);
        }

        @Override
        public int getNewExp() {
            return this.pde.getNewExp();
        }

        @Override
        public void setNewExp(int exp) {
            this.pde.setNewExp(exp);
        }

        @Override
        public int getNewLevel() {
            return this.pde.getNewLevel();
        }

        @Override
        public void setNewLevel(int level) {
            this.pde.setNewLevel(level);
        }

        @Override
        public int getNewTotalExp() {
            return this.pde.getNewTotalExp();
        }

        @Override
        public void setNewTotalExp(int totalExp) {
            this.pde.setNewTotalExp(totalExp);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerRespawnEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerRespawnEvent {
        PlayerRespawnEvent pre;

        public BukkitMCPlayerRespawnEvent(PlayerRespawnEvent event) {
            super((PlayerEvent)event);
            this.pre = event;
        }

        public static BukkitMCPlayerRespawnEvent _instantiate(MCPlayer player2, MCLocation location, boolean isBedSpawn) {
            return new BukkitMCPlayerRespawnEvent(new PlayerRespawnEvent(((BukkitMCPlayer)player2)._Player(), ((BukkitMCLocation)location)._Location(), isBedSpawn));
        }

        @Override
        public void setRespawnLocation(MCLocation location) {
            this.pre.setRespawnLocation(((BukkitMCLocation)location)._Location());
        }

        @Override
        public MCLocation getRespawnLocation() {
            return new BukkitMCLocation(this.pre.getRespawnLocation());
        }

        @Override
        public Boolean isBedSpawn() {
            return this.pre.isBedSpawn();
        }

        @Override
        public boolean isAnchorSpawn() {
            return this.pre.isAnchorSpawn();
        }

        @Override
        public MCPlayerRespawnEvent.Reason getReason() {
            return MCPlayerRespawnEvent.Reason.valueOf(this.pre.getRespawnReason().name());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerInteractEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerInteractEvent {
        PlayerInteractEvent pie;

        public BukkitMCPlayerInteractEvent(PlayerInteractEvent e) {
            super((PlayerEvent)e);
            this.pie = e;
        }

        public static BukkitMCPlayerInteractEvent _instantiate(MCPlayer player2, MCAction action, MCItemStack itemstack, MCBlock clickedBlock, MCBlockFace clickedFace) {
            return new BukkitMCPlayerInteractEvent(new PlayerInteractEvent(((BukkitMCPlayer)player2)._Player(), (Action)BukkitMCAction.getConvertor().getConcreteEnum(action), ((BukkitMCItemStack)itemstack).__ItemStack(), ((BukkitMCBlock)clickedBlock).__Block(), BlockFace.valueOf((String)clickedFace.name())));
        }

        @Override
        public MCAction getAction() {
            return (MCAction)((Object)BukkitMCAction.getConvertor().getAbstractedEnum(this.pie.getAction()));
        }

        @Override
        public MCBlock getClickedBlock() {
            return new BukkitMCBlock(this.pie.getClickedBlock());
        }

        @Override
        public MCBlockFace getBlockFace() {
            return MCBlockFace.valueOf(this.pie.getBlockFace().name());
        }

        @Override
        public MCItemStack getItem() {
            return new BukkitMCItemStack(this.pie.getItem());
        }

        @Override
        public MCEquipmentSlot getHand() {
            if (this.pie.getHand() == EquipmentSlot.HAND) {
                return MCEquipmentSlot.WEAPON;
            }
            return MCEquipmentSlot.OFF_HAND;
        }

        @Override
        public Vector3D getClickedPosition() {
            Vector v = this.pie.getClickedPosition();
            if (v == null) {
                return Vector3D.ZERO;
            }
            return new Vector3D(v.getX(), v.getY(), v.getZ());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerJoinEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerJoinEvent {
        PlayerJoinEvent pje;

        public BukkitMCPlayerJoinEvent(PlayerJoinEvent e) {
            super((PlayerEvent)e);
            this.pje = e;
        }

        @Override
        public String getJoinMessage() {
            return this.pje.getJoinMessage();
        }

        @Override
        public void setJoinMessage(String message) {
            this.pje.setJoinMessage(message);
        }

        public static PlayerJoinEvent _instantiate(MCPlayer player2, String message) {
            return new PlayerJoinEvent(((BukkitMCPlayer)player2)._Player(), message);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerQuitEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerQuitEvent {
        PlayerQuitEvent pce;

        public BukkitMCPlayerQuitEvent(PlayerQuitEvent event) {
            super((PlayerEvent)event);
            this.pce = event;
        }

        public static BukkitMCPlayerQuitEvent _instantiate(MCPlayer player2, String message) {
            return new BukkitMCPlayerQuitEvent(new PlayerQuitEvent(((BukkitMCPlayer)player2)._Player(), message));
        }

        @Override
        public String getMessage() {
            return this.pce.getQuitMessage();
        }

        @Override
        public void setMessage(String message) {
            this.pce.setQuitMessage(message);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerChatEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerChatEvent {
        AsyncPlayerChatEvent pce;

        public BukkitMCPlayerChatEvent(AsyncPlayerChatEvent event) {
            super((PlayerEvent)event);
            this.pce = event;
        }

        public BukkitMCPlayerChatEvent(BukkitMCPlayerChatEvent event) {
            super((PlayerEvent)event.pce);
            this.pce = event.pce;
        }

        public static BukkitMCPlayerChatEvent _instantiate(MCPlayer player2, String message, String format) {
            AsyncPlayerChatEvent apce = new AsyncPlayerChatEvent(false, ((BukkitMCPlayer)player2)._Player(), message, new HashSet(Bukkit.getServer().getOnlinePlayers()));
            apce.setFormat(format);
            return new BukkitMCPlayerChatEvent(apce);
        }

        @Override
        public String getMessage() {
            return this.pce.getMessage();
        }

        @Override
        public void setMessage(String message) {
            this.pce.setMessage(message);
        }

        @Override
        public List<MCPlayer> getRecipients() {
            ArrayList<MCPlayer> players = new ArrayList<MCPlayer>();
            for (Player p2 : this.pce.getRecipients()) {
                players.add(new BukkitMCPlayer((Entity)p2));
            }
            return players;
        }

        @Override
        public void setRecipients(List<MCPlayer> list) {
            this.pce.getRecipients().clear();
            for (MCPlayer p2 : list) {
                this.pce.getRecipients().add(((BukkitMCPlayer)p2)._Player());
            }
        }

        @Override
        public String getFormat() {
            return this.pce.getFormat();
        }

        @Override
        public void setFormat(String format) {
            this.pce.setFormat(format);
        }
    }

    public static class BukkitMCPlayerLoginEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerLoginEvent {
        PlayerLoginEvent event;

        public BukkitMCPlayerLoginEvent(PlayerLoginEvent e) {
            super((PlayerEvent)e);
            this.event = e;
        }

        @Override
        public String getName() {
            return this.event.getPlayer().getName();
        }

        @Override
        public String getUniqueId() {
            return this.event.getPlayer().getUniqueId().toString();
        }

        @Override
        public String getKickMessage() {
            return this.event.getKickMessage();
        }

        @Override
        public void setKickMessage(String msg2) {
            this.event.setKickMessage(msg2);
        }

        @Override
        public String getResult() {
            return this.event.getResult().toString();
        }

        @Override
        public void setResult(String rst) {
            this.event.setResult(PlayerLoginEvent.Result.valueOf((String)rst.toUpperCase()));
        }

        @Override
        public String getIP() {
            return this.event.getAddress().getHostAddress();
        }

        @Override
        public String getHostname() {
            return this.event.getHostname();
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerPortalEvent
    extends BukkitMCPlayerTeleportEvent
    implements MCPlayerPortalEvent {
        PlayerPortalEvent p;

        public BukkitMCPlayerPortalEvent(PlayerPortalEvent event) {
            super((PlayerTeleportEvent)event);
            this.p = event;
        }

        @Override
        public MCLocation getTo() {
            if (this.e.getTo() == null) {
                return null;
            }
            return new BukkitMCLocation(this.e.getTo());
        }

        @Override
        public void setTo(MCLocation newloc) {
            super.setTo(newloc);
        }

        @Override
        public int getSearchRadius() {
            return this.p.getSearchRadius();
        }

        @Override
        public void setSearchRadius(int radius) {
            this.p.setSearchRadius(radius);
        }

        @Override
        public int getCreationRadius() {
            return this.p.getCreationRadius();
        }

        @Override
        public void setCreationRadius(int radius) {
            this.p.setCreationRadius(radius);
        }

        @Override
        public boolean canCreatePortal() {
            return this.p.getCanCreatePortal();
        }

        @Override
        public void setCanCreatePortal(boolean canCreate) {
            this.p.setCanCreatePortal(canCreate);
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCPlayerTeleportEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerTeleportEvent {
        PlayerTeleportEvent e;

        public BukkitMCPlayerTeleportEvent(PlayerTeleportEvent e) {
            super((PlayerEvent)e);
            this.e = e;
        }

        @Override
        public MCLocation getFrom() {
            return new BukkitMCLocation(this.e.getFrom());
        }

        @Override
        public MCLocation getTo() {
            return new BukkitMCLocation(this.e.getTo());
        }

        @Override
        public MCTeleportCause getCause() {
            return (MCTeleportCause)((Object)BukkitMCTeleportCause.getConvertor().getAbstractedEnum(this.e.getCause()));
        }

        @Override
        public void setFrom(MCLocation oldloc) {
            this.e.setFrom(((BukkitMCLocation)oldloc)._Location());
        }

        @Override
        public void setTo(MCLocation newloc) {
            World w = ((BukkitMCWorld)newloc.getWorld()).__World();
            Location loc = new Location(w, newloc.getX(), newloc.getY(), newloc.getZ(), newloc.getPitch(), newloc.getYaw());
            this.e.setTo(loc);
        }

        @Override
        public void setCancelled(boolean state) {
            this.e.setCancelled(state);
        }

        @Override
        public boolean isCancelled() {
            return this.e.isCancelled();
        }
    }

    public static class BukkitMCPlayerKickEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerKickEvent {
        PlayerKickEvent e;

        public BukkitMCPlayerKickEvent(PlayerKickEvent e) {
            super((PlayerEvent)e);
            this.e = e;
        }

        @Override
        public String getMessage() {
            return this.e.getLeaveMessage();
        }

        @Override
        public void setMessage(String message) {
            this.e.setLeaveMessage(message);
        }

        @Override
        public String getReason() {
            return this.e.getReason();
        }

        @Override
        public void setReason(String message) {
            this.e.setReason(message);
        }

        @Override
        public boolean isCancelled() {
            return this.e.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancelled) {
            this.e.setCancelled(cancelled);
        }
    }

    public static class BukkitMCPlayerLeaveBedEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerLeaveBedEvent {
        PlayerBedLeaveEvent event;

        public BukkitMCPlayerLeaveBedEvent(PlayerBedLeaveEvent event) {
            super((PlayerEvent)event);
            this.event = event;
        }

        @Override
        public MCBlock getBed() {
            return new BukkitMCBlock(this.event.getBed());
        }
    }

    public static class BukkitMCPlayerEnterBedEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerEnterBedEvent {
        PlayerBedEnterEvent event;

        public BukkitMCPlayerEnterBedEvent(PlayerBedEnterEvent event) {
            super((PlayerEvent)event);
            this.event = event;
        }

        @Override
        public MCBlock getBed() {
            return new BukkitMCBlock(this.event.getBed());
        }

        @Override
        public MCEnterBedResult getResult() {
            return (MCEnterBedResult)((Object)BukkitMCEnterBedResult.getConvertor().getAbstractedEnum(this.event.getBedEnterResult()));
        }
    }

    public static class BukkitMCPlayerItemConsumeEvent
    extends BukkitMCPlayerEvent
    implements MCPlayerItemConsumeEvent {
        PlayerItemConsumeEvent pic;

        public BukkitMCPlayerItemConsumeEvent(PlayerItemConsumeEvent event) {
            super((PlayerEvent)event);
            this.pic = event;
        }

        @Override
        public MCItemStack getItem() {
            return new BukkitMCItemStack(this.pic.getItem());
        }

        @Override
        public void setItem(MCItemStack item) {
            this.pic.setItem(((BukkitMCItemStack)item).asItemStack());
        }

        @Override
        public MCEquipmentSlot getHand() {
            if (this.pic.getHand() == EquipmentSlot.HAND) {
                return MCEquipmentSlot.WEAPON;
            }
            return MCEquipmentSlot.OFF_HAND;
        }

        public static BukkitMCPlayerItemConsumeEvent _instantiate(MCPlayer player2, MCItemStack item) {
            return new BukkitMCPlayerItemConsumeEvent(new PlayerItemConsumeEvent(((BukkitMCPlayer)player2)._Player(), ((BukkitMCItemStack)item).asItemStack()));
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static abstract class BukkitMCPlayerEvent
    implements MCPlayerEvent {
        PlayerEvent pe;

        public BukkitMCPlayerEvent(PlayerEvent event) {
            this.pe = event;
        }

        @Override
        public Object _GetObject() {
            return this.pe;
        }

        @Override
        public MCPlayer getPlayer() {
            return new BukkitMCPlayer((Entity)this.pe.getPlayer());
        }
    }

    @abstraction(type=Implementation.Type.BUKKIT)
    public static class BukkitMCFoodLevelChangeEvent
    implements MCFoodLevelChangeEvent {
        FoodLevelChangeEvent event;

        public BukkitMCFoodLevelChangeEvent(FoodLevelChangeEvent event) {
            this.event = event;
        }

        @Override
        public MCHumanEntity getEntity() {
            return new BukkitMCHumanEntity((Entity)this.event.getEntity());
        }

        @Override
        public int getDifference() {
            return this.event.getEntity().getFoodLevel() - this.getFoodLevel();
        }

        @Override
        public int getFoodLevel() {
            return this.event.getFoodLevel();
        }

        @Override
        public void setFoodLevel(int level) {
            this.event.setFoodLevel(level);
        }

        @Override
        public MCItemStack getItem() {
            if (this.event.getItem() == null) {
                return null;
            }
            return new BukkitMCItemStack(this.event.getItem());
        }

        @Override
        public boolean isCancelled() {
            return this.event.isCancelled();
        }

        @Override
        public void setCancelled(boolean cancel2) {
            this.event.setCancelled(cancel2);
        }

        @Override
        public Object _GetObject() {
            return this.event;
        }
    }
}

