/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.asm;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.annotations.api;
import com.laytonsmith.annotations.noprofile;
import com.laytonsmith.annotations.seealso;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.LogLevel;
import com.laytonsmith.core.ParseTree;
import com.laytonsmith.core.Script;
import com.laytonsmith.core.asm.IRBuilder;
import com.laytonsmith.core.asm.IRData;
import com.laytonsmith.core.compiler.SelfStatement;
import com.laytonsmith.core.compiler.analysis.Scope;
import com.laytonsmith.core.compiler.analysis.StaticAnalysis;
import com.laytonsmith.core.compiler.signature.FunctionSignatures;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.CFunction;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.environments.Environment;
import com.laytonsmith.core.exceptions.ConfigCompileException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.functions.ExampleScript;
import com.laytonsmith.core.functions.Function;
import com.laytonsmith.core.functions.FunctionBase;
import com.laytonsmith.core.functions.FunctionList;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.snapins.PackagePermission;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public abstract class LLVMFunction
implements FunctionBase,
Function {
    private boolean shouldProfile = !this.getClass().isAnnotationPresent(noprofile.class);
    private static final Class[] EMPTY_CLASS = new Class[0];

    @Override
    public String docs() {
        return this.getDefaultDocs();
    }

    private FunctionBase getDefaultFunction() throws ConfigCompileException {
        CFunction f = new CFunction(this.getName(), Target.UNKNOWN);
        FunctionBase fb = FunctionList.getFunction(f, api.Platforms.INTERPRETER_JAVA, null);
        return fb;
    }

    private String getDefaultDocs() {
        try {
            FunctionBase fb = this.getDefaultFunction();
            return fb.docs();
        }
        catch (ConfigCompileException ex) {
            return "mixed {...} This function is missing documentation. Please report it.";
        }
    }

    @Override
    public boolean isSelfStatement(Target t, Environment env, List<ParseTree> nodes, Set<Class<? extends Environment.EnvironmentImpl>> envs) throws ConfigCompileException {
        try {
            FunctionBase fb = this.getDefaultFunction();
            if (fb instanceof Function) {
                Function f = (Function)fb;
                return f.isSelfStatement(t, env, nodes, envs);
            }
        }
        catch (ConfigCompileException configCompileException) {
            // empty catch block
        }
        return this.getClass().getAnnotation(SelfStatement.class) != null;
    }

    @Override
    public boolean appearInDocumentation() {
        return true;
    }

    @Override
    public PackagePermission getPermission() {
        return PackagePermission.NO_PERMISSIONS_NEEDED;
    }

    @Override
    public boolean isCore() {
        return true;
    }

    @Override
    public boolean isRestricted() {
        return false;
    }

    @Override
    public final boolean preResolveVariables() {
        return true;
    }

    @Override
    public Boolean runAsync() {
        return null;
    }

    @Override
    public final Mixed exec(Target t, Environment environment, Mixed ... args2) throws ConfigRuntimeException {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public FunctionSignatures getSignatures() {
        return null;
    }

    @Override
    public CClassType getReturnType(Target t, List<CClassType> argTypes, List<Target> argTargets, Environment env, Set<ConfigCompileException> exceptions) {
        return CClassType.AUTO;
    }

    @Override
    public CClassType typecheck(StaticAnalysis analysis, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
        List<ParseTree> children = ast.getChildren();
        ArrayList<CClassType> argTypes = new ArrayList<CClassType>(children.size());
        ArrayList<Target> argTargets = new ArrayList<Target>(children.size());
        for (ParseTree child : children) {
            argTypes.add(analysis.typecheck(child, env, exceptions));
            argTargets.add(child.getTarget());
        }
        return this.getReturnType(ast.getTarget(), argTypes, argTargets, env, exceptions);
    }

    @Override
    public Scope linkScope(StaticAnalysis analysis, Scope parentScope, ParseTree ast, Environment env, Set<ConfigCompileException> exceptions) {
        Scope scope = parentScope;
        for (ParseTree child : ast.getChildren()) {
            scope = analysis.linkScope(scope, child, env, exceptions);
        }
        return scope;
    }

    @Override
    public ParseTree postParseRewrite(ParseTree ast, Environment env, Set<Class<? extends Environment.EnvironmentImpl>> envs, Set<ConfigCompileException> exceptions) {
        return null;
    }

    @Override
    public ExampleScript[] examples() throws ConfigCompileException {
        try {
            FunctionBase fb = this.getDefaultFunction();
            if (fb instanceof Function) {
                return ((Function)fb).examples();
            }
        }
        catch (ConfigCompileException configCompileException) {
            // empty catch block
        }
        return new ExampleScript[0];
    }

    @Override
    public boolean shouldProfile() {
        return this.shouldProfile;
    }

    @Override
    public LogLevel profileAt() {
        return LogLevel.VERBOSE;
    }

    @Override
    public String profileMessage(Mixed ... args2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public String profileMessageS(List<ParseTree> args2) {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(this.getClass());
    }

    @Override
    public Class<? extends Documentation>[] seeAlso() {
        seealso see = this.getClass().getAnnotation(seealso.class);
        if (see == null) {
            return EMPTY_CLASS;
        }
        return see.value();
    }

    @Override
    public int compareTo(Function o) {
        return this.getName().compareTo(o.getName());
    }

    public abstract IRData buildIR(IRBuilder var1, Target var2, Environment var3, ParseTree ... var4) throws ConfigCompileException;

    @Override
    public final boolean useSpecialExec() {
        throw new UnsupportedOperationException("Not supported.");
    }

    @Override
    public final Mixed execs(Target t, Environment env, Script parent, ParseTree ... nodes) {
        throw new UnsupportedOperationException("Not supported.");
    }

    public void addStartupCode(IRBuilder builder, Environment startupEnv, Target t) {
    }
}

