/*
 * Decompiled with CFR 0.152.
 */
package com.laytonsmith.core.natives.interfaces;

import com.laytonsmith.PureUtilities.ClassLoading.ClassDiscovery;
import com.laytonsmith.PureUtilities.SimpleVersion;
import com.laytonsmith.PureUtilities.Version;
import com.laytonsmith.annotations.typeof;
import com.laytonsmith.core.Documentation;
import com.laytonsmith.core.FullyQualifiedClassName;
import com.laytonsmith.core.MSVersion;
import com.laytonsmith.core.SimpleDocumentation;
import com.laytonsmith.core.constructs.CClassType;
import com.laytonsmith.core.constructs.Construct;
import com.laytonsmith.core.constructs.Target;
import com.laytonsmith.core.exceptions.CRE.CREIllegalArgumentException;
import com.laytonsmith.core.exceptions.CRE.CREIndexOverflowException;
import com.laytonsmith.core.exceptions.CRE.CREUnsupportedOperationException;
import com.laytonsmith.core.exceptions.ConfigRuntimeException;
import com.laytonsmith.core.natives.interfaces.Iterable;
import com.laytonsmith.core.natives.interfaces.MEnumTypeValue;
import com.laytonsmith.core.natives.interfaces.Mixed;
import com.laytonsmith.core.objects.AccessModifier;
import com.laytonsmith.core.objects.ObjectModifier;
import com.laytonsmith.core.objects.ObjectType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.AbstractList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

@typeof(value="ms.lang.enum")
public abstract class MEnumType
implements Mixed,
Iterable {
    public static final CClassType TYPE = CClassType.get(MEnumType.class);
    private static final MEnumType ROOT_TYPE = new MEnumType(){

        @Override
        protected List<MEnumTypeValue> getValues() {
            throw new UnsupportedOperationException("The root MEnumType is a meta object, and cannot be used normally. There are no values in the class.");
        }
    };
    private Target target;
    private volatile List<MEnumTypeValue> values = null;
    private final Object lock = new Object();

    public static MEnumType FromEnum(FullyQualifiedClassName fqcn, Class<Enum<?>> enumClass, String docs, Version since) {
        return MEnumType.FromPartialEnum(fqcn, enumClass, enumClass.getEnumConstants(), docs, since);
    }

    public static MEnumType FromPartialEnum(final FullyQualifiedClassName fqcn, final Class<?> enumClass, Enum<?>[] values2, final String docs, final Version since) {
        final Enum[] constants = values2;
        return new MEnumType(){

            @Override
            public String docs() {
                Object d;
                Method enumDocs;
                if (docs != null) {
                    return docs;
                }
                try {
                    enumDocs = enumClass.getDeclaredMethod("enumDocs", new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException ex) {
                    return "This enum does not have documentation. Either pass in the docs, or implement public static String enumDocs() in the enum.";
                }
                try {
                    d = enumDocs.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    d = null;
                }
                if (d instanceof String) {
                    return (String)d;
                }
                return "The return type of the enumDocs method is wrong. It must return a String";
            }

            @Override
            public Version since() {
                Object d;
                Method enumSince;
                if (since != null) {
                    return since;
                }
                try {
                    enumSince = enumClass.getDeclaredMethod("enumSince", new Class[0]);
                }
                catch (NoSuchMethodException | SecurityException ex) {
                    return new SimpleVersion(0, 0, 0);
                }
                try {
                    d = enumSince.invoke(null, new Object[0]);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                    d = null;
                }
                if (d instanceof Version) {
                    return (Version)d;
                }
                return new SimpleVersion(0, 0, 0);
            }

            @Override
            public CClassType[] getSuperclasses() {
                return new CClassType[]{TYPE};
            }

            @Override
            public String getName() {
                return fqcn.getFQCN();
            }

            @Override
            public URL getSourceJar() {
                return ClassDiscovery.GetClassContainer(enumClass);
            }

            @Override
            public boolean isInstanceOf(CClassType type) {
                return Mixed.TYPE.equals(type) || TYPE.equals(type) || this.typeof().equals(type);
            }

            @Override
            public boolean isInstanceOf(Class<? extends Mixed> type) {
                return type.isAssignableFrom(this.getClass());
            }

            @Override
            public CClassType typeof() {
                try {
                    return CClassType.get(fqcn);
                }
                catch (ClassNotFoundException ex) {
                    throw new Error(ex);
                }
            }

            @Override
            public String val() {
                return this.getName();
            }

            @Override
            public List<MEnumTypeValue> getValues() {
                return new AbstractList<MEnumTypeValue>(){

                    @Override
                    public MEnumTypeValue get(final int index) {
                        final Enum v = constants[index];
                        return new MEnumTypeValue(){
                            private Target t = Target.UNKNOWN;

                            @Override
                            public int ordinal() {
                                return index;
                            }

                            @Override
                            public String name() {
                                return v.name();
                            }

                            @Override
                            public URL getSourceJar() {
                                return ClassDiscovery.GetClassContainer(enumClass);
                            }

                            @Override
                            public Class<? extends Documentation>[] seeAlso() {
                                if (SimpleDocumentation.class.isAssignableFrom(v.getDeclaringClass())) {
                                    try {
                                        return (Class[])v.getDeclaringClass().getDeclaredMethod("seeAlso", new Class[0]).invoke((Object)v, new Object[0]);
                                    }
                                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                                return new Class[0];
                            }

                            @Override
                            public String getName() {
                                return v.name();
                            }

                            @Override
                            public String docs() {
                                if (SimpleDocumentation.class.isAssignableFrom(v.getDeclaringClass())) {
                                    try {
                                        return (String)v.getDeclaringClass().getDeclaredMethod("docs", new Class[0]).invoke((Object)v, new Object[0]);
                                    }
                                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                                return "";
                            }

                            @Override
                            public Version since() {
                                if (SimpleDocumentation.class.isAssignableFrom(v.getDeclaringClass())) {
                                    try {
                                        return (Version)v.getDeclaringClass().getDeclaredMethod("since", new Class[0]).invoke((Object)v, new Object[0]);
                                    }
                                    catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                                        throw new RuntimeException(ex);
                                    }
                                }
                                return MSVersion.V0_0_0;
                            }

                            public int hashCode() {
                                return v.hashCode();
                            }

                            public boolean equals(Object obj) {
                                return v.equals(obj);
                            }

                            public String toString() {
                                return v.toString();
                            }

                            @Override
                            public CClassType typeof() {
                                try {
                                    return CClassType.get(fqcn);
                                }
                                catch (ClassNotFoundException ex) {
                                    throw new Error(ex);
                                }
                            }

                            @Override
                            public boolean isInstanceOf(CClassType type) {
                                return Construct.isInstanceof((Mixed)this, type);
                            }

                            @Override
                            public boolean isInstanceOf(Class<? extends Mixed> type) {
                                return Construct.isInstanceof((Mixed)this, type);
                            }

                            @Override
                            public CClassType getContainingClass() {
                                return null;
                            }

                            @Override
                            public AccessModifier getAccessModifier() {
                                return AccessModifier.PUBLIC;
                            }

                            @Override
                            public Set<ObjectModifier> getObjectModifiers() {
                                return EnumSet.of(ObjectModifier.FINAL, ObjectModifier.STATIC, ObjectModifier.ABSTRACT);
                            }

                            @Override
                            public ObjectType getObjectType() {
                                return ObjectType.ENUM;
                            }

                            @Override
                            public CClassType[] getInterfaces() {
                                return new CClassType[0];
                            }

                            @Override
                            public CClassType[] getSuperclasses() {
                                return new CClassType[]{TYPE};
                            }

                            @Override
                            public Mixed clone() throws CloneNotSupportedException {
                                return this;
                            }

                            @Override
                            public Target getTarget() {
                                return this.t;
                            }

                            @Override
                            public void setTarget(Target target) {
                                this.t = target;
                            }

                            @Override
                            public String val() {
                                return this.getName();
                            }
                        };
                    }

                    @Override
                    public int size() {
                        return constants.length;
                    }
                };
            }

            @Override
            public boolean getBooleanValue(Target t) {
                return true;
            }
        };
    }

    public static MEnumType getRootEnumType() {
        return ROOT_TYPE;
    }

    @Override
    public String getName() {
        return TYPE.getName();
    }

    @Override
    public String val() {
        return TYPE.getName();
    }

    @Override
    public void setTarget(Target target) {
        this.target = target;
    }

    @Override
    public Target getTarget() {
        return this.target;
    }

    @Override
    public MEnumType clone() throws CloneNotSupportedException {
        return this;
    }

    @Override
    public String docs() {
        return "This is the base type for all enums in MethodScript.";
    }

    @Override
    public Version since() {
        return MSVersion.V3_3_4;
    }

    @Override
    public CClassType[] getSuperclasses() {
        return new CClassType[]{Mixed.TYPE};
    }

    @Override
    public CClassType[] getInterfaces() {
        return new CClassType[]{Iterable.TYPE};
    }

    @Override
    public ObjectType getObjectType() {
        return ObjectType.CLASS;
    }

    @Override
    public Set<ObjectModifier> getObjectModifiers() {
        return EnumSet.of(ObjectModifier.FINAL, ObjectModifier.ABSTRACT);
    }

    @Override
    public AccessModifier getAccessModifier() {
        return AccessModifier.PUBLIC;
    }

    @Override
    public CClassType getContainingClass() {
        return null;
    }

    @Override
    public boolean isInstanceOf(CClassType type) {
        return TYPE.equals(type);
    }

    @Override
    public boolean isInstanceOf(Class<? extends Mixed> type) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public CClassType typeof() {
        return TYPE;
    }

    @Override
    public URL getSourceJar() {
        return ClassDiscovery.GetClassContainer(MEnumType.class);
    }

    @Override
    public Class<? extends Documentation>[] seeAlso() {
        return new Class[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MEnumTypeValue> values() {
        List<MEnumTypeValue> values2 = this.values;
        if (values2 == null) {
            Object object = this.lock;
            synchronized (object) {
                values2 = this.values;
                if (values2 == null) {
                    this.values = values2 = this.getValues();
                }
            }
        }
        return values2;
    }

    @Override
    public Mixed get(String index, Target t) throws ConfigRuntimeException {
        for (MEnumTypeValue v : this.values()) {
            if (!v.name().equals(index)) continue;
            return v;
        }
        throw new CREIllegalArgumentException(index + " cannot be found in " + this.typeof(), t);
    }

    @Override
    public Mixed get(int index, Target t) throws ConfigRuntimeException {
        if (index >= this.values().size()) {
            throw new CREIndexOverflowException("The index " + index + " is out of bounds", t);
        }
        return this.values().get(index);
    }

    @Override
    public Mixed get(Mixed index, Target t) throws ConfigRuntimeException {
        return this.get(index.val(), t);
    }

    @Override
    public Set<Mixed> keySet() {
        return this.values().stream().collect(Collectors.toSet());
    }

    @Override
    public long size() {
        return this.values().size();
    }

    @Override
    public boolean isAssociative() {
        return true;
    }

    @Override
    public boolean canBeAssociative() {
        return true;
    }

    @Override
    public Mixed slice(int begin, int end, Target t) {
        throw new CREUnsupportedOperationException("Cannot slice an enum", t);
    }

    protected abstract List<MEnumTypeValue> getValues();

    @Override
    public boolean getBooleanValue(Target t) {
        return true;
    }
}

